/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.agentx.master;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.agent.DefaultMOScope;
import org.snmp4j.agent.MOQuery;
import org.snmp4j.agent.MOScope;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.agentx.master.AgentXNode;
import org.snmp4j.agent.agentx.master.AgentXNodeQuery;
import org.snmp4j.agent.agentx.master.AgentXPending;
import org.snmp4j.agent.agentx.master.AgentXPendingGet;
import org.snmp4j.agent.agentx.master.AgentXPendingSet;
import org.snmp4j.agent.agentx.master.AgentXRegEntry;
import org.snmp4j.agent.agentx.master.AgentXSearchRange;
import org.snmp4j.agent.request.SnmpRequest;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public class AgentXQueue {
    private static final LogAdapter LOGGER = LogFactory.getLogger(AgentXQueue.class);
    private LinkedList<AgentXQueueEntry<?>> queue = new LinkedList();
    private MOServer[] servers;

    public void setServer4BulkOptimization(MOServer[] servers) {
        this.servers = servers;
    }

    public MOServer[] getServer4BulkOptimization() {
        return this.servers;
    }

    public synchronized <A extends Address> boolean add(VariableBinding vb, SnmpRequest.SnmpSubRequest subRequest, AgentXRegEntry<A> entry) {
        SnmpRequest request = subRequest.getRequest();
        AgentXPendingSet<A> pending = (AgentXPendingSet<A>)this.get(entry.getSession().getSessionID(), request.getTransactionID());
        if (pending == null) {
            pending = new AgentXPendingSet<A>(entry, subRequest.getSnmpRequest());
            this.insertIntoQueue(request.getTransactionID(), pending);
        }
        if (!pending.isPending()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Serializable)((Object)("Variable binding " + vb + " not added because AgentX request " + pending + " is waiting for response")));
            }
            return false;
        }
        pending.add(subRequest, vb);
        return true;
    }

    private synchronized <A extends Address> void insertIntoQueue(int transactionID, AgentXPending<A> pending) {
        AgentXRegEntry<A> reg = pending.getRegistration();
        int timeout = reg.getTimeout();
        if (timeout == 0) {
            timeout = reg.getSession().getTimeout() & 0xFF;
        }
        pending.setTimeout(timeout);
        AgentXQueueEntry<Object> entry = this.getQueueEntry(transactionID, false);
        if (entry == null) {
            entry = new AgentXQueueEntry(transactionID);
            this.queue.add(entry);
        }
        entry.addEntry(pending);
    }

    public synchronized <A extends Address> boolean add(AgentXSearchRange searchRange, AgentXRegEntry<A> entry, boolean repeater) {
        SnmpRequest request = searchRange.getReferenceSubRequest().getRequest();
        AgentXPendingGet<A> pending = (AgentXPendingGet<A>)this.get(entry.getSession().getSessionID(), request.getTransactionID());
        if (pending == null) {
            if (this.servers != null && ((CommandResponderEvent)request.getSource()).getPDU().getType() == -91) {
                this.optimizeSearchRange(searchRange, entry);
            }
            pending = new AgentXPendingGet<A>(entry, request, searchRange);
            this.insertIntoQueue(request.getTransactionID(), pending);
        } else if (pending.isPending()) {
            switch (((CommandResponderEvent)request.getSource()).getPDU().getType()) {
                case -91: {
                    for (AgentXSearchRange psr : pending.getSearchRanges()) {
                        int repCount = request.getRepeaterCount();
                        if (repCount <= 0 || (searchRange.getReferenceSubRequest().getIndex() - pending.getNonRepeater() - (psr.getReferenceSubRequest().getIndex() - request.getNonRepeaters())) % repCount != 0) continue;
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug((Serializable)((Object)("Repetition not added because of pending AgentX processing of " + pending + " and repetition " + psr)));
                        }
                        return false;
                    }
                    if (this.servers == null) break;
                    this.optimizeSearchRange(searchRange, entry);
                    break;
                }
            }
            pending.addSearchRange(searchRange);
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Serializable)((Object)("Search range " + searchRange + " not added because AgentX request " + pending + " is not pending")));
            }
            return false;
        }
        if (!repeater) {
            pending.incNonRepeater();
        }
        return true;
    }

    private MOServer getServer(OctetString context) {
        MOServer[] sc;
        for (MOServer s : sc = this.servers) {
            if (!s.isContextSupported(context)) continue;
            return s;
        }
        return null;
    }

    protected void optimizeSearchRange(AgentXSearchRange searchRange, AgentXRegEntry<?> entry) {
        DefaultMOScope scope = new DefaultMOScope(searchRange.getUpperBound(), !searchRange.isUpperIncluded(), null, false);
        AgentXNodeQuery query = new AgentXNodeQuery(entry.getContext(), (MOScope)scope, 2);
        MOScope requestScope = searchRange.getReferenceSubRequest().getScope();
        MOServer server = this.getServer(entry.getContext());
        if (server == null) {
            return;
        }
        AgentXNode node = (AgentXNode)server.lookup((MOQuery)query, AgentXNode.class);
        while (node != null) {
            AgentXRegEntry<?> activeReg = node.getActiveRegistration();
            MOScope region = node.getScope();
            if (activeReg != null && activeReg.getSession().equals(entry.getSession())) {
                if (requestScope.getUpperBound() != null && requestScope.getUpperBound().compareTo((Variable)region.getUpperBound()) <= 0) {
                    searchRange.setUpperBound(requestScope.getUpperBound());
                    searchRange.setUpperIncluded(requestScope.isUpperIncluded());
                    break;
                }
            } else {
                if (searchRange.getUpperBound() != null && searchRange.getUpperBound().compareTo((Variable)region.getLowerBound()) < 0) break;
                searchRange.setUpperBound(region.getLowerBound());
                searchRange.setUpperIncluded(!region.isLowerIncluded());
                break;
            }
            searchRange.setUpperBound(region.getUpperBound());
            searchRange.setUpperIncluded(region.isUpperIncluded());
            node = (AgentXNode)server.lookup((MOQuery)AgentXQueue.nextQuery(query, node), AgentXNode.class);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Serializable)((Object)("Optimized upper bound for bulk AgentX request to " + searchRange)));
        }
    }

    private static AgentXNodeQuery nextQuery(AgentXNodeQuery lastQuery, AgentXNode lastNode) {
        if (lastNode != null) {
            lastQuery.getMutableScope().setLowerBound(lastNode.getScope().getUpperBound());
            lastQuery.getMutableScope().setLowerIncluded(false);
        }
        return lastQuery;
    }

    public synchronized AgentXPending<?> get(int sessionID, int transactionID) {
        AgentXQueueEntry<?> entry = this.getQueueEntry(transactionID, false);
        if (entry != null) {
            return entry.get(sessionID, false);
        }
        return null;
    }

    public synchronized AgentXPending<?> remove(int sessionID, int transactionID) {
        AgentXQueueEntry<?> entry = this.getQueueEntry(transactionID, false);
        if (entry != null) {
            return entry.get(sessionID, true);
        }
        return null;
    }

    public synchronized AgentXQueueEntry<?> get(int transactionID) {
        return this.getQueueEntry(transactionID, false);
    }

    public synchronized void removeAll(int transactionID) {
        this.getQueueEntry(transactionID, true);
    }

    private AgentXQueueEntry<?> getQueueEntry(int transactionID, boolean remove) {
        Iterator it = this.queue.iterator();
        while (it.hasNext()) {
            AgentXQueueEntry entry = (AgentXQueueEntry)it.next();
            if (entry.transactionID != transactionID) continue;
            if (remove) {
                it.remove();
            }
            return entry;
        }
        return null;
    }

    public class AgentXQueueEntry<A extends Address>
    implements Comparable<AgentXQueueEntry<A>> {
        private int transactionID;
        private LinkedList<AgentXPending<A>> requests;
        private int minTimeout = 255;
        private long timestamp = 0L;

        public AgentXQueueEntry(int transactionID) {
            this.transactionID = transactionID;
            this.requests = new LinkedList();
        }

        public final synchronized void addEntry(AgentXPending<A> pendingRequest) {
            this.requests.add(pendingRequest);
            if (this.minTimeout > pendingRequest.getTimeout()) {
                this.minTimeout = pendingRequest.getTimeout();
            }
        }

        public final void updateTimestamp() {
            this.timestamp = System.currentTimeMillis();
        }

        public final long getTimestamp() {
            return this.timestamp;
        }

        public final int getMinTimeout() {
            return this.minTimeout;
        }

        public boolean equals(Object obj) {
            if (obj instanceof AgentXQueueEntry) {
                AgentXQueueEntry other = (AgentXQueueEntry)obj;
                return this.transactionID == other.transactionID;
            }
            return false;
        }

        public int hashCode() {
            return this.transactionID;
        }

        public String toString() {
            return "AgentXQueueEntry[transactionID=" + this.transactionID + ",requests=" + this.requests + "]";
        }

        @Override
        public int compareTo(AgentXQueueEntry<A> other) {
            return this.transactionID - other.transactionID;
        }

        public final synchronized AgentXPending<A> get(int sessionID, boolean remove) {
            Iterator it = this.requests.iterator();
            while (it.hasNext()) {
                AgentXPending p = (AgentXPending)it.next();
                if (p.getSession().getSessionID() != sessionID) continue;
                if (remove) {
                    it.remove();
                    if (this.requests.isEmpty()) {
                        AgentXQueue.this.queue.remove(this);
                    }
                }
                return p;
            }
            return null;
        }

        public final synchronized boolean isEmpty() {
            return this.requests.isEmpty();
        }

        public final synchronized Collection<AgentXPending<A>> getPending() {
            LinkedList<AgentXPending<A>> pending = new LinkedList<AgentXPending<A>>();
            for (AgentXPending agentXPending : this.requests) {
                if (!agentXPending.isPending()) continue;
                pending.add(agentXPending);
            }
            return pending;
        }
    }
}

