/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.agentx;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.snmp4j.TransportMapping;
import org.snmp4j.TransportStateReference;
import org.snmp4j.agent.agentx.AgentXCommandEvent;
import org.snmp4j.agent.agentx.AgentXCommandListener;
import org.snmp4j.agent.agentx.AgentXMessageDispatcher;
import org.snmp4j.agent.agentx.AgentXPDU;
import org.snmp4j.agent.agentx.AgentXParseException;
import org.snmp4j.agent.agentx.AgentXResponsePDU;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.PduHandle;
import org.snmp4j.mp.PduHandleCallback;
import org.snmp4j.smi.Address;
import org.snmp4j.transport.ConnectionOrientedTransportMapping;
import org.snmp4j.transport.TransportListener;

public class AgentXMessageDispatcherImpl
implements AgentXMessageDispatcher {
    private static final LogAdapter logger = LogFactory.getLogger(AgentXMessageDispatcherImpl.class);
    private List<TransportMapping<?>> transportMappings = new ArrayList();
    private List<AgentXCommandListener> commandListener = new ArrayList<AgentXCommandListener>();
    private volatile int nextPacketID = 0;

    public synchronized int getNextPacketID() {
        int nextID;
        if ((nextID = ++this.nextPacketID) <= 0) {
            this.nextPacketID = 1;
            nextID = 1;
        }
        return nextID;
    }

    protected PduHandle createPduHandle() {
        return new PduHandle(this.getNextPacketID());
    }

    @Override
    public synchronized void addTransportMapping(TransportMapping<?> transport) {
        this.transportMappings.add(transport);
        transport.addTransportListener((TransportListener)this);
    }

    @Override
    public Collection<TransportMapping<?>> getTransportMappings() {
        return new ArrayList(this.transportMappings);
    }

    public <A extends Address> void processMessage(TransportMapping<? super A> sourceTransport, A incomingAddress, ByteBuffer wholeMessage, TransportStateReference tmStateReference) {
        block3: {
            ConnectionOrientedTransportMapping connectionOrientedTM = (ConnectionOrientedTransportMapping)sourceTransport;
            try {
                AgentXPDU pdu = AgentXPDU.decode(wholeMessage);
                AgentXCommandEvent<A> event = new AgentXCommandEvent<A>((Object)this, (AgentXMessageDispatcher)this, incomingAddress, connectionOrientedTM, pdu, tmStateReference);
                this.fireCommandEvent(event);
            }
            catch (IOException ex) {
                if (logger.isDebugEnabled()) {
                    ex.printStackTrace();
                }
                logger.warn((Serializable)ex);
                if (!(ex instanceof AgentXParseException)) break block3;
                AgentXCommandEvent<A> event = new AgentXCommandEvent<A>((Object)this, (AgentXMessageDispatcher)this, incomingAddress, connectionOrientedTM, (AgentXParseException)ex, tmStateReference);
                this.fireCommandEvent(event);
            }
        }
    }

    @Override
    public TransportMapping<?> removeTransportMapping(TransportMapping<?> transport) {
        if (this.transportMappings.remove(transport)) {
            transport.removeTransportListener((TransportListener)this);
            return transport;
        }
        return null;
    }

    @Override
    public <A extends Address> PduHandle send(TransportMapping<? super A> transport, A address, AgentXPDU message, PduHandleCallback<AgentXPDU> callback) throws IOException {
        PduHandle handle;
        if (message instanceof AgentXResponsePDU) {
            handle = new PduHandle(message.getPacketID());
        } else {
            handle = this.createPduHandle();
            message.setPacketID(handle.getTransactionID());
        }
        if (callback != null) {
            callback.pduHandleAssigned(handle, (Object)message);
        }
        if (transport != null) {
            this.sendPDU(address, message, transport);
            return handle;
        }
        for (TransportMapping<?> t : this.transportMappings) {
            if (!t.isAddressSupported(address)) continue;
            TransportMapping<?> ta = t;
            this.sendPDU(address, message, ta);
            return handle;
        }
        return null;
    }

    private <A extends Address> void sendPDU(A address, AgentXPDU message, TransportMapping<? super A> transport) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(message.getPayloadLength() + 20);
        message.encode(buf);
        this.send(address, transport, buf, null);
    }

    public <A extends Address> void send(A address, TransportMapping<? super A> transport, ByteBuffer message, TransportStateReference tmStateReference) throws IOException {
        message.flip();
        byte[] bytes = new byte[message.limit()];
        message.get(bytes);
        transport.sendMessage(address, bytes, tmStateReference, 0L, 0);
    }

    protected synchronized void fireCommandEvent(AgentXCommandEvent<?> event) {
        for (AgentXCommandListener aCommandListener : this.commandListener) {
            aCommandListener.processCommand(event);
            if (!event.isProcessed()) continue;
            return;
        }
    }

    @Override
    public synchronized void addCommandListener(AgentXCommandListener l) {
        this.commandListener.add(l);
    }

    @Override
    public synchronized void removeCommandListener(AgentXCommandListener l) {
        this.commandListener.remove(l);
    }
}

