/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.agentx;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.snmp4j.TransportMapping;
import org.snmp4j.agent.agentx.AgentXCommandEvent;
import org.snmp4j.agent.agentx.AgentXCommandListener;
import org.snmp4j.agent.agentx.AgentXMessageDispatcher;
import org.snmp4j.agent.agentx.AgentXPDU;
import org.snmp4j.agent.agentx.AgentXResponseEvent;
import org.snmp4j.agent.agentx.AgentXResponseListener;
import org.snmp4j.agent.agentx.AgentXResponsePDU;
import org.snmp4j.agent.agentx.AgentXSession;
import org.snmp4j.agent.agentx.AgentXTarget;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.PduHandle;
import org.snmp4j.mp.PduHandleCallback;
import org.snmp4j.smi.Address;
import org.snmp4j.transport.TransportListener;

public class AgentX
implements AgentXCommandListener {
    private static final LogAdapter logger = LogFactory.getLogger(AgentX.class);
    private AgentXMessageDispatcher messageDispatcher;
    private Map<PduHandle, PendingRequest<?>> pendingRequests = Collections.synchronizedMap(new HashMap(50));
    private Map<AsyncRequestKey, PduHandle> asyncRequests = Collections.synchronizedMap(new HashMap(50));
    private Timer timer = new Timer(true);
    private ArrayList<AgentXCommandListener> commandListeners;

    public AgentX(AgentXMessageDispatcher dispatcher) {
        this.messageDispatcher = dispatcher;
        this.messageDispatcher.addCommandListener(this);
    }

    public void addTransportMapping(TransportMapping<?> transport) {
        this.messageDispatcher.addTransportMapping(transport);
        transport.addTransportListener((TransportListener)this.messageDispatcher);
    }

    public void removeTransportMapping(TransportMapping<?> transport) {
        transport.removeTransportListener((TransportListener)this.messageDispatcher);
        this.messageDispatcher.removeTransportMapping(transport);
    }

    public synchronized void removeCommandResponder(AgentXCommandListener listener) {
        ArrayList<AgentXCommandListener> l = this.commandListeners;
        if (l != null && l.contains(listener)) {
            l = new ArrayList<AgentXCommandListener>(l);
            l.remove(listener);
            this.commandListeners = l;
        }
    }

    public synchronized void addCommandResponder(AgentXCommandListener listener) {
        ArrayList<AgentXCommandListener> l;
        ArrayList<AgentXCommandListener> arrayList = l = this.commandListeners == null ? new ArrayList<AgentXCommandListener>(2) : this.commandListeners;
        if (!l.contains(listener)) {
            l = new ArrayList<AgentXCommandListener>(l);
            l.add(listener);
        }
        this.commandListeners = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <A extends Address> AgentXResponseEvent<A> send(AgentXPDU pdu, AgentXTarget<A> target, TransportMapping<? super A> transport) throws IOException {
        SyncResponseListener syncResponse = new SyncResponseListener();
        if (!pdu.isConfirmedPDU()) {
            this.sendMessage(pdu, target, transport, null);
            return null;
        }
        SyncResponseListener syncResponseListener = syncResponse;
        synchronized (syncResponseListener) {
            PendingRequest<A> request = new PendingRequest<A>(null, syncResponse, target, pdu, target);
            this.sendMessage(pdu, target, transport, request);
            try {
                while (syncResponse.response == null) {
                    syncResponse.wait();
                }
            }
            catch (InterruptedException iex) {
                logger.warn((Serializable)iex);
            }
            if (syncResponse.response != null && logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Received AgentX response: " + syncResponse.response.getResponse())));
            }
        }
        AgentXResponseEvent responseEvent = syncResponse.response;
        return responseEvent;
    }

    public <A extends Address> void send(AgentXPDU pdu, AgentXTarget<A> target, TransportMapping<? super A> transport, Object userHandle, AgentXResponseListener listener) throws IOException {
        if (listener != null) {
            PendingRequest<A> request = new PendingRequest<A>(null, listener, userHandle, pdu, target);
            this.sendMessage(pdu, target, transport, request);
        } else {
            this.sendMessage(pdu, target, transport, null);
        }
    }

    protected <A extends Address> PduHandle sendMessage(AgentXPDU pdu, AgentXTarget<A> target, TransportMapping<? super A> transport, PduHandleCallback<AgentXPDU> pduHandleCallback) throws IOException {
        return this.messageDispatcher.send(transport, target.getAddress(), pdu, pduHandleCallback);
    }

    @Override
    public <A extends Address> void processCommand(AgentXCommandEvent<A> event) {
        AgentXPDU pdu = event.getCommand();
        PduHandle handle = new PduHandle(pdu.getPacketID());
        if (pdu.getType() == 18) {
            PendingRequest<?> request;
            event.setProcessed(true);
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Removing pending request with handle " + handle)));
            }
            if ((request = this.pendingRequests.remove(handle)) == null) {
                if (logger.isWarnEnabled()) {
                    logger.warn((Serializable)((Object)("Received response that cannot be matched to any outstanding request, address=" + event.getPeerAddress() + ", packetID=" + pdu.getPacketID())));
                }
            } else {
                ((PendingRequest)request).finished = true;
                request.listener.onResponse(new AgentXResponseEvent(this, request.target, event.getPeerAddress(), request.pdu, (AgentXResponsePDU)pdu, request.userObject));
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Fire process PDU event: " + event.toString())));
            }
            this.fireProcessPdu(event);
        }
    }

    @Override
    public Map<AgentXSession<?>, Integer> closeAllSessions(byte reason) {
        throw new UnsupportedOperationException();
    }

    protected void fireProcessPdu(AgentXCommandEvent<?> event) {
        if (this.commandListeners != null) {
            ArrayList<AgentXCommandListener> listeners = this.commandListeners;
            for (AgentXCommandListener listener : listeners) {
                listener.processCommand(event);
                if (!event.isProcessed()) continue;
                return;
            }
        }
    }

    public AgentXMessageDispatcher getMessageDispatcher() {
        return this.messageDispatcher;
    }

    class SyncResponseListener
    implements AgentXResponseListener {
        private AgentXResponseEvent<?> response = null;

        SyncResponseListener() {
        }

        @Override
        public synchronized void onResponse(AgentXResponseEvent<?> event) {
            this.response = event;
            this.notify();
        }

        public AgentXResponseEvent<?> getResponse() {
            return this.response;
        }
    }

    class AsyncPendingRequest<A extends Address>
    extends PendingRequest<A> {
        public AsyncPendingRequest(PduHandle key, AgentXResponseListener listener, Object userObject, AgentXPDU pdu, AgentXTarget<A> target) {
            super(key, listener, userObject, pdu, target);
        }

        @Override
        protected void registerRequest(PduHandle handle) {
            AgentX.this.asyncRequests.put(new AsyncRequestKey(this.pdu, this.listener), handle);
        }
    }

    class PendingRequest<A extends Address>
    extends TimerTask
    implements PduHandleCallback<AgentXPDU> {
        protected PduHandle key;
        protected AgentXResponseListener listener;
        protected Object userObject;
        protected AgentXPDU pdu;
        protected AgentXTarget<A> target;
        private volatile boolean finished = false;

        public PendingRequest(PduHandle key, AgentXResponseListener listener, Object userObject, AgentXPDU pdu, AgentXTarget<A> target) {
            this.key = key;
            this.userObject = userObject;
            this.listener = listener;
            this.pdu = pdu;
            this.target = target;
        }

        protected void registerRequest(PduHandle handle) {
        }

        @Override
        public synchronized void run() {
            AgentX.this.pendingRequests.remove(this.key);
            if (!this.finished) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("AgentX request timed out: " + this.key.getTransactionID())));
                }
                this.finished = true;
                if (this.listener != null) {
                    this.listener.onResponse(new AgentXResponseEvent<Object>(AgentX.this, this.target, null, this.pdu, null, this.userObject));
                }
            }
        }

        public synchronized boolean setFinished() {
            boolean currentState = this.finished;
            this.finished = true;
            return currentState;
        }

        public synchronized void pduHandleAssigned(PduHandle handle, AgentXPDU pdu) {
            if (this.key == null) {
                this.key = handle;
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("New pending request " + pdu + " with handle " + handle)));
                }
                this.registerRequest(handle);
                AgentX.this.pendingRequests.put(handle, this);
                long delay = this.target.getTimeout();
                if (delay < 1000L) {
                    delay = 5000L;
                }
                AgentX.this.timer.schedule((TimerTask)this, delay);
            }
        }
    }

    class AsyncRequestKey {
        private AgentXPDU request;
        private AgentXResponseListener listener;

        public AsyncRequestKey(AgentXPDU request, AgentXResponseListener listener) {
            this.request = request;
            this.listener = listener;
        }

        public boolean equals(Object obj) {
            if (obj instanceof AsyncRequestKey) {
                AsyncRequestKey other = (AsyncRequestKey)obj;
                return this.request.equals(other.request) && this.listener.equals(other.listener);
            }
            return false;
        }

        public int hashCode() {
            return this.request.hashCode();
        }
    }
}

