/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.snmp4j.agent.mo.BufferedMOTableModel;
import org.snmp4j.agent.mo.MOMutableTableModel;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.MOTableRowEvent;
import org.snmp4j.agent.mo.MOTableRowFactory;
import org.snmp4j.agent.mo.MOTableRowFilter;
import org.snmp4j.agent.mo.MOTableRowListener;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.Variable;

public abstract class BufferedMOMutableTableModel<R extends MOTableRow>
extends BufferedMOTableModel<R>
implements MOMutableTableModel<R>,
MOTableRowListener<R> {
    protected BufferedMOMutableTableModel(MOTableRowFactory<R> rowFactory) {
        super(rowFactory);
    }

    public R addRow(R row) {
        Variable[] values = new Variable[row.size()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = row.getValue(i);
        }
        Object previous = this.getRow(row.getIndex());
        if (previous != null) {
            this.writeRow(row.getIndex(), values);
        } else {
            this.insertRow(row.getIndex(), values);
        }
        this.updateBuffer(Collections.singletonList(row), null);
        return previous;
    }

    public synchronized void clear() {
        this.firstRow = null;
        this.lastRow = null;
        this.bufferedChunksList.clear();
        this.bufferedRows.clear();
        this.deleteAllRows();
    }

    public synchronized void clear(MOTableRowFilter<R> filter) {
        BufferedMOTableModel.BufferedMOTableRow lastRowCopy;
        ArrayList<OID> deleted = new ArrayList<OID>();
        Iterator rowIterator = this.iterator();
        while (rowIterator.hasNext()) {
            MOTableRow row = (MOTableRow)rowIterator.next();
            if (filter.passesFilter(row)) continue;
            deleted.add(row.getIndex());
        }
        this.bulkDeleteRows(deleted);
        BufferedMOTableModel.BufferedMOTableRow firstRowCopy = this.firstRow;
        if (firstRowCopy != null && deleted.contains(firstRowCopy.getIndex())) {
            this.firstRow = null;
        }
        if ((lastRowCopy = this.lastRow) != null && deleted.contains(lastRowCopy.getIndex())) {
            this.lastRow = null;
        }
        for (OID index : deleted) {
            BufferedMOTableModel.BufferedMOTableRow bufferedMOMutableTableRow = (BufferedMOTableModel.BufferedMOTableRow)this.bufferedRows.remove(index);
            if (bufferedMOMutableTableRow == null) continue;
            this.bufferedChunksList.remove(bufferedMOMutableTableRow);
        }
    }

    protected abstract void deleteAllRows();

    protected abstract void bulkDeleteRows(List<OID> var1);

    protected abstract void insertRow(OID var1, Variable[] var2);

    protected abstract void writeRow(OID var1, Variable[] var2);

    protected abstract void deleteRow(OID var1);

    public void rowChanged(MOTableRowEvent event) {
        if (event.getType() == 4) {
            Variable[] values = new Variable[event.getRow().size()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = event.getRow().getValue(i);
            }
            this.writeRow(event.getRow().getIndex(), values);
            this.updateBuffer(Collections.singletonList(this.rowFactory.createRow(event.getRow().getIndex(), values)), null);
        }
    }

    @Override
    public R removeRow(OID index) {
        BufferedMOTableModel.BufferedMOTableRow row = this.getRowFromBuffer(index);
        if (row == null) {
            ++this.bufferMisses;
            Variable[] rowValues = this.fetchRow(index);
            if (rowValues != null) {
                MOTableRow r = this.rowFactory.createRow(index, rowValues);
                row = new BufferedMOTableModel.BufferedMOTableRow((BufferedMOTableModel)this, null);
                this.deleteRow(index);
                this.bufferedRows.put(index, row);
                return (R)r;
            }
        } else {
            ++this.bufferHits;
            row.setBufferedRow(null);
            row.setLastRefresh(System.nanoTime());
            this.deleteRow(index);
            return row.getBufferedRow();
        }
        return null;
    }
}

