/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.agentx.subagent;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import org.snmp4j.agent.agentx.AgentX;
import org.snmp4j.agent.agentx.AgentXIndexAllocatePDU;
import org.snmp4j.agent.agentx.AgentXIndexDeallocatePDU;
import org.snmp4j.agent.agentx.AgentXRegisterPDU;
import org.snmp4j.agent.agentx.AgentXResponseEvent;
import org.snmp4j.agent.agentx.AgentXResponsePDU;
import org.snmp4j.agent.agentx.AgentXSession;
import org.snmp4j.agent.agentx.AgentXUnregisterPDU;
import org.snmp4j.agent.agentx.subagent.DefaultAgentXSharedMOTable;
import org.snmp4j.agent.agentx.subagent.index.AnyNewIndexOID;
import org.snmp4j.agent.agentx.subagent.index.NewIndexOID;
import org.snmp4j.agent.agentx.subagent.index.SubAgentXIndexRegistry;
import org.snmp4j.agent.mo.MOTable;
import org.snmp4j.agent.mo.MOTableIndex;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.MOTableRowEvent;
import org.snmp4j.agent.mo.MOTableRowListener;
import org.snmp4j.agent.mo.MOTableSubIndex;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.AbstractVariable;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public class AgentXSharedMOTableSupport<R extends MOTableRow>
implements MOTableRowListener<R> {
    private static final LogAdapter LOGGER = LogFactory.getLogger(AgentXSharedMOTableSupport.class);
    public static final int INDEX_MODE_ALLOCATE = 0;
    public static final int INDEX_MODE_ANY_INDEX = 4;
    public static final int INDEX_MODE_NEW_INDEX = 2;
    private AgentX agentX;
    private AgentXSession session;
    private OctetString context;
    private byte priority = (byte)127;
    private byte indexMode = 0;
    private IndexStrategy indexStrategy = IndexStrategy.firstSubIndexOnly;
    protected SubAgentXIndexRegistry indexRegistry = new SubAgentXIndexRegistry();

    public AgentXSharedMOTableSupport(AgentX agentX, AgentXSession session, OctetString context) {
        this.agentX = agentX;
        this.session = session;
        this.context = context;
        LOGGER.debug((Serializable)((Object)("SharedMOTableSupport created for " + session.getSessionID() + "#" + context)));
    }

    public AgentXSharedMOTableSupport(AgentX agentX, AgentXSession session, OctetString context, byte priority, byte indexAllocationMode) {
        this(agentX, session, context);
        this.priority = priority;
        this.indexMode = indexAllocationMode;
    }

    public void rowChanged(MOTableRowEvent<R> event) {
        if (this.indexMode == 0 && this.getSession().isClosed()) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((CharSequence)("Row event " + event + " ignored, because session to master agent is closed: " + this.getSession()));
            }
            return;
        }
        switch (event.getType()) {
            case 1: {
                byte indexMode = this.getEffectiveIndexMode(event);
                OID index2Allocate = event.getRow().getIndex();
                int status = this.allocateIndex(this.context, event.getTable().getIndexDef(), event.getRow().getIndex().size() == 0 ? indexMode : (byte)0, index2Allocate);
                if (status == 0) break;
                event.setVetoStatus(status);
                break;
            }
            case 2: {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Serializable)((Object)("Registering row for table event: " + event)));
                }
                byte priority = this.getEffectivePriority(event);
                int status = this.registerRow(event.getTable(), event.getRow(), priority);
                if (status == 0) break;
                event.setVetoStatus(status);
                break;
            }
            case 3: {
                byte priority = this.getEffectivePriority(event);
                int status = this.unregisterRow(event.getTable(), event.getRow(), priority);
                if (status != 0 && status != 264) {
                    event.setVetoStatus(status);
                    break;
                }
                OID index2Deallocate = event.getRow().getIndex();
                this.deallocateIndex(this.context, event.getTable().getIndexDef(), index2Deallocate);
                break;
            }
            default: {
                if (!LOGGER.isDebugEnabled()) break;
                LOGGER.debug((Serializable)((Object)("Ignored AgentX shared table event " + event)));
            }
        }
    }

    protected byte getEffectiveIndexMode(MOTableRowEvent<R> event) {
        byte om;
        byte indexMode = this.indexMode;
        if (event.getTable() instanceof DefaultAgentXSharedMOTable && (om = ((DefaultAgentXSharedMOTable)event.getTable()).getOverrideIndexAllocationMode()) != 0) {
            indexMode = om;
        }
        return indexMode;
    }

    protected byte getEffectivePriority(MOTableRowEvent<R> event) {
        byte op;
        byte priority = this.priority;
        if (event.getTable() instanceof DefaultAgentXSharedMOTable && (op = ((DefaultAgentXSharedMOTable)event.getTable()).getOverridePriority()) != 0) {
            priority = op;
        }
        return priority;
    }

    public int allocateIndex(OctetString context, MOTableIndex indexDef, byte indexAllocationMode, OID allocatedIndex) {
        MOTableSubIndex subIndex;
        int i;
        Variable[] indexValues;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Serializable)((Object)("Allocating index " + allocatedIndex + " with strategy " + (Object)((Object)this.indexStrategy) + " for index definition " + indexDef + "with mode " + indexAllocationMode)));
        }
        if (this.indexStrategy == IndexStrategy.noIndexAllocation) {
            return 0;
        }
        VariableBinding[] vbs = new VariableBinding[indexDef.size()];
        if (allocatedIndex instanceof AnyNewIndexOID) {
            indexAllocationMode = (byte)4;
        } else if (allocatedIndex instanceof NewIndexOID) {
            indexAllocationMode = (byte)2;
        }
        if (indexAllocationMode == 0) {
            indexValues = indexDef.getIndexValues(allocatedIndex);
        } else {
            indexValues = new Variable[indexDef.size()];
            for (i = 0; i < indexDef.size(); ++i) {
                subIndex = indexDef.getIndex(i);
                indexValues[i] = AbstractVariable.createFromSyntax((int)subIndex.getSmiSyntax());
            }
        }
        for (i = 0; i < indexDef.size(); ++i) {
            subIndex = indexDef.getIndex(i);
            OID oid = subIndex.getOid();
            if (oid == null) {
                throw new IllegalArgumentException("Sub-index " + i + " has no OID");
            }
            vbs[i] = new VariableBinding();
            vbs[i].setOid(oid);
            vbs[i].setVariable(indexValues[i]);
        }
        block1 : switch (this.indexStrategy) {
            case alwaysFirstSubIndex: {
                VariableBinding[] vb = new VariableBinding[]{vbs[0]};
                vbs = vb;
                break;
            }
            case firstSubIndexOnly: {
                VariableBinding[] vb = new VariableBinding[]{vbs[0]};
                vbs = vb;
                if (this.indexRegistry.allocate(this.session.getSessionID(), context, vb[0], false) == 0) break;
                return 0;
            }
            case anyNonAllocatedSubIndex: {
                for (VariableBinding variableBinding : vbs) {
                    if (this.indexRegistry.allocate(this.session.getSessionID(), context, variableBinding, false) != 0) continue;
                    VariableBinding[] vbSingle = new VariableBinding[]{variableBinding};
                    vbs = vbSingle;
                    break block1;
                }
                break;
            }
        }
        AgentXIndexAllocatePDU pdu = new AgentXIndexAllocatePDU(context, vbs);
        if (indexAllocationMode != 0) {
            pdu.addFlag(indexAllocationMode);
        }
        pdu.setSessionAttributes(this.session);
        try {
            AgentXResponseEvent response = this.agentX.send(pdu, this.session.createAgentXTarget(), this.session.getPeer().getTransport());
            if (response.getResponse() != null) {
                AgentXResponsePDU resp = response.getResponse();
                if (resp.getErrorStatus() == 0) {
                    switch (this.indexStrategy) {
                        case firstSubIndexOnly: {
                            this.indexRegistry.allocate(this.session.getSessionID(), context, vbs[0], false);
                            break;
                        }
                        case anyNonAllocatedSubIndex: {
                            for (VariableBinding vb : vbs) {
                                this.indexRegistry.allocate(this.session.getSessionID(), context, vb, false);
                            }
                            break;
                        }
                    }
                    OID oID = indexDef.getIndexOID(AgentXSharedMOTableSupport.getVariables(resp.getVariableBindings()));
                    allocatedIndex.setValue(oID.getValue());
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Serializable)((Object)("Allocated index " + allocatedIndex + " for context " + context + " and index definition " + indexDef)));
                    }
                } else {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Serializable)((Object)("Index allocation failed for context " + context + " and index definition " + indexDef + " with value " + allocatedIndex)));
                    }
                    switch (this.indexStrategy) {
                        case firstSubIndexOnly: 
                        case anyNonAllocatedSubIndex: {
                            this.indexRegistry.release(this.session.getSessionID(), context, vbs[0], false);
                        }
                    }
                    return this.handleIndexAllocationError(indexDef, context, allocatedIndex, resp);
                }
                return 0;
            }
            return -11;
        }
        catch (IOException ex) {
            LOGGER.error((CharSequence)("Failed to allocate index " + indexDef + " at " + this.session), (Throwable)ex);
            return -5;
        }
    }

    protected int handleIndexAllocationError(MOTableIndex indexDef, OctetString context, OID allocatedIndex, AgentXResponsePDU resp) {
        return resp.getErrorStatus();
    }

    public int deallocateIndex(OctetString context, MOTableIndex indexDef, OID allocatedIndex) {
        if (this.indexStrategy == IndexStrategy.noIndexAllocation) {
            return 0;
        }
        VariableBinding[] vbs = new VariableBinding[indexDef.size()];
        Variable[] indexValues = indexDef.getIndexValues(allocatedIndex);
        for (int i = 0; i < indexDef.size(); ++i) {
            vbs[i] = new VariableBinding();
            VariableBinding[] subIndex = indexDef.getIndex(i);
            OID oid = subIndex.getOid();
            if (oid == null) {
                throw new IllegalArgumentException("Sub-index " + i + " has no OID");
            }
            vbs[i].setOid(oid);
            vbs[i].setVariable(indexValues[i]);
        }
        switch (this.indexStrategy) {
            case firstSubIndexOnly: {
                if (this.indexRegistry.release(this.session.getSessionID(), context, vbs[0], false) != 259) break;
                return 0;
            }
            case anyNonAllocatedSubIndex: {
                ArrayList<VariableBinding> dvbs = new ArrayList<VariableBinding>(vbs.length);
                for (VariableBinding vb : vbs) {
                    if (this.indexRegistry.release(this.session.getSessionID(), context, vb, false) != 0) continue;
                    dvbs.add(vb);
                    break;
                }
                vbs = dvbs.toArray(new VariableBinding[dvbs.size()]);
            }
        }
        AgentXIndexDeallocatePDU pdu = new AgentXIndexDeallocatePDU(context, vbs);
        pdu.setSessionAttributes(this.session);
        try {
            AgentXResponseEvent response = this.agentX.send(pdu, this.session.createAgentXTarget(), this.session.getPeer().getTransport());
            if (response.getResponse() != null) {
                AgentXResponsePDU resp = response.getResponse();
                return resp.getErrorStatus();
            }
            return -11;
        }
        catch (IOException ex) {
            LOGGER.error((CharSequence)("Failed to deallocate index " + indexDef + " at " + this.session), (Throwable)ex);
            return -5;
        }
    }

    public int registerRow(MOTable table, R row2Register) {
        return this.registerRow(table, row2Register, this.priority);
    }

    public int registerRow(MOTable table, R row2Register, byte priority) {
        OID subtree = new OID(table.getOID());
        subtree.append(table.getColumn(0).getColumnID());
        subtree.append(row2Register.getIndex());
        AgentXRegisterPDU pdu = new AgentXRegisterPDU(this.context, subtree, priority, (byte)(table.getOID().size() + 1), table.getColumn(table.getColumnCount() - 1).getColumnID());
        if (table.getColumnCount() == 1) {
            pdu.addFlag((byte)1);
        }
        pdu.setSessionAttributes(this.session);
        try {
            AgentXResponseEvent resp = this.agentX.send(pdu, this.session.createAgentXTarget(), this.session.getPeer().getTransport());
            if (resp.getResponse() == null) {
                return -11;
            }
            if (resp.getResponse().getErrorStatus() != 0) {
                return resp.getResponse().getErrorStatus();
            }
        }
        catch (IOException ex) {
            LOGGER.error((CharSequence)("Failed to send AgentXRegister pdu " + pdu + " to " + this.session + " because: " + ex.getMessage()), (Throwable)ex);
            return -5;
        }
        return 0;
    }

    public int unregisterRow(MOTable table, R row2Unregister) {
        return this.unregisterRow(table, row2Unregister, this.priority);
    }

    public int unregisterRow(MOTable table, R row2Unregister, byte priority) {
        OID subtree = new OID(table.getOID());
        subtree.append(table.getColumn(0).getColumnID());
        subtree.append(row2Unregister.getIndex());
        AgentXUnregisterPDU pdu = new AgentXUnregisterPDU(this.context, subtree, priority, (byte)(table.getOID().size() + 1), table.getColumn(table.getColumnCount() - 1).getColumnID());
        pdu.setSessionAttributes(this.session);
        try {
            AgentXResponseEvent resp = this.agentX.send(pdu, this.session.createAgentXTarget(), this.session.getPeer().getTransport());
            if (resp.getResponse() == null) {
                return -11;
            }
            if (resp.getResponse().getErrorStatus() != 0) {
                return resp.getResponse().getErrorStatus();
            }
        }
        catch (IOException ex) {
            LOGGER.error((CharSequence)("Failed to send AgentXRegister pdu " + pdu + " to " + this.session + " because: " + ex.getMessage()), (Throwable)ex);
            return -5;
        }
        return 0;
    }

    private static Variable[] getVariables(VariableBinding[] vbs) {
        Variable[] variables = new Variable[vbs.length];
        for (int i = 0; i < vbs.length; ++i) {
            variables[i] = vbs[i].getVariable();
        }
        return variables;
    }

    public void setPriority(byte priority) {
        this.priority = priority;
    }

    public void setSession(AgentXSession session) {
        this.session = session;
    }

    public void setIndexMode(byte indexMode) {
        this.indexMode = indexMode;
    }

    public void setContext(OctetString context) {
        this.context = context;
    }

    public byte getPriority() {
        return this.priority;
    }

    public AgentXSession getSession() {
        return this.session;
    }

    public byte getIndexMode() {
        return this.indexMode;
    }

    public OctetString getContext() {
        return this.context;
    }

    public AgentX getAgentX() {
        return this.agentX;
    }

    public IndexStrategy getIndexStrategy() {
        return this.indexStrategy;
    }

    public void setIndexStrategy(IndexStrategy indexStrategy) {
        this.indexStrategy = indexStrategy;
    }

    public static enum IndexStrategy {
        noIndexAllocation,
        firstSubIndexOnly,
        anyNonAllocatedSubIndex,
        alwaysFirstSubIndex,
        alwaysAnySubIndex;

    }
}

