/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.agentx;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.snmp4j.agent.agentx.AgentXContextPDU;
import org.snmp4j.agent.agentx.AgentXMessageHeader;
import org.snmp4j.agent.agentx.AgentXProtocol;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.VariableBinding;

public class AgentXVariableBindingPDU
extends AgentXContextPDU {
    protected VariableBinding[] variableBindings;

    protected AgentXVariableBindingPDU(byte type, OctetString context, VariableBinding[] vbs) {
        super(type, context);
        this.variableBindings = vbs;
    }

    protected AgentXVariableBindingPDU(AgentXMessageHeader header) {
        super(header);
    }

    protected AgentXVariableBindingPDU(byte type, byte flags, int sessionID, int transactionID, int packetID) {
        super(type, flags, sessionID, transactionID, packetID);
    }

    @Override
    public void decodeAfterContext(ByteBuffer buf, int length) throws IOException {
        this.variableBindings = AgentXProtocol.decodeVariableBindings(buf);
    }

    @Override
    public void encodeAfterContext(ByteBuffer buf) {
        AgentXProtocol.encodeVaribleBindings(buf, this.variableBindings);
    }

    @Override
    public int getAfterContextLength() {
        return AgentXProtocol.getVariableBindingsLength(this.variableBindings);
    }

    public VariableBinding[] getVariableBindings() {
        return this.variableBindings;
    }

    public void setVariableBindings(VariableBinding[] variableBindings) {
        this.variableBindings = variableBindings;
    }

    public int size() {
        return this.variableBindings.length;
    }

    @Override
    public String toStringExtMembers() {
        return super.toStringExtMembers() + ",variableBindings=" + (this.variableBindings == null ? null : Arrays.asList(this.variableBindings));
    }
}

