/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.agentx.master;

import java.io.Serializable;
import java.util.TreeSet;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.agent.MOScope;
import org.snmp4j.agent.ManagedObject;
import org.snmp4j.agent.agentx.AgentXRegion;
import org.snmp4j.agent.agentx.master.AgentXMasterSession;
import org.snmp4j.agent.agentx.master.AgentXQueue;
import org.snmp4j.agent.agentx.master.AgentXRegEntry;
import org.snmp4j.agent.agentx.master.AgentXSearchRange;
import org.snmp4j.agent.request.SnmpRequest;
import org.snmp4j.agent.request.SnmpSubRequest;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.agent.request.SubRequestIterator;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.Variable;

public class AgentXNode
implements ManagedObject {
    private static final LogAdapter LOGGER = LogFactory.getLogger(AgentXNode.class);
    private TreeSet<AgentXRegEntry> registrations = new TreeSet();
    private AgentXRegion region;

    public AgentXNode(AgentXRegion region, AgentXRegEntry registration) {
        this.region = new AgentXRegion(region);
        this.registrations.add(registration);
    }

    protected AgentXNode(AgentXRegion region, TreeSet<AgentXRegEntry> registrations) {
        this.region = new AgentXRegion(region);
        this.registrations = registrations;
    }

    public AgentXNode getClone(AgentXRegion region) {
        return new AgentXNode(new AgentXRegion(region), (TreeSet)this.registrations.clone());
    }

    public int getRegistrationCount() {
        return this.registrations.size();
    }

    public synchronized boolean shrink(OID upper) {
        if (this.region.covers(upper)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Serializable)((Object)("Shrinking node " + this.toString() + " to " + upper)));
            }
            this.region.setUpperBound(upper);
            return true;
        }
        return false;
    }

    public synchronized boolean expand(OID upper, boolean inclusive) {
        if (!this.region.covers(upper) && this.region.getUpperBound().compareTo((Variable)upper) >= 0) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Serializable)((Object)("Expanding node " + this.toString() + " to " + upper + ", inclusive=" + inclusive)));
            }
            this.region.setUpperBound(upper);
            this.region.setUpperIncluded(inclusive);
            return true;
        }
        return false;
    }

    public synchronized void addRegistration(AgentXRegEntry entry) {
        this.registrations.add(entry);
    }

    public synchronized boolean removeRegistration(AgentXRegEntry entry) {
        boolean removed = this.registrations.remove(entry);
        if (LOGGER.isDebugEnabled()) {
            if (removed) {
                LOGGER.debug((Serializable)((Object)("Removed registration " + entry + " from AgentX node " + this.toString())));
            } else {
                LOGGER.debug((Serializable)((Object)("Removing registration failed for " + entry + " from AgentX node " + this.toString())));
            }
        }
        return removed;
    }

    public OID find(MOScope range) {
        OID next = OID.max((OID)range.getLowerBound(), (OID)this.region.getLowerBound());
        if (this.region.covers(next) && this.getActiveRegistration() != null) {
            return next;
        }
        return null;
    }

    public final synchronized AgentXRegEntry getActiveRegistration() {
        AgentXRegEntry activeReg = null;
        while (!this.registrations.isEmpty() && activeReg == null) {
            activeReg = this.registrations.first();
            if (!activeReg.getSession().isClosed()) continue;
            this.registrations.remove(activeReg);
            LOGGER.warn((Serializable)((Object)("Removed registration from already closed session: " + activeReg)));
            activeReg = null;
        }
        return activeReg;
    }

    public void get(SubRequest request) {
        AgentXRegEntry activeReg = this.getActiveRegistration();
        if (activeReg == null) {
            request.getVariableBinding().setVariable((Variable)Null.noSuchObject);
            request.getStatus().setPhaseComplete(true);
            return;
        }
        AgentXQueue queue = activeReg.getSession().getQueue();
        AgentXSearchRange searchRange = new AgentXSearchRange(request.getScope().getLowerBound(), request.getScope().isLowerIncluded(), request.getScope().getUpperBound(), request.getScope().isUpperIncluded(), (SnmpSubRequest)request);
        queue.add(searchRange, activeReg, false);
        AgentXNode.markAsProcessed(request);
    }

    public MOScope getScope() {
        return this.region;
    }

    public boolean next(SubRequest request) {
        AgentXRegEntry activeReg = this.getActiveRegistration();
        if (activeReg == null) {
            return false;
        }
        AgentXQueue queue = activeReg.getSession().getQueue();
        AgentXSearchRange searchRange = new AgentXSearchRange(request.getScope().getLowerBound(), request.getScope().isLowerIncluded(), this.region.getUpperBound(), this.region.isUpperIncluded(), (SnmpSubRequest)request);
        OID upperRequestBound = request.getScope().getUpperBound();
        if (upperRequestBound != null && upperRequestBound.compareTo((Variable)this.region.getUpperBound()) < 0) {
            searchRange.setUpperBound(upperRequestBound);
            searchRange.setUpperIncluded(request.getScope().isUpperIncluded());
        }
        if (searchRange.isEmpty()) {
            return false;
        }
        int nonRepeaters = ((SnmpRequest)request.getRequest()).getNonRepeaters();
        if (queue.add(searchRange, activeReg, request.getIndex() >= nonRepeaters) && ((CommandResponderEvent)((SnmpRequest)request.getRequest()).getSource()).getPDU().getType() == -91) {
            SubRequestIterator it = request.repetitions();
            while (it.hasNext()) {
                SubRequest sreq = (SubRequest)it.next();
                sreq.getStatus().setProcessed(true);
            }
        }
        AgentXNode.markAsProcessed(request);
        return true;
    }

    public void prepare(SubRequest request) {
        this.addAgentXSet2Queue(request);
        AgentXNode.markAsProcessed(request);
    }

    public void undo(SubRequest request) {
        this.addAgentXSet2Queue(request);
        AgentXNode.markAsProcessed(request);
    }

    public void cleanup(SubRequest request) {
        this.addAgentXSet2Queue(request);
        AgentXNode.markAsProcessed(request);
    }

    public void commit(SubRequest request) {
        this.addAgentXSet2Queue(request);
        AgentXNode.markAsProcessed(request);
    }

    private static void markAsProcessed(SubRequest request) {
        request.getStatus().setProcessed(true);
    }

    private void addAgentXSet2Queue(SubRequest request) {
        AgentXRegEntry activeReg = this.getActiveRegistration();
        if (activeReg != null) {
            AgentXMasterSession session = activeReg.getSession();
            if (session != null) {
                AgentXQueue queue = session.getQueue();
                if (queue != null) {
                    queue.add(request.getVariableBinding(), (SnmpSubRequest)request, activeReg);
                } else if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Serializable)((Object)("No queue for session " + session)));
                }
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Serializable)((Object)("No session for registration entry " + activeReg)));
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Serializable)((Object)("No active registration left for " + request)));
        }
    }

    public String toString() {
        return this.getClass().getName() + "[region=" + this.region + ",registrations=" + this.registrations + "]";
    }
}

