/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.snmp4j.agent.DefaultMOScope;
import org.snmp4j.agent.MOAccess;
import org.snmp4j.agent.MOScope;
import org.snmp4j.agent.ManagedObjectValueAccess;
import org.snmp4j.agent.RandomAccessManagedObject;
import org.snmp4j.agent.SerializableManagedObject;
import org.snmp4j.agent.io.ImportMode;
import org.snmp4j.agent.io.MOInput;
import org.snmp4j.agent.io.MOOutput;
import org.snmp4j.agent.mo.ChangeableManagedObject;
import org.snmp4j.agent.mo.GenericManagedObject;
import org.snmp4j.agent.mo.MOChangeEvent;
import org.snmp4j.agent.mo.MOChangeListener;
import org.snmp4j.agent.mo.MOValueValidationEvent;
import org.snmp4j.agent.mo.MOValueValidationListener;
import org.snmp4j.agent.request.RequestStatus;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public class MOScalar<V extends Variable>
implements GenericManagedObject,
MOScope,
SerializableManagedObject<SubRequest<?>>,
ManagedObjectValueAccess<SubRequest<?>>,
ChangeableManagedObject<SubRequest<?>>,
RandomAccessManagedObject<SubRequest<?>> {
    private static final LogAdapter logger = LogFactory.getLogger(MOScalar.class);
    protected OID oid;
    private volatile OID lowerBound;
    private volatile OID upperBound;
    protected V value;
    protected MOAccess access;
    private boolean isVolatile;
    private transient List<MOValueValidationListener> moValueValidationListeners;
    private transient List<MOChangeListener> moChangeListeners;

    protected MOScalar() {
    }

    public MOScalar(OID id, MOAccess access, V value) {
        this.oid = id;
        this.access = access;
        this.value = value;
        this.isVolatile = MOScalar.isVolatileByDefault(value);
    }

    private static boolean isVolatileByDefault(Variable value) {
        if (value == null) {
            return true;
        }
        switch (value.getSyntax()) {
            case 65: 
            case 70: {
                return true;
            }
        }
        return false;
    }

    @Override
    public MOScope getScope() {
        return this;
    }

    public MOScope getSingleInstanceScope() {
        return new DefaultMOScope(this.oid, true, this.oid, true);
    }

    @Override
    public OID find(MOScope range) {
        if (this.access.isAccessibleForRead() && range.isCovered(this.getSingleInstanceScope())) {
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("MOScalar '" + String.valueOf(this.oid) + "' is in scope '" + String.valueOf(range) + "'")));
            }
            return this.oid;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)("MOScalar '" + String.valueOf(this.oid) + "' is not in scope '" + String.valueOf(range) + "'")));
        }
        return null;
    }

    @Override
    public void get(SubRequest<?> request) {
        RequestStatus status = request.getStatus();
        if (this.checkRequestScope(request)) {
            if (this.access.isAccessibleForRead()) {
                VariableBinding vb = request.getVariableBinding();
                V variable = this.getValue();
                if (variable == null) {
                    vb.setVariable((Variable)Null.noSuchObject);
                } else {
                    vb.setVariable((Variable)variable.clone());
                }
                request.completed();
            } else {
                status.setErrorStatus(6);
            }
        }
    }

    public MOAccess getAccess() {
        return this.access;
    }

    protected boolean checkRequestScope(SubRequest<?> request) {
        if (!request.getVariableBinding().getOid().equals((Object)this.oid)) {
            VariableBinding vb = request.getVariableBinding();
            vb.setVariable((Variable)Null.noSuchInstance);
            request.completed();
            return false;
        }
        return true;
    }

    @Override
    public boolean next(SubRequest<?> request) {
        if (this.access.isAccessibleForRead() && request.getScope().isCovered(this.getSingleInstanceScope())) {
            VariableBinding vb = request.getVariableBinding();
            vb.setOid(this.getOid());
            V variable = this.getValue();
            if (variable == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("Skipped '" + String.valueOf(this.getOid()) + "' for GETNEXT/BULK request '" + String.valueOf(request) + "' because variable is NULL")));
                }
                return false;
            }
            vb.setVariable((Variable)variable.clone());
            request.completed();
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Processed GETNEXT/BULK request '" + String.valueOf(request) + "' by '" + String.valueOf(this.getOid()))));
            }
            return true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)("Skipped '" + String.valueOf(this.getOid()) + "' for GETNEXT/BULK request '" + String.valueOf(request) + "'")));
        }
        return false;
    }

    public int isValueOK(SubRequest<?> request) {
        if (this.moValueValidationListeners != null) {
            V oldValue = this.value;
            Variable newValue = request.getVariableBinding().getVariable();
            MOValueValidationEvent event = new MOValueValidationEvent(this, (Variable)oldValue, newValue, request.getVariableBinding().getOid());
            this.fireValidate(event);
            return event.getValidationStatus();
        }
        return 0;
    }

    protected int getSyntax() {
        return this.value != null ? this.value.getSyntax() : this.getValue().getSyntax();
    }

    @Override
    public void prepare(SubRequest<?> request) {
        RequestStatus status = request.getStatus();
        if (this.oid.equals((Object)request.getVariableBinding().getOid())) {
            if (this.access.isAccessibleForWrite()) {
                VariableBinding vb = request.getVariableBinding();
                if (vb.getVariable().getSyntax() != this.getSyntax()) {
                    status.setErrorStatus(7);
                    return;
                }
                Variable value = null;
                if (this.moChangeListeners != null) {
                    value = (Variable)this.getValue();
                    MOChangeEvent event = new MOChangeEvent(this, this, request.getVariableBinding().getOid(), value, request.getVariableBinding().getVariable(), true, request);
                    this.fireBeforePrepareMOChange(event);
                    if (event.getDenyReason() != 0) {
                        status.setErrorStatus(event.getDenyReason());
                        status.setPhaseComplete(true);
                        return;
                    }
                }
                int valueOK = this.isValueOK(request);
                if (this.moChangeListeners != null && valueOK == 0) {
                    MOChangeEvent event = new MOChangeEvent(this, this, request.getVariableBinding().getOid(), value, request.getVariableBinding().getVariable(), true, request);
                    this.fireAfterPrepareMOChange(event);
                    valueOK = event.getDenyReason();
                }
                status.setErrorStatus(valueOK);
                status.setPhaseComplete(true);
            } else {
                status.setErrorStatus(17);
            }
        } else {
            status.setErrorStatus(11);
        }
    }

    @Override
    public void commit(SubRequest<?> request) {
        MOChangeEvent event;
        RequestStatus status = request.getStatus();
        VariableBinding vb = request.getVariableBinding();
        V value = this.getValue();
        if (this.moChangeListeners != null) {
            event = new MOChangeEvent(this, this, vb.getOid(), (Variable)value, vb.getVariable(), false, request);
            this.fireBeforeMOChange(event);
        }
        request.setUndoValue(value);
        this.changeValue(vb.getVariable());
        status.setPhaseComplete(true);
        if (this.moChangeListeners != null) {
            event = new MOChangeEvent(this, this, request.getVariableBinding().getOid(), (Variable)request.getUndoValue(), vb.getVariable(), false, request);
            this.fireAfterMOChange(event);
        }
    }

    protected int changeValue(V value) {
        return this.setValue(value);
    }

    @Override
    public void undo(SubRequest<?> request) {
        RequestStatus status = request.getStatus();
        if (request.getUndoValue() != null && request.getUndoValue() instanceof Variable) {
            int errorStatus = this.changeValue((Variable)request.getUndoValue());
            status.setErrorStatus(errorStatus);
            status.setPhaseComplete(true);
        } else {
            status.setErrorStatus(15);
        }
    }

    @Override
    public void cleanup(SubRequest<?> request) {
        request.setUndoValue(null);
        request.getStatus().setPhaseComplete(true);
    }

    public OID getOid() {
        return this.oid;
    }

    @Override
    public OID getLowerBound() {
        if (this.lowerBound == null) {
            this.lowerBound = new OID(this.oid.getValue(), 0, this.oid.size() - 1);
        }
        return this.lowerBound;
    }

    @Override
    public OID getUpperBound() {
        if (this.upperBound == null) {
            this.upperBound = new OID(this.getLowerBound().nextPeer());
        }
        return this.upperBound;
    }

    @Override
    public boolean isCovered(MOScope other) {
        return !(!other.getLowerBound().startsWith(this.oid) || other.getLowerBound().size() <= this.oid.size() && !other.isLowerIncluded() || !other.getUpperBound().startsWith(this.oid) || other.getUpperBound().size() <= this.oid.size() && !other.isUpperIncluded());
    }

    @Override
    public boolean isLowerIncluded() {
        return true;
    }

    @Override
    public boolean isUpperIncluded() {
        return false;
    }

    public V getValue() {
        return this.value;
    }

    @Override
    public boolean isVolatile() {
        return this.isVolatile;
    }

    @Override
    public boolean isConfigurable() {
        if (this.isVolatile() && this.value != null) {
            switch (this.value.getSyntax()) {
                case 65: 
                case 67: 
                case 70: {
                    return false;
                }
            }
        }
        return SerializableManagedObject.super.isConfigurable();
    }

    public int setValue(V value) {
        V oldValue = this.value;
        this.value = value;
        this.fireAfterMOChange(new MOChangeEvent(this, this, this.getOid(), (Variable)oldValue, (Variable)value, false));
        return 0;
    }

    public void setVolatile(boolean isVolatile) {
        this.isVolatile = isVolatile;
    }

    @Override
    public boolean isOverlapping(MOScope other) {
        return DefaultMOScope.overlaps(this, other);
    }

    public synchronized void addMOValueValidationListener(MOValueValidationListener l) {
        if (this.moValueValidationListeners == null) {
            this.moValueValidationListeners = new ArrayList<MOValueValidationListener>(2);
        }
        this.moValueValidationListeners.add(l);
    }

    public synchronized void removeMOValueValidationListener(MOValueValidationListener l) {
        if (this.moValueValidationListeners != null) {
            this.moValueValidationListeners.remove(l);
        }
    }

    protected synchronized void fireValidate(MOValueValidationEvent validationEvent) {
        List<MOValueValidationListener> listeners = this.moValueValidationListeners;
        if (listeners != null) {
            int count = listeners.size();
            for (MOValueValidationListener listener : listeners) {
                listener.validate(validationEvent);
            }
        }
    }

    @Override
    public OID getID() {
        return this.getOid();
    }

    @Override
    public synchronized void load(MOInput input) throws IOException {
        Variable v = input.readVariable();
        this.setValue(v);
    }

    @Override
    public synchronized void save(MOOutput output) throws IOException {
        output.writeVariable((Variable)this.value);
    }

    @Override
    public boolean covers(OID oid) {
        return oid.startsWith(this.oid);
    }

    public String toString() {
        return this.getClass().getName() + "[oid=" + String.valueOf(this.getOid()) + ",access=" + String.valueOf(this.access) + ",value=" + String.valueOf(this.getValue()) + ",volatile=" + this.isVolatile() + ", isConfigurable=" + this.isConfigurable() + this.toStringDetails() + "]";
    }

    protected String toStringDetails() {
        return "";
    }

    @Override
    public synchronized void addMOChangeListener(MOChangeListener l) {
        if (this.moChangeListeners == null) {
            this.moChangeListeners = new ArrayList<MOChangeListener>(2);
        }
        this.moChangeListeners.add(l);
    }

    @Override
    public synchronized void removeMOChangeListener(MOChangeListener l) {
        if (this.moChangeListeners != null) {
            this.moChangeListeners.remove(l);
        }
    }

    protected synchronized void fireBeforePrepareMOChange(MOChangeEvent changeEvent) {
        List<MOChangeListener> listeners = this.moChangeListeners;
        if (listeners != null) {
            for (MOChangeListener listener : listeners) {
                listener.beforePrepareMOChange(changeEvent);
            }
        }
    }

    protected synchronized void fireAfterPrepareMOChange(MOChangeEvent changeEvent) {
        List<MOChangeListener> listeners = this.moChangeListeners;
        if (listeners != null) {
            for (MOChangeListener listener : listeners) {
                listener.afterPrepareMOChange(changeEvent);
            }
        }
    }

    protected synchronized void fireBeforeMOChange(MOChangeEvent changeEvent) {
        List<MOChangeListener> listeners = this.moChangeListeners;
        if (listeners != null) {
            for (MOChangeListener listener : listeners) {
                listener.beforeMOChange(changeEvent);
            }
        }
    }

    protected synchronized void fireAfterMOChange(MOChangeEvent changeEvent) {
        List<MOChangeListener> listeners = this.moChangeListeners;
        if (listeners != null) {
            for (MOChangeListener listener : listeners) {
                listener.afterMOChange(changeEvent);
            }
        }
    }

    @Override
    public Variable getValue(OID instanceOID) {
        if (this.getOid().equals((Object)instanceOID)) {
            return this.getValue();
        }
        return null;
    }

    @Override
    public boolean setValue(VariableBinding newValueAndInstancceOID) {
        if (this.getOid().equals((Object)newValueAndInstancceOID.getOid())) {
            return this.setValue(newValueAndInstancceOID.getVariable()) == 0;
        }
        return false;
    }

    @Override
    public boolean importInstance(OID instanceID, List<VariableBinding> data, ImportMode importMode) {
        if (data.size() > 0) {
            try {
                Variable newValue = data.get(0).getVariable();
                if (newValue.getSyntax() == this.value.getSyntax()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Serializable)((Object)("Loading scalar " + String.valueOf(this.getOid()) + " data " + String.valueOf(newValue) + " will overwrite " + String.valueOf(this.getValue()))));
                    }
                    this.setValue(newValue);
                    return true;
                }
            }
            catch (Exception iox) {
                logger.error((CharSequence)("Loading scalar " + String.valueOf(this.getOid()) + " failed: " + iox.getMessage()), (Throwable)iox);
            }
        }
        logger.error((Serializable)((Object)("Unable to load scalar data " + String.valueOf(data) + " for " + String.valueOf(this.getOid()))));
        return false;
    }

    @Override
    public List<VariableBinding> exportInstance(OID instanceID) {
        V valueCopy = this.value;
        if (valueCopy == null) {
            return null;
        }
        List<VariableBinding> exportData = Collections.singletonList(new VariableBinding(new OID(new int[]{0}), valueCopy));
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)("Exporting scalar " + String.valueOf(this.getOid()) + " data: " + String.valueOf(exportData))));
        }
        return exportData;
    }

    @Override
    public Iterator<OID> instanceIterator() {
        return new Iterator<OID>(){
            OID next = new OID(new int[]{0});

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public OID next() {
                OID result = this.next;
                this.next = null;
                return result;
            }
        };
    }

    @Override
    public int instanceCount() {
        return 1;
    }
}

