/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo.snmp;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOGroup;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.mo.DefaultMOMutableRow2PC;
import org.snmp4j.agent.mo.DefaultMOMutableRow2PCFactory;
import org.snmp4j.agent.mo.DefaultMOMutableTableModel;
import org.snmp4j.agent.mo.DefaultMOTable;
import org.snmp4j.agent.mo.DefaultMOTableRow;
import org.snmp4j.agent.mo.MOAccessImpl;
import org.snmp4j.agent.mo.MOColumn;
import org.snmp4j.agent.mo.MOTableIndex;
import org.snmp4j.agent.mo.MOTableModel;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.MOTableSubIndex;
import org.snmp4j.agent.mo.snmp.Enumerated;
import org.snmp4j.agent.mo.snmp.RowStatus;
import org.snmp4j.agent.mo.snmp.SnmpAdminString;
import org.snmp4j.agent.mo.snmp.StorageType;
import org.snmp4j.agent.mo.snmp.TestAndIncr;
import org.snmp4j.agent.mo.util.LexicographicOctetStringComparator;
import org.snmp4j.agent.security.MutableVACM;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;

public class VacmMIB
implements MOGroup,
MutableVACM {
    private static final LogAdapter logger = LogFactory.getLogger(VacmMIB.class);
    public static final OID vacmContextEntryOID = new OID(new int[]{1, 3, 6, 1, 6, 3, 16, 1, 1, 1});
    public static final int colVacmGroupName = 3;
    public static final int colVacmSecurityToGroupStorageType = 4;
    public static final int colVacmSecurityToGroupRowStatus = 5;
    public static final int idxVacmGroupName = 0;
    public static final int idxVacmSecurityToGroupStorageType = 1;
    public static final int idxVacmSecurityToGroupRowStatus = 2;
    public static final OID vacmSecurityToGroupEntryOID = new OID(new int[]{1, 3, 6, 1, 6, 3, 16, 1, 2, 1});
    public static final int colVacmAccessContextMatch = 4;
    public static final int colVacmAccessReadViewName = 5;
    public static final int colVacmAccessWriteViewName = 6;
    public static final int colVacmAccessNotifyViewName = 7;
    public static final int colVacmAccessStorageType = 8;
    public static final int colVacmAccessRowStatus = 9;
    public static final int idxVacmAccessContextPrefix = 1;
    public static final int idxVacmAccessSecurityModel = 2;
    public static final int idxVacmAccessSecurityLevel = 3;
    public static final int idxVacmAccessContextMatch = 0;
    public static final int idxVacmAccessReadViewName = 1;
    public static final int idxVacmAccessWriteViewName = 2;
    public static final int idxVacmAccessNotifyViewName = 3;
    public static final int idxVacmAccessStorageType = 4;
    public static final int idxVacmAccessRowStatus = 5;
    public static final OID vacmAccessEntryOID = new OID(new int[]{1, 3, 6, 1, 6, 3, 16, 1, 4, 1});
    public static final int vacmExactMatch = 1;
    public static final int vacmPrefixMatch = 2;
    public static final OID vacmViewSpinLockOID = new OID(new int[]{1, 3, 6, 1, 6, 3, 16, 1, 5, 1, 0});
    public static final int colVacmViewTreeFamilyMask = 3;
    public static final int colVacmViewTreeFamilyType = 4;
    public static final int colVacmViewTreeFamilyStorageType = 5;
    public static final int colVacmViewTreeFamilyRowStatus = 6;
    public static final int idxVacmViewTreeSubtree = 1;
    public static final int idxVacmViewTreeFamilyMask = 0;
    public static final int idxVacmViewTreeFamilyType = 1;
    public static final int idxVacmViewTreeFamilyStorageType = 2;
    public static final int idxVacmViewTreeFamilyRowStatus = 3;
    public static final OID vacmViewTreeFamilyEntryOID = new OID(new int[]{1, 3, 6, 1, 6, 3, 16, 1, 5, 2, 1});
    public static final int vacmViewIncluded = 1;
    public static final int vacmViewExcluded = 2;
    private static final int[] vacmViewTreeFamilyTypeValues = new int[]{1, 2};
    private static final MOTableSubIndex[] vacmViewTreeFamilyIndexes = new MOTableSubIndex[]{new MOTableSubIndex(4, 1, 32), new MOTableSubIndex(6, 0, 96)};
    private static final MOTableIndex vacmViewTreeFamilyIndex = new MOTableIndex(vacmViewTreeFamilyIndexes);
    private static final MOTableSubIndex[] vacmAccessIndexes = new MOTableSubIndex[]{new MOTableSubIndex(4, 1, 32), new MOTableSubIndex(4, 0, 32), new MOTableSubIndex(2, 1, 1), new MOTableSubIndex(2, 1, 1)};
    private final MOTableIndex vacmAccessIndex = new MOTableIndex(vacmAccessIndexes){

        @Override
        public boolean isValidIndex(OID index) {
            boolean ok = super.isValidIndex(index);
            if (ok) {
                Integer32 secModel = new Integer32(index.get(index.size() - 2));
                int secModelID = secModel.getValue();
                if (secModelID > 2 && VacmMIB.this.securityModels.getSecurityModel(secModel) == null) {
                    return false;
                }
                int secLevel = index.get(index.size() - 1);
                if (secLevel < 1 || secLevel > 3) {
                    return false;
                }
            }
            return ok;
        }
    };
    private final MOServer[] server;
    private DefaultMOTable<MOTableRow, MOColumn, VacmContextTableModel> vacmContextTable;
    private DefaultMOTable<DefaultMOMutableRow2PC, MOColumn, DefaultMOMutableTableModel<DefaultMOMutableRow2PC>> vacmSecurityToGroupTable;
    private DefaultMOMutableTableModel<DefaultMOMutableRow2PC> vacmSecurityToGroupTableModel;
    private DefaultMOTable<DefaultMOMutableRow2PC, MOColumn, DefaultMOMutableTableModel<DefaultMOMutableRow2PC>> vacmAccessTable;
    private DefaultMOMutableTableModel<DefaultMOMutableRow2PC> vacmAccessTableModel;
    private final TestAndIncr vacmViewSpinLock;
    private DefaultMOTable<DefaultMOMutableRow2PC, MOColumn, DefaultMOMutableTableModel<DefaultMOMutableRow2PC>> vacmViewTreeFamilyTable;
    private DefaultMOMutableTableModel<DefaultMOMutableRow2PC> vacmViewTreeFamilyTableModel;
    private SecurityModels securityModels;

    public VacmMIB(MOServer[] server) {
        this.server = server;
        this.createVacmContextTable();
        this.createVacmSecuritToGroupTable();
        this.createVacmAccessTable();
        this.createVacmViewTreeFamilyTable();
        this.vacmViewSpinLock = new TestAndIncr(vacmViewSpinLockOID);
        this.securityModels = SecurityModels.getInstance();
    }

    public VacmMIB(MOServer[] server, SecurityModels securityModels) {
        this(server);
        this.securityModels = securityModels;
    }

    @Override
    public void registerMOs(MOServer server, OctetString context) throws DuplicateRegistrationException {
        server.register(this.vacmContextTable, context);
        server.register(this.vacmSecurityToGroupTable, context);
        server.register(this.vacmAccessTable, context);
        server.register(this.vacmViewSpinLock, context);
        server.register(this.vacmViewTreeFamilyTable, context);
    }

    private void createVacmContextTable() {
        MOTableSubIndex[] vacmContextTableIndexes = new MOTableSubIndex[]{new MOTableSubIndex(4, 0, 32)};
        MOTableIndex vacmContextTableIndex = new MOTableIndex(vacmContextTableIndexes);
        MOColumn[] vacmContextColumns = new MOColumn[]{new MOColumn(1, 4, MOAccessImpl.ACCESS_READ_ONLY)};
        this.vacmContextTable = new DefaultMOTable(vacmContextEntryOID, vacmContextTableIndex, vacmContextColumns);
        this.vacmContextTable.setVolatile(true);
        this.vacmContextTable.setConfigurable(false);
        this.vacmContextTable.setModel(new VacmContextTableModel());
    }

    private void createVacmSecuritToGroupTable() {
        MOTableSubIndex[] vacmSecurityToGroupIndexes = new MOTableSubIndex[]{new MOTableSubIndex(2, 1, 1), new MOTableSubIndex(4, 1, 32)};
        MOTableIndex vacmSecurityToGroupIndex = new MOTableIndex(vacmSecurityToGroupIndexes){

            @Override
            public boolean isValidIndex(OID index) {
                boolean ok = super.isValidIndex(index);
                int securityModel = index.get(0);
                if (ok && securityModel > 2 && VacmMIB.this.securityModels.getSecurityModel(new Integer32(securityModel)) == null) {
                    return false;
                }
                return ok;
            }
        };
        MOColumn[] vacmSecurityToGroupColumns = new MOColumn[]{new SnmpAdminString(3, MOAccessImpl.ACCESS_READ_CREATE, null, true, 1, 32), new StorageType(4, MOAccessImpl.ACCESS_READ_CREATE, new Integer32(3), true), new RowStatus(5)};
        this.vacmSecurityToGroupTable = new DefaultMOTable(vacmSecurityToGroupEntryOID, vacmSecurityToGroupIndex, vacmSecurityToGroupColumns);
        this.vacmSecurityToGroupTableModel = new DefaultMOMutableTableModel();
        this.vacmSecurityToGroupTableModel.setRowFactory(new DefaultMOMutableRow2PCFactory());
        this.vacmSecurityToGroupTable.setModel(this.vacmSecurityToGroupTableModel);
    }

    private void createVacmAccessTable() {
        MOColumn[] vacmAccessColumns = new MOColumn[]{new Enumerated<Integer32>(4, 2, MOAccessImpl.ACCESS_READ_CREATE, new Integer32(1), true, new int[]{1, 2}), new SnmpAdminString(5, MOAccessImpl.ACCESS_READ_CREATE, new OctetString(), true, 0, 32), new SnmpAdminString(6, MOAccessImpl.ACCESS_READ_CREATE, new OctetString(), true, 0, 32), new SnmpAdminString(7, MOAccessImpl.ACCESS_READ_CREATE, new OctetString(), true, 0, 32), new StorageType(8, MOAccessImpl.ACCESS_READ_CREATE, new Integer32(3), true), new RowStatus(9)};
        this.vacmAccessTable = new DefaultMOTable(vacmAccessEntryOID, this.vacmAccessIndex, vacmAccessColumns);
        this.vacmAccessTableModel = new DefaultMOMutableTableModel();
        this.vacmAccessTableModel.setRowFactory(new DefaultMOMutableRow2PCFactory());
        this.vacmAccessTable.setModel(this.vacmAccessTableModel);
    }

    private void createVacmViewTreeFamilyTable() {
        MOColumn[] vacmViewTreeFamilyColumns = new MOColumn[]{new SnmpAdminString(3, MOAccessImpl.ACCESS_READ_CREATE, new OctetString(), true, 0, 16), new Enumerated<Integer32>(4, 2, MOAccessImpl.ACCESS_READ_CREATE, new Integer32(1), true, vacmViewTreeFamilyTypeValues), new StorageType(5, MOAccessImpl.ACCESS_READ_CREATE, new Integer32(3), true), new RowStatus(6)};
        this.vacmViewTreeFamilyTable = new DefaultMOTable(vacmViewTreeFamilyEntryOID, vacmViewTreeFamilyIndex, vacmViewTreeFamilyColumns);
        this.vacmViewTreeFamilyTableModel = new DefaultMOMutableTableModel();
        this.vacmViewTreeFamilyTableModel.setRowFactory(new DefaultMOMutableRow2PCFactory());
        this.vacmViewTreeFamilyTable.setModel(this.vacmViewTreeFamilyTableModel);
    }

    @Override
    public void unregisterMOs(MOServer server, OctetString context) {
        server.unregister(this.vacmContextTable, context);
        server.unregister(this.vacmSecurityToGroupTable, context);
        server.unregister(this.vacmAccessTable, context);
        server.unregister(this.vacmViewSpinLock, context);
        server.unregister(this.vacmViewTreeFamilyTable, context);
    }

    @Override
    public int isAccessAllowed(OctetString context, OctetString securityName, int securityModel, int securityLevel, int viewType, OID oid) {
        boolean supported;
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)("VACM access requested for context=" + String.valueOf(context) + ", securityName=" + String.valueOf(securityName) + ", securityModel=" + securityModel + ", securityLevel=" + securityLevel + ", viewType=" + viewType + ", OID=" + String.valueOf(oid))));
        }
        if (!(supported = this.isContextSupported(context))) {
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Context '" + String.valueOf(context) + "' ist not supported")));
            }
            return 3;
        }
        OctetString groupName = this.getGroupName(securityName, securityModel);
        if (groupName == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("No group name for securityName=" + String.valueOf(securityName) + " and securityModel=" + securityModel)));
            }
            return 4;
        }
        OctetString viewName = this.getViewNameByGroup(context, securityModel, securityLevel, viewType, groupName);
        if (viewName == null) {
            return 5;
        }
        if (viewName.length() == 0) {
            return 2;
        }
        return this.isAccessAllowed(viewName, oid);
    }

    private boolean isContextSupported(OctetString context) {
        boolean supported = false;
        for (MOServer aServer : this.server) {
            if (!aServer.isContextSupported(context)) continue;
            supported = true;
            break;
        }
        return supported;
    }

    @Override
    public OctetString getViewName(OctetString context, OctetString securityName, int securityModel, int securityLevel, int viewType) {
        OctetString groupName = this.getGroupName(securityName, securityModel);
        if (groupName == null) {
            return null;
        }
        return this.getViewNameByGroup(context, securityModel, securityLevel, viewType, groupName);
    }

    @Override
    public boolean hasContext(OctetString contextName) {
        return this.isContextSupported(contextName);
    }

    private OctetString getViewNameByGroup(OctetString context, int securityModel, int securityLevel, int viewType, OctetString groupName) {
        List<MOTableRow> accessEntries = this.getAccessEntries(groupName);
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)("Got views " + String.valueOf(accessEntries) + " for group name '" + String.valueOf(groupName) + "'")));
        }
        MOTableRow possibleMatch = null;
        boolean foundExactContextMatch = false;
        boolean foundMatchedSecModel = false;
        int foundContextPrefixLength = 0;
        int foundSecLevel = 0;
        for (MOTableRow accessEntry : accessEntries) {
            boolean matchSecLevel;
            if (((Integer32)accessEntry.getValue(5)).getValue() != 1) continue;
            Variable[] indexValues = this.vacmAccessIndex.getIndexValues(accessEntry.getIndex());
            OctetString rowContext = (OctetString)indexValues[1];
            int rowSecurityModel = ((Integer32)indexValues[2]).getValue();
            int rowSecurityLevel = ((Integer32)indexValues[3]).getValue();
            int rowContextMatch = ((Integer32)accessEntry.getValue(0)).getValue();
            boolean exactContextMatch = rowContext.equals((Object)context);
            boolean prefixMatch = !exactContextMatch && rowContextMatch == 2 && context.startsWith(rowContext);
            boolean matchSecModel = rowSecurityModel == securityModel || rowSecurityModel == 0;
            boolean bl = matchSecLevel = rowSecurityLevel <= securityLevel;
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Matching against access entry " + String.valueOf(accessEntry) + " with exactContextMatch=" + exactContextMatch + ", prefixMatch=" + prefixMatch + ", matchSecModel=" + matchSecModel + " and matchSecLevel=" + matchSecLevel)));
            }
            if (!exactContextMatch && !prefixMatch || !matchSecModel || !matchSecLevel || possibleMatch != null && foundMatchedSecModel && (foundExactContextMatch || !exactContextMatch) && (foundExactContextMatch && !exactContextMatch || foundContextPrefixLength >= rowContext.length()) && (foundContextPrefixLength != rowContext.length() || foundSecLevel >= rowSecurityLevel)) continue;
            possibleMatch = accessEntry;
            foundExactContextMatch = exactContextMatch;
            if (prefixMatch) {
                foundContextPrefixLength = rowContext.length();
            }
            foundMatchedSecModel = matchSecModel;
            foundSecLevel = rowSecurityLevel;
        }
        if (possibleMatch != null) {
            OctetString viewName = null;
            switch (viewType) {
                case 1: {
                    viewName = (OctetString)possibleMatch.getValue(1);
                    break;
                }
                case 2: {
                    viewName = (OctetString)possibleMatch.getValue(2);
                    break;
                }
                case 0: {
                    viewName = (OctetString)possibleMatch.getValue(3);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Matching view found for group name '" + String.valueOf(groupName) + "' is '" + String.valueOf(viewName) + "'")));
            }
            return viewName;
        }
        return null;
    }

    private OctetString getGroupName(OctetString securityName, int securityModel) {
        OID index = new OID();
        index.append(securityModel);
        index.append(securityName.toSubIndex(false));
        Object row = this.vacmSecurityToGroupTableModel.getRow(index);
        if (row != null) {
            OctetString groupName = (OctetString)row.getValue(0);
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Found group name '" + String.valueOf(groupName) + "' for secName '" + String.valueOf(securityName) + "' and secModel " + securityModel)));
            }
            return groupName;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)("No group found for secName '" + String.valueOf(securityName) + "' and secModel " + securityModel)));
        }
        return null;
    }

    @Override
    public int isAccessAllowed(OctetString viewName, OID oid) {
        List<MOTableRow> views = this.getViews(viewName);
        if (views.isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("No view tree family entry for view '" + String.valueOf(viewName) + "'")));
            }
            return 2;
        }
        for (int v = views.size() - 1; v >= 0; --v) {
            MOTableRow row = views.get(v);
            if (((Integer32)row.getValue(3)).getValue() != 1) continue;
            OID index = row.getIndex();
            Variable[] indexValues = vacmViewTreeFamilyIndex.getIndexValues(index);
            OID subtree = (OID)indexValues[1];
            if (oid.size() < subtree.size()) continue;
            OctetString mask = (OctetString)row.getValue(0);
            boolean match = true;
            for (int i = 0; i < subtree.size(); ++i) {
                if (subtree.get(i) == oid.get(i) || !VacmMIB.isBitSet(i, mask)) continue;
                match = false;
                break;
            }
            if (!match) continue;
            if (((Integer32)row.getValue(1)).getValue() == 1) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("Access allowed for view '" + String.valueOf(viewName) + "' by subtree " + String.valueOf(subtree) + " for OID " + String.valueOf(oid) + " and mask " + mask.toHexString())));
                }
                return 0;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Access denied for view '" + String.valueOf(viewName) + "' by subtree " + String.valueOf(subtree) + " for OID " + String.valueOf(oid) + " and mask " + mask.toHexString())));
            }
            return 1;
        }
        return 1;
    }

    @Override
    public void addGroup(int securityModel, OctetString securityName, OctetString groupName, int storageType) {
        OID index = VacmMIB.createGroupIndex(securityModel, securityName);
        Variable[] values = new Variable[this.vacmSecurityToGroupTable.getColumnCount()];
        values[0] = groupName;
        values[1] = new Integer32(storageType);
        values[2] = new Integer32(1);
        DefaultMOMutableRow2PC row = this.vacmSecurityToGroupTable.createRow(index, values);
        this.vacmSecurityToGroupTable.addRow(row);
    }

    private static OID createGroupIndex(int securityModel, OctetString securityName) {
        OID index = new OID();
        index.append(securityModel);
        index.append(securityName.toSubIndex(false));
        return index;
    }

    @Override
    public boolean removeGroup(int securityModel, OctetString securityName) {
        OID index = VacmMIB.createGroupIndex(securityModel, securityName);
        return this.vacmSecurityToGroupTable.removeRow(index) != null;
    }

    @Override
    public boolean hasSecurityToGroupMapping(int securityModel, OctetString securityName) {
        OID index = VacmMIB.createGroupIndex(securityModel, securityName);
        return this.vacmSecurityToGroupTableModel.containsRow(index);
    }

    @Override
    public void addAccess(OctetString groupName, OctetString contextPrefix, int securityModel, int securityLevel, int match, OctetString readView, OctetString writeView, OctetString notifyView, int storageType) {
        OID index = VacmMIB.createAccessIndex(groupName, contextPrefix, securityModel, securityLevel);
        Variable[] values = new Variable[this.vacmAccessTable.getColumnCount()];
        values[0] = new Integer32(match);
        values[1] = readView;
        values[2] = writeView;
        values[3] = notifyView;
        values[4] = new Integer32(storageType);
        values[5] = new Integer32(1);
        this.vacmAccessTable.addRow(this.vacmAccessTableModel.createRow(index, values));
    }

    @Override
    public boolean removeAccess(OctetString groupName, OctetString contextPrefix, int securityModel, int securityLevel) {
        OID index = VacmMIB.createAccessIndex(groupName, contextPrefix, securityModel, securityLevel);
        return this.vacmAccessTable.removeRow(index) != null;
    }

    @Override
    public int accessEntryCount(OctetString groupName) {
        OID lowerBound = groupName.toSubIndex(false);
        OID upperBound = new OID(lowerBound).nextPeer();
        return this.vacmAccessTableModel.getRows(lowerBound, upperBound).size();
    }

    private static OID createAccessIndex(OctetString groupName, OctetString contextPrefix, int securityModel, int securityLevel) {
        OID index = groupName.toSubIndex(false);
        if (contextPrefix == null) {
            index.append(0);
        } else {
            index.append(contextPrefix.toSubIndex(false));
        }
        index.append(securityModel);
        index.append(securityLevel);
        return index;
    }

    @Override
    public void addViewTreeFamily(OctetString viewName, OID subtree, OctetString mask, int type, int storageType) {
        OID index = VacmMIB.createViewIndex(viewName, subtree);
        Variable[] values = new Variable[this.vacmViewTreeFamilyTable.getColumnCount()];
        values[0] = mask;
        values[1] = new Integer32(type);
        values[2] = new Integer32(storageType);
        values[3] = new Integer32(1);
        DefaultMOMutableRow2PC row = this.vacmViewTreeFamilyTableModel.createRow(index, values);
        this.vacmViewTreeFamilyTable.addRow(row);
    }

    @Override
    public boolean removeViewTreeFamily(OctetString viewName, OID subtree) {
        OID index = VacmMIB.createViewIndex(viewName, subtree);
        return this.vacmViewTreeFamilyTable.removeRow(index) != null;
    }

    @Override
    public int viewTreeFamilyEntryCount(OctetString viewName) {
        OID lowerBound = viewName.toSubIndex(false);
        OID upperBound = new OID(lowerBound).nextPeer();
        return this.vacmViewTreeFamilyTableModel.getRows(lowerBound, upperBound).size();
    }

    private static OID createViewIndex(OctetString viewName, OID subtree) {
        OID index = viewName.toSubIndex(false);
        index.append(subtree.toSubIndex(false));
        return index;
    }

    public static boolean isBitSet(int n, OctetString os) {
        return os.length() <= n / 8 || (os.get(n / 8) & 1 << 7 - n % 8) > 0;
    }

    private List<MOTableRow> getAccessEntries(OctetString groupName) {
        OctetString upperBound = new OctetString(groupName);
        int last = -1;
        if (upperBound.length() > 0) {
            last = upperBound.get(upperBound.length() - 1);
        }
        if (last == -1) {
            upperBound.append((byte)0);
        } else {
            upperBound.set(upperBound.length() - 1, (byte)(last + 1));
        }
        OID lowerOID = groupName.toSubIndex(false);
        OID upperOID = upperBound.toSubIndex(false);
        return this.vacmAccessTableModel.getRows(lowerOID, upperOID);
    }

    protected List<MOTableRow> getViews(OctetString viewName) {
        if (viewName.length() == 0) {
            return Collections.emptyList();
        }
        OctetString upperBound = new OctetString(viewName);
        byte last = upperBound.get(upperBound.length() - 1);
        if (last == -1) {
            upperBound.append((byte)0);
        } else {
            upperBound.set(upperBound.length() - 1, (byte)(last + 1));
        }
        OID lowerOID = viewName.toSubIndex(false);
        OID upperOID = upperBound.toSubIndex(false);
        return this.vacmViewTreeFamilyTableModel.getRows(lowerOID, upperOID);
    }

    public DefaultMOTable<DefaultMOMutableRow2PC, MOColumn, DefaultMOMutableTableModel<DefaultMOMutableRow2PC>> getVacmSecurityToGroupTable() {
        return this.vacmSecurityToGroupTable;
    }

    DefaultMOTable<DefaultMOMutableRow2PC, MOColumn, DefaultMOMutableTableModel<DefaultMOMutableRow2PC>> getVacmViewTreeFamilyTable() {
        return this.vacmViewTreeFamilyTable;
    }

    private static OctetString getContextFromIndex(OID index) {
        if (index.size() > 0) {
            return new OctetString(index.toByteArray(), 1, index.size() - 1);
        }
        return new OctetString();
    }

    class VacmContextTableModel
    implements MOTableModel<MOTableRow> {
        VacmContextTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            int n = 0;
            for (MOServer aServer : VacmMIB.this.server) {
                n += aServer.getContexts().length;
            }
            return n;
        }

        @Override
        public boolean isEmpty() {
            for (MOServer aServer : VacmMIB.this.server) {
                if (aServer.getContexts().length <= 0) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean containsRow(OID index) {
            return VacmMIB.this.isContextSupported(VacmMIB.getContextFromIndex(index));
        }

        @Override
        public MOTableRow getRow(OID index) {
            if (index == null) {
                return null;
            }
            OctetString context = VacmMIB.getContextFromIndex(index);
            if (VacmMIB.this.isContextSupported(context)) {
                return new DefaultMOTableRow(index, new Variable[]{context});
            }
            return null;
        }

        @Override
        public Iterator<MOTableRow> iterator() {
            return this.tailIterator(new OID());
        }

        @Override
        public Iterator<MOTableRow> tailIterator(OID lowerBound) {
            OctetString[] contexts = this.getContexts();
            LexicographicOctetStringComparator contextComparator = new LexicographicOctetStringComparator();
            Arrays.sort(contexts, contextComparator);
            int offset = 0;
            if (lowerBound != null) {
                offset = Arrays.binarySearch(contexts, VacmMIB.getContextFromIndex(lowerBound), contextComparator);
            }
            if (offset < 0) {
                offset = -(offset + 1);
            }
            return new VacmContextIterator(contexts, offset);
        }

        private OctetString[] getContexts() {
            ArrayList<OctetString> ctx = new ArrayList<OctetString>();
            for (MOServer aServer : VacmMIB.this.server) {
                ctx.addAll(Arrays.asList(aServer.getContexts()));
            }
            return ctx.toArray(new OctetString[0]);
        }

        @Override
        public OID lastIndex() {
            OctetString[] contexts = this.getContexts();
            if (contexts.length == 0) {
                return null;
            }
            Arrays.sort(contexts, new LexicographicOctetStringComparator());
            return contexts[contexts.length - 1].toSubIndex(false);
        }

        @Override
        public OID firstIndex() {
            OctetString[] contexts = this.getContexts();
            if (contexts.length == 0) {
                return null;
            }
            Arrays.sort(contexts, new LexicographicOctetStringComparator());
            return contexts[0].toSubIndex(false);
        }

        @Override
        public MOTableRow firstRow() {
            return this.getRow(this.firstIndex());
        }

        @Override
        public MOTableRow lastRow() {
            return this.getRow(this.lastIndex());
        }
    }

    public static class VacmContextIterator
    implements Iterator<MOTableRow> {
        private int index = 0;
        private final OctetString[] contexts;

        VacmContextIterator(OctetString[] contexts, int offset) {
            this.contexts = contexts;
            this.index = offset;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.contexts.length;
        }

        @Override
        public MOTableRow next() {
            if (this.index < this.contexts.length) {
                OctetString context = this.contexts[this.index++];
                return new DefaultMOTableRow(context.toSubIndex(false), new Variable[]{context});
            }
            throw new NoSuchElementException();
        }
    }
}

