/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo;

import org.snmp4j.agent.ManagedObject;
import org.snmp4j.agent.mo.DeniableEventObject;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.Variable;

public class MOChangeEvent
extends DeniableEventObject {
    private static final long serialVersionUID = 2377168127200875177L;
    private ManagedObject<SubRequest<?>> changedObject;
    private OID oid;
    private Variable oldValue;
    private Variable newValue;
    private Modification modification;
    private OidType oidType;
    private SubRequest<?> subRequest;

    public MOChangeEvent(Object source, ManagedObject<SubRequest<?>> changedObject, OID oid, Variable oldValue, Variable newValue) {
        this(source, changedObject, oid, oldValue, newValue, true, null);
    }

    protected Modification getModificationFromValues(Variable oldValue, Variable newValue) {
        if (oldValue == null && newValue != null) {
            return Modification.added;
        }
        if (oldValue != null && newValue == null) {
            return Modification.removed;
        }
        return Modification.updated;
    }

    public MOChangeEvent(Object source, ManagedObject<SubRequest<?>> changedObject, OID index, Modification modification) {
        super(source, false);
        this.changedObject = changedObject;
        this.oid = index;
        this.modification = modification;
        this.oidType = OidType.index;
    }

    public MOChangeEvent(Object source, ManagedObject<SubRequest<?>> changedObject, OID index, Modification modification, SubRequest<?> subRequest) {
        this(source, changedObject, index, modification);
        this.subRequest = subRequest;
    }

    public MOChangeEvent(Object source, ManagedObject<SubRequest<?>> changedObject, OID oid, Variable oldValue, Variable newValue, boolean deniable) {
        super(source, deniable);
        this.changedObject = changedObject;
        this.oid = oid;
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.modification = this.getModificationFromValues(oldValue, newValue);
        this.oidType = OidType.fullyQualified;
    }

    public MOChangeEvent(Object source, ManagedObject<SubRequest<?>> changedObject, OID oid, Variable oldValue, Variable newValue, boolean deniable, SubRequest<?> subRequest) {
        this(source, changedObject, oid, oldValue, newValue, deniable);
        this.subRequest = subRequest;
    }

    public ManagedObject<SubRequest<?>> getChangedObject() {
        return this.changedObject;
    }

    public OID getOID() {
        return this.oid;
    }

    public Variable getOldValue() {
        return this.oldValue;
    }

    public Variable getNewValue() {
        return this.newValue;
    }

    public Modification getModification() {
        return this.modification;
    }

    public OidType getOidType() {
        return this.oidType;
    }

    public SubRequest<?> getSubRequest() {
        return this.subRequest;
    }

    @Override
    public String toString() {
        return "MOChangeEvent{changedObject=" + String.valueOf(this.changedObject) + ", oid=" + String.valueOf(this.oid) + ", oldValue=" + String.valueOf(this.oldValue) + ", newValue=" + String.valueOf(this.newValue) + ", modification=" + String.valueOf((Object)this.modification) + ", oidType=" + String.valueOf((Object)this.oidType) + ", subRequest=" + String.valueOf(this.subRequest) + "}";
    }

    public static enum Modification {
        created,
        added,
        updated,
        removed;

    }

    public static enum OidType {
        fullyQualified,
        instanceSuffix,
        index;

    }
}

