/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.snmp4j.CommandResponder;
import org.snmp4j.MessageDispatcher;
import org.snmp4j.Session;
import org.snmp4j.Snmp;
import org.snmp4j.TransportMapping;
import org.snmp4j.agent.AgentState;
import org.snmp4j.agent.AgentStateListener;
import org.snmp4j.agent.CommandProcessor;
import org.snmp4j.agent.DefaultMOContextScope;
import org.snmp4j.agent.DefaultMOServer;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOGroup;
import org.snmp4j.agent.MOQuery;
import org.snmp4j.agent.MOQueryWithSource;
import org.snmp4j.agent.MOScope;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.ManagedObject;
import org.snmp4j.agent.NotificationOriginator;
import org.snmp4j.agent.ProxyForwarder;
import org.snmp4j.agent.cfg.EngineBootsProvider;
import org.snmp4j.agent.io.MOInput;
import org.snmp4j.agent.io.MOInputFactory;
import org.snmp4j.agent.io.MOPersistenceProvider;
import org.snmp4j.agent.io.MOServerPersistence;
import org.snmp4j.agent.mo.DefaultMOFactory;
import org.snmp4j.agent.mo.GenericManagedObject;
import org.snmp4j.agent.mo.MOFactory;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.snmp.NotificationLogMib;
import org.snmp4j.agent.mo.snmp.NotificationOriginatorImpl;
import org.snmp4j.agent.mo.snmp.ProxyForwarderImpl;
import org.snmp4j.agent.mo.snmp.SNMPv2MIB;
import org.snmp4j.agent.mo.snmp.SnmpCommunityMIB;
import org.snmp4j.agent.mo.snmp.SnmpFrameworkMIB;
import org.snmp4j.agent.mo.snmp.SnmpMpdMib;
import org.snmp4j.agent.mo.snmp.SnmpNotificationMIB;
import org.snmp4j.agent.mo.snmp.SnmpProxyMIB;
import org.snmp4j.agent.mo.snmp.SnmpTargetMIB;
import org.snmp4j.agent.mo.snmp.SnmpTlsTmMib;
import org.snmp4j.agent.mo.snmp.SysUpTime;
import org.snmp4j.agent.mo.snmp.UsmMIB;
import org.snmp4j.agent.mo.snmp.VacmMIB;
import org.snmp4j.agent.mo.snmp.dh.DHKickstartParameters;
import org.snmp4j.agent.mo.snmp.dh.SnmpUsmDhObjectsMib;
import org.snmp4j.agent.mo.snmp4j.Snmp4jConfigMib;
import org.snmp4j.agent.mo.snmp4j.Snmp4jLogMib;
import org.snmp4j.agent.mo.snmp4j.Snmp4jProxyMib;
import org.snmp4j.agent.mo.util.MOTableSizeLimit;
import org.snmp4j.agent.mo.util.VariableProvider;
import org.snmp4j.agent.request.Request;
import org.snmp4j.agent.request.RequestStatus;
import org.snmp4j.agent.request.SnmpRequest;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.agent.request.SubRequestIterator;
import org.snmp4j.agent.security.VACM;
import org.snmp4j.event.CounterListener;
import org.snmp4j.event.UsmUserListener;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.MPv1;
import org.snmp4j.mp.MPv2c;
import org.snmp4j.mp.MPv3;
import org.snmp4j.mp.MessageProcessingModel;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.security.SecurityModel;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.TSM;
import org.snmp4j.security.USM;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UnsignedInteger32;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.TLSTM;
import org.snmp4j.transport.TransportListener;
import org.snmp4j.transport.tls.TlsTmSecurityCallback;
import org.snmp4j.transport.tls.X509TlsTransportMappingConfig;
import org.snmp4j.util.WorkerPool;
import org.snmp4j.version.VersionInfo;

public class AgentConfigManager
implements Runnable,
VariableProvider {
    private static final LogAdapter logger = LogFactory.getLogger(AgentConfigManager.class);
    protected CommandProcessor agent;
    protected WorkerPool workerPool;
    protected VACM vacm;
    protected USM usm;
    protected MOServer[] servers;
    protected Session session;
    protected MessageDispatcher dispatcher;
    protected OctetString engineID;
    protected ProxyForwarder proxyForwarder;
    protected NotificationOriginator notificationOriginator;
    protected MOInputFactory configuration;
    protected MOPersistenceProvider persistenceProvider;
    protected int persistenceImportMode = 2;
    protected EngineBootsProvider engineBootsProvider;
    protected SNMPv2MIB snmpv2MIB;
    protected SnmpMpdMib snmpMpdMib;
    protected SnmpTargetMIB targetMIB;
    protected SnmpCommunityMIB communityMIB;
    protected SnmpNotificationMIB notificationMIB;
    protected SnmpFrameworkMIB frameworkMIB;
    protected UsmMIB usmMIB;
    protected VacmMIB vacmMIB;
    protected SnmpTlsTmMib tlsTmMib;
    protected SnmpProxyMIB proxyMIB;
    protected SnmpUsmDhObjectsMib snmpUsmDhObjectsMib;
    protected Snmp4jLogMib snmp4jLogMIB;
    protected Snmp4jConfigMib snmp4jConfigMIB;
    protected Snmp4jProxyMib snmp4jProxyMIB;
    protected NotificationLogMib notificationLogMIB;
    protected UnsignedInteger32 notificationLogDefaultLimit = new UnsignedInteger32(100);
    protected UnsignedInteger32 notificaitonLogGlobalLimit = new UnsignedInteger32(1000);
    protected UnsignedInteger32 notificaitonLogGlobalAge = new UnsignedInteger32(0);
    protected MOFactory moFactory = DefaultMOFactory.getInstance();
    protected OctetString sysDescr = new OctetString("SNMP4J-Agent " + VersionInfo.getVersion() + " [" + VersionInfo.getVersion() + "] - " + System.getProperty("os.name", "") + " - " + System.getProperty("os.arch") + " - " + System.getProperty("os.version"));
    protected OID sysOID = new OID("1.3.6.1.4.1.4976.10");
    protected Integer32 sysServices = new Integer32(72);
    protected OctetString defaultContext;
    protected org.snmp4j.agent.AgentState runState = new AgentState();
    protected MOTableSizeLimit<MOTableRow> tableSizeLimit;
    protected Collection<DHKickstartParameters> diffieHellmanKickstartParameters;
    protected List<AgentStateListener<AgentConfigManager>> agentStateListeners = new ArrayList<AgentStateListener<AgentConfigManager>>(2);

    public AgentConfigManager(OctetString agentsOwnEngineID, MessageDispatcher messageDispatcher, VACM vacm, MOServer[] moServers, WorkerPool workerPool, MOInputFactory configurationFactory, MOPersistenceProvider persistenceProvider, EngineBootsProvider engineBootsProvider) {
        this.engineID = agentsOwnEngineID;
        this.dispatcher = messageDispatcher;
        this.vacm = vacm;
        this.servers = moServers;
        this.workerPool = workerPool;
        this.configuration = configurationFactory;
        this.engineBootsProvider = engineBootsProvider;
        this.persistenceProvider = persistenceProvider;
    }

    public AgentConfigManager(OctetString agentsOwnEngineID, MessageDispatcher messageDispatcher, VACM vacm, MOServer[] moServers, WorkerPool workerPool, MOInputFactory configurationFactory, MOPersistenceProvider persistenceProvider, EngineBootsProvider engineBootsProvider, MOFactory moFactory) {
        this(agentsOwnEngineID, messageDispatcher, vacm, moServers, workerPool, configurationFactory, persistenceProvider, engineBootsProvider);
        this.moFactory = moFactory == null ? this.moFactory : moFactory;
    }

    public AgentConfigManager(OctetString agentsOwnEngineID, MessageDispatcher messageDispatcher, VACM vacm, MOServer[] moServers, WorkerPool workerPool, MOInputFactory configurationFactory, MOPersistenceProvider persistenceProvider, EngineBootsProvider engineBootsProvider, MOFactory moFactory, Collection<DHKickstartParameters> diffieHellmanKickstartParameters) {
        this(agentsOwnEngineID, messageDispatcher, vacm, moServers, workerPool, configurationFactory, persistenceProvider, engineBootsProvider, moFactory);
        this.diffieHellmanKickstartParameters = diffieHellmanKickstartParameters;
    }

    @Override
    public void run() {
        if (this.runState.getState() < 10) {
            this.initialize();
        }
        if (this.runState.getState() < 20) {
            this.configure();
        }
        if (this.runState.getState() < 30) {
            this.restoreState();
        }
        if (this.runState.getState() < 40) {
            this.launch();
        }
    }

    public synchronized void addAgentStateListener(AgentStateListener<AgentConfigManager> agentStateListener) {
        this.agentStateListeners.add(agentStateListener);
    }

    public synchronized boolean removeAgentStateListener(AgentStateListener<AgentConfigManager> agentStateListener) {
        return this.agentStateListeners.remove(agentStateListener);
    }

    protected synchronized void fireAgentStateChange() {
        for (AgentStateListener<AgentConfigManager> agentStateListener : this.agentStateListeners) {
            agentStateListener.agentStateChanged(this, this.runState);
        }
    }

    public int getState() {
        return this.runState.getState();
    }

    public VACM getVACM() {
        return this.vacm;
    }

    public SNMPv2MIB getSNMPv2MIB() {
        return this.snmpv2MIB;
    }

    public SnmpMpdMib getSnmpMpdMib() {
        return this.snmpMpdMib;
    }

    public SnmpTargetMIB getSnmpTargetMIB() {
        return this.targetMIB;
    }

    public SnmpNotificationMIB getSnmpNotificationMIB() {
        return this.notificationMIB;
    }

    public SnmpCommunityMIB getSnmpCommunityMIB() {
        return this.communityMIB;
    }

    public NotificationLogMib getNotificationLogMIB() {
        return this.notificationLogMIB;
    }

    public Snmp4jLogMib getSnmp4jLogMIB() {
        return this.snmp4jLogMIB;
    }

    public Snmp4jConfigMib getSnmp4jConfigMIB() {
        return this.snmp4jConfigMIB;
    }

    public Snmp4jProxyMib getSnmp4jProxyMIB() {
        return this.snmp4jProxyMIB;
    }

    protected void launch() {
        if (this.tableSizeLimit != null) {
            for (MOServer server : this.servers) {
                DefaultMOServer.unregisterTableRowListener(server, this.tableSizeLimit);
                DefaultMOServer.registerTableRowListener(server, this.tableSizeLimit);
            }
        }
        this.dispatcher.removeCommandResponder((CommandResponder)this.agent);
        this.dispatcher.addCommandResponder((CommandResponder)this.agent);
        this.registerTransportMappings();
        try {
            this.launchTransportMappings();
        }
        catch (IOException ex) {
            String txt = "Could not put all transport mappings in listen mode: " + ex.getMessage();
            logger.error((CharSequence)txt, (Throwable)ex);
            this.runState.addError(new ErrorDescriptor(txt, this.runState.getState(), 40, ex));
        }
        this.runState.advanceState(40);
        this.fireLaunchNotifications();
    }

    protected void fireLaunchNotifications() {
        if (this.notificationOriginator != null) {
            this.notificationOriginator.notify(new OctetString(), SnmpConstants.coldStart, new VariableBinding[0]);
        }
    }

    public boolean continueProcessing() {
        if (this.runState.getState() == 35) {
            this.dispatcher.removeCommandResponder((CommandResponder)this.agent);
            this.dispatcher.addCommandResponder((CommandResponder)this.agent);
            this.runState.setState(40);
            return true;
        }
        return false;
    }

    public void suspendProcessing() {
        this.dispatcher.removeCommandResponder((CommandResponder)this.agent);
        this.runState.setState(35);
    }

    public void shutdown() {
        logger.info((CharSequence)"Shutdown agent: suspending request processing");
        this.suspendProcessing();
        try {
            if (this.dispatcher != null) {
                logger.info((CharSequence)"Shutdown agent: closing transport mappings");
                AgentConfigManager.stopTransportMappings(this.dispatcher.getTransportMappings());
            }
            if (this.session != null) {
                logger.info((CharSequence)"Shutdown agent: closing session");
                this.session.close();
                this.session = null;
            }
        }
        catch (IOException ex) {
            logger.warn((Serializable)((Object)("Failed to close SNMP session: " + ex.getMessage())));
        }
        logger.info((CharSequence)"Shutdown agent: saving state");
        if (!this.saveState() && this.persistenceProvider != null) {
            logger.error((Serializable)((Object)"Agent state could not be saved!"));
        }
        if (this.tableSizeLimit != null) {
            for (MOServer server : this.servers) {
                DefaultMOServer.unregisterTableRowListener(server, this.tableSizeLimit);
            }
        }
        logger.info((CharSequence)"Shutdown agent: unregistering MIB objects");
        this.unregisterMIBs(null);
        this.runState.setState(-1);
        logger.info((CharSequence)"Shutdown agent: finished");
    }

    public void registerShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                AgentConfigManager.this.shutdown();
            }
        });
    }

    public void initSnmp4jLogMIB() {
        this.snmp4jLogMIB = new Snmp4jLogMib();
    }

    public void initSnmp4jConfigMIB(MOPersistenceProvider[] persistenceProvider) {
        this.snmp4jConfigMIB = new Snmp4jConfigMib(this.snmpv2MIB.getSysUpTime());
        this.snmp4jConfigMIB.setSnmpCommunityMIB(this.communityMIB);
        if (this.persistenceProvider != null) {
            this.snmp4jConfigMIB.setPrimaryProvider(this.persistenceProvider);
        }
        if (persistenceProvider != null) {
            for (MOPersistenceProvider aPersistenceProvider : persistenceProvider) {
                if (aPersistenceProvider == this.persistenceProvider) continue;
                this.snmp4jConfigMIB.addPersistenceProvider(aPersistenceProvider);
            }
        }
    }

    public void initSnmp4jProxyMIB(OctetString context) {
        MOServer server = this.agent.getServer(context);
        this.snmp4jProxyMIB = new Snmp4jProxyMib(this.moFactory, this.session, server, this.targetMIB);
    }

    public VacmMIB getVacmMIB() {
        return this.vacmMIB;
    }

    public USM getUsm() {
        return this.usm;
    }

    public UsmMIB getUsmMIB() {
        return this.usmMIB;
    }

    protected void initNotificationLogMIB(VACM vacm, SnmpNotificationMIB notifyMIB) {
        this.notificationLogMIB = new NotificationLogMib(this.moFactory, vacm, notifyMIB);
        NotificationLogMib.NlmConfigLogEntryRow row = this.notificationLogMIB.getNlmConfigLogEntry().createRow(new OID(new int[]{0}), new Variable[]{new OctetString(), this.notificationLogDefaultLimit, new Integer32(1), new Integer32(), new Integer32(4), new Integer32(1)});
        this.notificationLogMIB.getNlmConfigLogEntry().addRow(row);
        this.notificationLogMIB.getNlmConfigGlobalAgeOut().setValue(this.notificaitonLogGlobalAge);
        this.notificationLogMIB.getNlmConfigGlobalEntryLimit().setValue(this.notificaitonLogGlobalLimit);
        if (this.notificationOriginator instanceof NotificationOriginatorImpl) {
            ((NotificationOriginatorImpl)this.notificationOriginator).removeNotificationLogListener(this.notificationLogMIB);
            ((NotificationOriginatorImpl)this.notificationOriginator).addNotificationLogListener(this.notificationLogMIB);
        }
    }

    protected void initSecurityModels(EngineBootsProvider engineBootsProvider) {
        TSM tsm;
        this.usm = this.createUSM();
        if (this.usm != null) {
            SecurityModels.getInstance().addSecurityModel((SecurityModel)this.usm);
        }
        if ((tsm = this.createTSM()) != null) {
            SecurityModels.getInstance().addSecurityModel((SecurityModel)tsm);
        }
        this.frameworkMIB = new SnmpFrameworkMIB(this.usm, this.dispatcher.getTransportMappings());
    }

    protected void initMessageDispatcherWithMPs(MessageDispatcher mp) {
        mp.addMessageProcessingModel((MessageProcessingModel)new MPv1());
        mp.addMessageProcessingModel((MessageProcessingModel)new MPv2c());
        MPv3 mpv3 = new MPv3(this.engineID.getValue());
        mp.addMessageProcessingModel((MessageProcessingModel)mpv3);
    }

    protected void registerTransportMappings() {
        ArrayList l = new ArrayList(this.dispatcher.getTransportMappings());
        for (TransportMapping tm : l) {
            tm.removeTransportListener((TransportListener)this.dispatcher);
            tm.addTransportListener((TransportListener)this.dispatcher);
            if (!(tm instanceof X509TlsTransportMappingConfig)) continue;
            ((X509TlsTransportMappingConfig)tm).setSecurityCallback((TlsTmSecurityCallback)this.tlsTmMib);
        }
    }

    protected void launchTransportMappings() throws IOException {
        AgentConfigManager.launchTransportMappings(this.dispatcher.getTransportMappings());
    }

    protected static void launchTransportMappings(Collection<? extends TransportMapping<?>> transportMappings) throws IOException {
        ArrayList l = new ArrayList(transportMappings);
        for (TransportMapping<?> tm : l) {
            if (tm.isListening()) continue;
            tm.listen();
        }
    }

    protected static void stopTransportMappings(Collection<? extends TransportMapping<?>> transportMappings) throws IOException {
        ArrayList l = new ArrayList(transportMappings);
        for (TransportMapping<?> tm : l) {
            tm.close();
        }
    }

    public boolean saveState() {
        if (this.persistenceProvider != null) {
            try {
                this.persistenceProvider.store(this.persistenceProvider.getDefaultURI());
                this.runState.advanceState(50);
                return true;
            }
            catch (IOException ex) {
                String txt = "Failed to save agent state: " + ex.getMessage();
                logger.error((CharSequence)txt, (Throwable)ex);
                this.runState.addError(new ErrorDescriptor(txt, this.runState.getState(), 50, ex));
            }
        }
        return false;
    }

    public boolean restoreState() {
        if (this.persistenceProvider != null) {
            try {
                if (logger.isInfoEnabled()) {
                    logger.info((CharSequence)("Restoring persistent data (mode=" + this.persistenceImportMode + ") from " + this.persistenceProvider.getDefaultURI()));
                }
                this.persistenceProvider.restore(this.persistenceProvider.getDefaultURI(), this.persistenceImportMode);
                this.runState.advanceState(30);
                return true;
            }
            catch (FileNotFoundException fnf) {
                String txt = "Saved agent state not found: " + fnf.getMessage();
                logger.warn((Serializable)((Object)txt));
            }
            catch (IOException ex) {
                String txt = "Failed to load agent state: " + ex.getMessage();
                logger.error((CharSequence)txt, (Throwable)ex);
                this.runState.addError(new ErrorDescriptor(txt, this.runState.getState(), 30, ex));
            }
        }
        return false;
    }

    public void configure() {
        if (this.configuration != null) {
            MOInput config = this.configuration.createMOInput();
            if (config == null) {
                logger.debug((Serializable)((Object)("No configuration returned by configuration factory " + this.configuration)));
                return;
            }
            MOServerPersistence serverPersistence = new MOServerPersistence(this.servers);
            try {
                serverPersistence.loadData(config);
            }
            catch (IOException ex) {
                String txt = "Failed to load agent configuration: " + ex.getMessage();
                logger.error((CharSequence)txt, (Throwable)ex);
                this.runState.addError(new ErrorDescriptor(txt, this.runState.getState(), 20, ex));
                throw new RuntimeException(txt, ex);
            }
            finally {
                try {
                    config.close();
                }
                catch (IOException ex1) {
                    logger.warn((Serializable)((Object)("Failed to close config input stream: " + ex1.getMessage())));
                }
            }
        }
        this.runState.advanceState(20);
    }

    protected void initMandatoryMIBs() {
        this.targetMIB = new SnmpTargetMIB(this.dispatcher);
        this.targetMIB.addDefaultTDomains();
        this.snmpv2MIB = new SNMPv2MIB(this.getSysDescr(), this.getSysOID(), this.getSysServices());
        this.snmpMpdMib = new SnmpMpdMib(this.moFactory);
        this.notificationMIB = new SnmpNotificationMIB();
        this.vacmMIB = new VacmMIB(this.servers);
        this.usmMIB = new UsmMIB(this.usm, this.getSupportedSecurityProtocols());
        this.usm.addUsmUserListener((UsmUserListener)this.usmMIB);
        this.communityMIB = new SnmpCommunityMIB(this.targetMIB);
        this.tlsTmMib = new SnmpTlsTmMib(this.moFactory, this.targetMIB);
        this.targetMIB.setTlsTmMib(this.tlsTmMib);
    }

    protected void linkCounterListener() {
        this.agent.removeCounterListener(this.snmpv2MIB);
        this.agent.addCounterListener(this.snmpv2MIB);
        this.usm.getCounterSupport().removeCounterListener((CounterListener)this.snmpv2MIB);
        this.usm.getCounterSupport().addCounterListener((CounterListener)this.snmpv2MIB);
        this.agent.removeCounterListener(this.snmpMpdMib);
        this.agent.addCounterListener(this.snmpMpdMib);
        MPv3 mpv3 = (MPv3)this.dispatcher.getMessageProcessingModel(3);
        if (mpv3 != null && mpv3.getCounterSupport() != null) {
            mpv3.getCounterSupport().removeCounterListener((CounterListener)this.snmpMpdMib);
            mpv3.getCounterSupport().addCounterListener((CounterListener)this.snmpMpdMib);
        }
        this.dispatcher.removeCounterListener((CounterListener)this.snmpMpdMib);
        this.dispatcher.addCounterListener((CounterListener)this.snmpMpdMib);
        this.dispatcher.removeCounterListener((CounterListener)this.snmpv2MIB);
        this.dispatcher.addCounterListener((CounterListener)this.snmpv2MIB);
        for (TransportMapping tm : this.dispatcher.getTransportMappings()) {
            if (!(tm instanceof TLSTM)) continue;
            TLSTM tlstm = (TLSTM)tm;
            tlstm.getCounterSupport().removeCounterListener(this.tlsTmMib.getCounterListener());
            tlstm.getCounterSupport().addCounterListener(this.tlsTmMib.getCounterListener());
        }
    }

    protected SecurityProtocols getSupportedSecurityProtocols() {
        SecurityProtocols.getInstance().addDefaultProtocols();
        return SecurityProtocols.getInstance();
    }

    protected USM createUSM() {
        return new USM(this.getSupportedSecurityProtocols(), this.engineID, this.engineBootsProvider.updateEngineBoots());
    }

    protected TSM createTSM() {
        return new TSM(this.engineID, false);
    }

    public Integer32 getSysServices() {
        return this.sysServices;
    }

    public OID getSysOID() {
        return this.sysOID;
    }

    public OctetString getSysDescr() {
        return this.sysDescr;
    }

    public SysUpTime getSysUpTime() {
        return this.snmpv2MIB.getSysUpTime();
    }

    public NotificationOriginator getNotificationOriginator() {
        return this.notificationOriginator;
    }

    public NotificationOriginator getAgentNotificationOriginator() {
        return this.agent.getNotificationOriginator();
    }

    public void setNotificationOriginator(NotificationOriginator notificationOriginator) {
        this.notificationOriginator = notificationOriginator;
        if (this.agent != null) {
            this.agent.setNotificationOriginator(notificationOriginator);
        }
    }

    private VACM vacm() {
        if (this.vacm != null) {
            return this.vacm;
        }
        return this.vacmMIB;
    }

    public void initialize() {
        this.session = this.createSnmpSession(this.dispatcher);
        if (this.engineID == null) {
            this.engineID = new OctetString(MPv3.createLocalEngineID());
        }
        this.agent = this.createCommandProcessor(this.engineID);
        for (MOServer server : this.servers) {
            this.agent.addMOServer(server);
        }
        this.agent.setWorkerPool(this.workerPool);
        this.initSecurityModels(this.engineBootsProvider);
        this.initMessageDispatcherWithMPs(this.dispatcher);
        this.initMandatoryMIBs();
        this.linkCounterListener();
        this.agent.setVacm(this.vacm());
        this.agent.setCoexistenceProvider(this.communityMIB);
        if (this.notificationOriginator == null) {
            this.notificationOriginator = this.createNotificationOriginator();
        }
        this.agent.setNotificationOriginator(this.notificationOriginator);
        this.snmpv2MIB.setNotificationOriginator(this.agent);
        this.initOptionalMIBs();
        try {
            this.registerMIBs(this.getDefaultContext());
        }
        catch (DuplicateRegistrationException drex) {
            logger.error((CharSequence)("Duplicate MO registration: " + drex.getMessage()), (Throwable)drex);
        }
        this.runState.advanceState(10);
    }

    public void setTableSizeLimits(Properties sizeLimits) {
        if (this.tableSizeLimit != null && this.servers != null) {
            for (MOServer server : this.servers) {
                DefaultMOServer.unregisterTableRowListener(server, this.tableSizeLimit);
            }
        }
        this.tableSizeLimit = new MOTableSizeLimit(sizeLimits);
        if (this.getState() == 40) {
            for (MOServer server : this.servers) {
                DefaultMOServer.registerTableRowListener(server, this.tableSizeLimit);
            }
        }
    }

    public void setTableSizeLimit(int sizeLimit) {
        if (this.tableSizeLimit != null && this.servers != null) {
            for (MOServer server : this.servers) {
                DefaultMOServer.unregisterTableRowListener(server, this.tableSizeLimit);
            }
        }
        this.tableSizeLimit = new MOTableSizeLimit(sizeLimit);
        if (this.getState() == 40) {
            for (MOServer server : this.servers) {
                DefaultMOServer.registerTableRowListener(server, this.tableSizeLimit);
            }
        }
    }

    protected void initOptionalMIBs() {
        this.initSnmp4jLogMIB();
        this.initSnmp4jConfigMIB(null);
        if (this.vacm() != null && this.notificationMIB != null) {
            this.initNotificationLogMIB(this.vacm(), this.notificationMIB);
        }
        this.initSnmp4jProxyMIB(this.getDefaultContext());
        this.initSnmpUsmDhObjectsMib();
    }

    protected void initSnmpUsmDhObjectsMib() {
        Collection<DHKickstartParameters> dhKickstartParametersList = this.getDhKickstartParameters();
        if (dhKickstartParametersList == null) {
            dhKickstartParametersList = Collections.emptyList();
        }
        this.setupSnmpUsmDhObjectsMib(dhKickstartParametersList);
    }

    protected Collection<DHKickstartParameters> getDhKickstartParameters() {
        return this.diffieHellmanKickstartParameters;
    }

    public OctetString getDefaultContext() {
        return this.defaultContext;
    }

    protected OctetString getContext(MOGroup mibGroup, OctetString defaultContext) {
        return defaultContext;
    }

    protected void registerMIBs(OctetString context) throws DuplicateRegistrationException {
        MOServer server = this.agent.getServer(context);
        if (server != null) {
            this.targetMIB.registerMOs(server, this.getContext(this.targetMIB, context));
            this.notificationMIB.registerMOs(server, this.getContext(this.notificationMIB, context));
            this.vacmMIB.registerMOs(server, this.getContext(this.vacmMIB, context));
            this.usmMIB.registerMOs(server, this.getContext(this.usmMIB, context));
            this.snmpv2MIB.registerMOs(server, this.getContext(this.snmpv2MIB, context));
            this.snmpMpdMib.registerMOs(server, this.getContext(this.snmpMpdMib, context));
            this.frameworkMIB.registerMOs(server, this.getContext(this.frameworkMIB, context));
            this.communityMIB.registerMOs(server, this.getContext(this.communityMIB, context));
            if (this.snmp4jLogMIB != null) {
                this.snmp4jLogMIB.registerMOs(server, this.getContext(this.snmp4jLogMIB, context));
            }
            if (this.snmp4jConfigMIB != null) {
                this.snmp4jConfigMIB.registerMOs(server, this.getContext(this.snmp4jConfigMIB, context));
            }
            if (this.snmp4jProxyMIB != null) {
                this.snmp4jProxyMIB.registerMOs(server, this.getContext(this.snmp4jProxyMIB, context));
            }
            if (this.proxyMIB != null) {
                this.proxyMIB.registerMOs(server, this.getContext(this.proxyMIB, context));
            }
            if (this.snmpUsmDhObjectsMib != null) {
                this.snmpUsmDhObjectsMib.registerMOs(server, this.getContext(this.snmpUsmDhObjectsMib, context));
            }
            if (this.notificationLogMIB != null) {
                this.notificationLogMIB.registerMOs(server, this.getContext(this.notificationLogMIB, context));
            }
            if (this.tlsTmMib != null) {
                this.tlsTmMib.registerMOs(server, this.getContext(this.tlsTmMib, context));
            }
        } else {
            logger.warn((Serializable)((Object)("registerMIBs: Could not find any MOServer for context '" + context + "\"")));
        }
    }

    protected void unregisterMIBs(OctetString context) {
        MOServer server = this.agent.getServer(context);
        if (server != null) {
            this.targetMIB.unregisterMOs(server, this.getContext(this.targetMIB, context));
            this.notificationMIB.unregisterMOs(server, this.getContext(this.notificationMIB, context));
            this.vacmMIB.unregisterMOs(server, this.getContext(this.vacmMIB, context));
            this.usmMIB.unregisterMOs(server, this.getContext(this.usmMIB, context));
            this.snmpv2MIB.unregisterMOs(server, this.getContext(this.snmpv2MIB, context));
            this.frameworkMIB.unregisterMOs(server, this.getContext(this.frameworkMIB, context));
            this.communityMIB.unregisterMOs(server, this.getContext(this.communityMIB, context));
            if (this.snmp4jLogMIB != null) {
                this.snmp4jLogMIB.unregisterMOs(server, this.getContext(this.snmp4jLogMIB, context));
            }
            if (this.snmp4jConfigMIB != null) {
                this.snmp4jConfigMIB.unregisterMOs(server, this.getContext(this.targetMIB, context));
            }
            if (this.proxyMIB != null) {
                this.proxyMIB.unregisterMOs(server, this.getContext(this.proxyMIB, context));
            }
            if (this.snmpUsmDhObjectsMib != null) {
                this.snmpUsmDhObjectsMib.unregisterMOs(server, this.getContext(this.snmpUsmDhObjectsMib, context));
            }
            if (this.notificationLogMIB != null) {
                this.notificationLogMIB.unregisterMOs(server, this.getContext(this.notificationLogMIB, context));
            }
            if (this.tlsTmMib != null) {
                this.tlsTmMib.unregisterMOs(server, this.getContext(this.tlsTmMib, context));
            }
        } else {
            logger.warn((Serializable)((Object)("unregisterMIBs: Could not find any MOServer for context '" + context + "\"")));
        }
    }

    public void setupProxyForwarder() {
        this.proxyForwarder = this.createProxyForwarder(this.agent);
    }

    public void setupSnmpUsmDhObjectsMib(Collection<DHKickstartParameters> dhKickstartParameters) {
        this.snmpUsmDhObjectsMib = new SnmpUsmDhObjectsMib(this.moFactory, this.usm, this.usmMIB, this.vacmMIB, dhKickstartParameters);
    }

    protected NotificationOriginator createNotificationOriginator() {
        return new NotificationOriginatorImpl(this.session, this.vacm(), this.snmpv2MIB.getSysUpTime(), this.targetMIB, this.notificationMIB);
    }

    protected ProxyForwarder createProxyForwarder(CommandProcessor agent) {
        this.proxyMIB = new SnmpProxyMIB();
        ProxyForwarderImpl pf = new ProxyForwarderImpl(this.session, this.proxyMIB, this.targetMIB);
        agent.addProxyForwarder(pf, null, 0);
        pf.addCounterListener(this.snmpv2MIB);
        return this.proxyForwarder;
    }

    protected CommandProcessor createCommandProcessor(OctetString engineID) {
        return new CommandProcessor(engineID);
    }

    protected Session createSnmpSession(MessageDispatcher dispatcher) {
        return new Snmp(dispatcher);
    }

    public void setPersistenceImportMode(int importMode) {
        this.persistenceImportMode = importMode;
    }

    public int getPersistenceImportMode() {
        return this.persistenceImportMode;
    }

    @Override
    public Variable getVariable(String name) {
        OID oid;
        OctetString context = null;
        int pos = name.indexOf(58);
        if (pos >= 0) {
            context = new OctetString(name.substring(0, pos));
            oid = new OID(name.substring(pos + 1, name.length()));
        } else {
            oid = new OID(name);
        }
        MOServer server = this.agent.getServer(context);
        final DefaultMOContextScope scope = new DefaultMOContextScope(context, oid, true, oid, true);
        MOQueryWithSource query = new MOQueryWithSource(scope, false, this);
        GenericManagedObject mo = server.lookup((MOQuery)query, GenericManagedObject.class);
        if (mo != null) {
            final VariableBinding vb = new VariableBinding(oid);
            final RequestStatus status = new RequestStatus();
            SubRequest<SnmpRequest.SnmpSubRequest> req = new SubRequest<SnmpRequest.SnmpSubRequest>(){
                private boolean completed;
                private MOQuery query;

                @Override
                public boolean hasError() {
                    return false;
                }

                @Override
                public void setErrorStatus(int errorStatus) {
                    status.setErrorStatus(errorStatus);
                }

                @Override
                public int getErrorStatus() {
                    return status.getErrorStatus();
                }

                @Override
                public RequestStatus getStatus() {
                    return status;
                }

                @Override
                public MOScope getScope() {
                    return scope;
                }

                @Override
                public VariableBinding getVariableBinding() {
                    return vb;
                }

                @Override
                public Request<?, ?, ?> getRequest() {
                    return null;
                }

                @Override
                public Object getUndoValue() {
                    return null;
                }

                @Override
                public void setUndoValue(Object undoInformation) {
                }

                @Override
                public void completed() {
                    this.completed = true;
                }

                @Override
                public boolean isComplete() {
                    return this.completed;
                }

                @Override
                public void setTargetMO(ManagedObject<? super SnmpRequest.SnmpSubRequest> managedObject) {
                }

                @Override
                public ManagedObject<? super SnmpRequest.SnmpSubRequest> getTargetMO() {
                    return null;
                }

                @Override
                public int getIndex() {
                    return 0;
                }

                @Override
                public void setQuery(MOQuery query) {
                    this.query = query;
                }

                @Override
                public MOQuery getQuery() {
                    return this.query;
                }

                @Override
                public SubRequestIterator<SnmpRequest.SnmpSubRequest> repetitions() {
                    return null;
                }

                @Override
                public void updateNextRepetition() {
                }

                @Override
                public Object getUserObject() {
                    return null;
                }

                @Override
                public void setUserObject(Object userObject) {
                }
            };
            mo.get(req);
            return vb.getVariable();
        }
        return null;
    }

    public static class ErrorDescriptor
    implements AgentState.ErrorDescriptor {
        private Exception exception;
        private int sourceState;
        private int targetState;
        private String description;

        ErrorDescriptor(String descr, int sourceState, int targetState, Exception ex) {
            this.description = descr;
            this.sourceState = sourceState;
            this.targetState = targetState;
            this.exception = ex;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public int getSourceState() {
            return this.sourceState;
        }

        @Override
        public int getTargetState() {
            return this.targetState;
        }

        @Override
        public Exception getException() {
            return this.exception;
        }
    }

    public class AgentState
    implements org.snmp4j.agent.AgentState {
        private int state = 0;
        private List<AgentState.ErrorDescriptor> errorsOccurred = new LinkedList<AgentState.ErrorDescriptor>();

        @Override
        public int getState() {
            return this.state;
        }

        @Override
        public void setState(int newState) {
            boolean stateChanged = this.state != newState;
            this.state = newState;
            logger.info((CharSequence)("Agent state set to " + newState + " (" + (stateChanged ? "" : "un") + "changed)"));
            AgentConfigManager.this.fireAgentStateChange();
        }

        @Override
        public void advanceState(int newState) {
            if (this.state < newState) {
                this.state = newState;
                logger.info((CharSequence)("Agent state advanced to " + newState));
                AgentConfigManager.this.fireAgentStateChange();
            }
        }

        @Override
        public void addError(AgentState.ErrorDescriptor error) {
            this.errorsOccurred.add(error);
        }

        @Override
        public List<AgentState.ErrorDescriptor> getErrors() {
            return new ArrayList<AgentState.ErrorDescriptor>(this.errorsOccurred);
        }
    }
}

