/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo.snmp;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOGroup;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.NotificationOriginator;
import org.snmp4j.agent.mo.DefaultMOMutableTableModel;
import org.snmp4j.agent.mo.DefaultMOTable;
import org.snmp4j.agent.mo.DefaultMOTableRow;
import org.snmp4j.agent.mo.MOAccessImpl;
import org.snmp4j.agent.mo.MOColumn;
import org.snmp4j.agent.mo.MOScalar;
import org.snmp4j.agent.mo.MOTableIndex;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.MOTableRowFactory;
import org.snmp4j.agent.mo.MOTableSubIndex;
import org.snmp4j.agent.mo.snmp.AgentCapabilityList;
import org.snmp4j.agent.mo.snmp.DisplayString;
import org.snmp4j.agent.mo.snmp.DisplayStringScalar;
import org.snmp4j.agent.mo.snmp.EnumeratedScalar;
import org.snmp4j.agent.mo.snmp.SysUpTime;
import org.snmp4j.agent.mo.snmp.TestAndIncr;
import org.snmp4j.agent.mo.snmp.TimeStampScalar;
import org.snmp4j.event.CounterEvent;
import org.snmp4j.event.CounterListener;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.smi.Counter32;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public class SNMPv2MIB
implements MOGroup,
CounterListener,
AgentCapabilityList {
    private static final LogAdapter LOGGER = LogFactory.getLogger(SNMPv2MIB.class);
    private static final OID snmpStatsPrefix = new OID(new int[]{1, 3, 6, 1, 2, 1, 11});
    private static final OID usmStatsPrefix = new OID(new int[]{1, 3, 6, 1, 6, 3, 15, 1, 1});
    private static final OID oidSnmpInPkts = SnmpConstants.snmpInPkts;
    private static final OID oidSnmpInBadVersions = SnmpConstants.snmpInBadVersions;
    private static final OID oidSnmpInBadCommunityNames = SnmpConstants.snmpInBadCommunityNames;
    private static final OID oidSnmpInBadCommunityUses = SnmpConstants.snmpInBadCommunityUses;
    private static final OID oidSnmpInASNParseErrs = SnmpConstants.snmpInASNParseErrs;
    private static final OID oidSnmpSilentDrops = SnmpConstants.snmpSilentDrops;
    private static final OID oidSnmpProxyDrops = SnmpConstants.snmpProxyDrops;
    private static final OID oidSysORLastChange = new OID(new int[]{1, 3, 6, 1, 2, 1, 1, 8, 0});
    private static final OID oidSnmpEnableAuthenTraps = new OID(new int[]{1, 3, 6, 1, 2, 1, 11, 30, 0});
    private static final OID oidSnmpSetSerialNo = new OID(new int[]{1, 3, 6, 1, 6, 3, 1, 1, 6, 1, 0});
    private MOScalar<OctetString> descr;
    private SysUpTimeImpl upTime;
    private MOScalar<OID> objectID;
    private MOScalar<OctetString> contact;
    private MOScalar<OctetString> name;
    private MOScalar<OctetString> location;
    private MOScalar<Integer32> services;
    private MOScalar<Integer32> snmpEnableAuthenTraps;
    private TestAndIncr snmpSetSerialNo;
    private MOScalar<TimeTicks> sysORLastChange;
    private static final OID[] snmpStatsOIDs = new OID[]{oidSnmpInPkts, oidSnmpInBadVersions, oidSnmpInBadCommunityNames, oidSnmpInBadCommunityUses, oidSnmpInASNParseErrs, oidSnmpSilentDrops, oidSnmpProxyDrops};
    private MOScalar<?>[] snmpStats;
    private static final OID oidSysOREntry = new OID(new int[]{1, 3, 6, 1, 2, 1, 1, 9, 1});
    private static final int colSysORID = 2;
    private static final int colSysORDescr = 3;
    private static final int colSysORUpTime = 4;
    private static final int idxSysORID = 0;
    private static final int idxSysORDescr = 1;
    private static final int idxSysORUpTime = 2;
    private static MOTableSubIndex[] sysOREntryIndexes = new MOTableSubIndex[]{new MOTableSubIndex(2, 1, 1)};
    private static MOTableIndex sysOREntryIndex = new MOTableIndex(sysOREntryIndexes, false);
    private DefaultMOTable<DefaultMOTableRow, MOColumn, DefaultMOMutableTableModel<DefaultMOTableRow>> sysOREntry;
    private DefaultMOMutableTableModel<DefaultMOTableRow> sysOREntryModel;
    private NotificationOriginator notificationOriginator;
    private static Map<OctetString, SysUpTimeImpl> sysUpTimes = Collections.synchronizedMap(new HashMap());

    public SNMPv2MIB(OctetString sysDescr, OID sysOID, Integer32 sysServices) {
        this(sysDescr, sysOID, sysServices, null);
    }

    protected SNMPv2MIB(OctetString sysDescr, OID sysOID, Integer32 sysServices, final SysUpTime sysUpTime) {
        this.descr = new MOScalar<OctetString>(new OID(SnmpConstants.sysDescr), MOAccessImpl.ACCESS_READ_ONLY, sysDescr);
        this.descr.setVolatile(true);
        this.upTime = sysUpTime == null ? new SysUpTimeImpl() : new SysUpTimeImpl(){

            @Override
            public TimeTicks getValue() {
                return sysUpTime.get();
            }
        };
        this.upTime.setVolatile(true);
        this.objectID = new MOScalar<OID>(new OID(SnmpConstants.sysObjectID), MOAccessImpl.ACCESS_READ_ONLY, sysOID);
        this.objectID.setVolatile(true);
        this.contact = new DisplayStringScalar<OctetString>(new OID(SnmpConstants.sysContact), MOAccessImpl.ACCESS_READ_WRITE, new OctetString());
        this.name = new DisplayStringScalar<OctetString>(new OID(SnmpConstants.sysName), MOAccessImpl.ACCESS_READ_WRITE, new OctetString());
        this.location = new DisplayStringScalar<OctetString>(new OID(SnmpConstants.sysLocation), MOAccessImpl.ACCESS_READ_WRITE, new OctetString());
        this.services = new MOScalar<Integer32>(new OID(SnmpConstants.sysServices), MOAccessImpl.ACCESS_READ_ONLY, sysServices);
        this.services.setVolatile(true);
        this.snmpEnableAuthenTraps = new EnumeratedScalar<Integer32>(oidSnmpEnableAuthenTraps, MOAccessImpl.ACCESS_READ_WRITE, new Integer32(1), new int[]{1, 2});
        this.snmpSetSerialNo = new TestAndIncr(oidSnmpSetSerialNo);
        this.snmpSetSerialNo.setVolatile(true);
        this.sysORLastChange = new TimeStampScalar(oidSysORLastChange, MOAccessImpl.ACCESS_READ_ONLY, this.upTime);
        this.sysORLastChange.setVolatile(true);
        this.createSysOREntry();
        this.createSnmpStats();
    }

    private void createSnmpStats() {
        this.snmpStats = new MOScalar[snmpStatsOIDs.length];
        for (int i = 0; i < snmpStatsOIDs.length; ++i) {
            this.snmpStats[i] = new MOScalar<Counter32>(snmpStatsOIDs[i], MOAccessImpl.ACCESS_READ_ONLY, new Counter32(0L));
        }
    }

    private void createSysOREntry() {
        MOColumn[] sysOREntryColumns = new MOColumn[]{new MOColumn(2, 6, MOAccessImpl.ACCESS_READ_ONLY), new DisplayString<Object>(3, MOAccessImpl.ACCESS_READ_ONLY, null, true), new MOColumn(4, 67, MOAccessImpl.ACCESS_READ_ONLY)};
        this.sysOREntry = new SysOREntry(oidSysOREntry, sysOREntryIndex, sysOREntryColumns);
        this.sysOREntryModel = new DefaultMOMutableTableModel();
        this.sysOREntryModel.setRowFactory(new MOTableRowFactory<DefaultMOTableRow>(){

            @Override
            public DefaultMOTableRow createRow(OID index, Variable[] values) throws UnsupportedOperationException {
                return new DefaultMOTableRow(index, values);
            }

            @Override
            public void freeRow(DefaultMOTableRow row) {
            }
        });
        this.sysOREntry.setModel(this.sysOREntryModel);
        this.sysOREntry.setVolatile(true);
    }

    protected void updateSysORLastChange() {
        this.sysORLastChange.setValue(this.getUpTime());
    }

    @Override
    public OID addSysOREntry(OID sysORID, OctetString sysORDescr) {
        OID index = new OID(new int[]{this.sysOREntryModel.getRowCount() + 1});
        Variable[] values = new Variable[this.sysOREntry.getColumnCount()];
        int n = 0;
        values[n++] = sysORID;
        values[n++] = sysORDescr;
        values[n] = this.upTime.get();
        DefaultMOTableRow row = new DefaultMOTableRow(index, values);
        this.sysOREntry.addRow(row);
        this.updateSysORLastChange();
        return index;
    }

    @Override
    public MOTableRow removeSysOREntry(OID index) {
        this.updateSysORLastChange();
        return this.sysOREntry.removeRow(index);
    }

    @Override
    public void registerMOs(MOServer server, OctetString context) throws DuplicateRegistrationException {
        server.register(this.descr, context);
        server.register(this.upTime, context);
        sysUpTimes.put(context, this.upTime);
        server.register(this.objectID, context);
        server.register(this.contact, context);
        server.register(this.name, context);
        server.register(this.location, context);
        server.register(this.services, context);
        server.register(this.snmpEnableAuthenTraps, context);
        server.register(this.snmpSetSerialNo, context);
        server.register(this.sysORLastChange, context);
        for (MOScalar<?> snmpStat : this.snmpStats) {
            server.register(snmpStat, context);
        }
        server.register(this.sysOREntry, context);
    }

    @Override
    public void unregisterMOs(MOServer server, OctetString context) {
        server.unregister(this.descr, context);
        server.unregister(this.upTime, context);
        sysUpTimes.remove(context);
        server.unregister(this.objectID, context);
        server.unregister(this.contact, context);
        server.unregister(this.name, context);
        server.unregister(this.location, context);
        server.unregister(this.services, context);
        server.unregister(this.snmpEnableAuthenTraps, context);
        server.unregister(this.snmpSetSerialNo, context);
        server.unregister(this.sysORLastChange, context);
        for (MOScalar<?> snmpStat : this.snmpStats) {
            server.unregister(snmpStat, context);
        }
        server.unregister(this.sysOREntry, context);
    }

    public OctetString getContact() {
        return this.contact.getValue();
    }

    public void setContact(OctetString contact) {
        this.contact.setValue(contact);
    }

    public OctetString getDescr() {
        return this.descr.getValue();
    }

    public OctetString getLocation() {
        return this.location.getValue();
    }

    public void setLocation(OctetString sysLocation) {
        this.location.setValue(sysLocation);
    }

    public OctetString getName() {
        return this.name.getValue();
    }

    public void setName(OctetString sysName) {
        this.name.setValue(sysName);
    }

    public OID getObjectID() {
        return this.objectID.getValue();
    }

    public Integer32 getServices() {
        return this.services.getValue();
    }

    public TimeTicks getUpTime() {
        return this.upTime.getValue();
    }

    public SysUpTime getSysUpTime() {
        return this.upTime;
    }

    public void incrementCounter(CounterEvent event) {
        OID eventOID;
        if (event.getOid().startsWith(snmpStatsPrefix) && event.getOid().size() > snmpStatsPrefix.size()) {
            int suffix = event.getOid().get(snmpStatsPrefix.size());
            for (int i = 0; i < snmpStatsOIDs.length; ++i) {
                if (suffix != snmpStatsOIDs[i].get(snmpStatsPrefix.size())) continue;
                Counter32 current = (Counter32)this.snmpStats[i].getValue();
                current.increment();
                event.setCurrentValue((Variable)((Counter32)current.clone()));
            }
        }
        if (((eventOID = event.getOid()).equals((Object)SnmpConstants.snmpInBadCommunityNames) || eventOID.startsWith(usmStatsPrefix) && !SnmpConstants.usmStatsNotInTimeWindows.equals((Object)eventOID) && !SnmpConstants.usmStatsUnknownEngineIDs.equals((Object)eventOID)) && this.snmpEnableAuthenTraps.getValue().getValue() == 1) {
            if (this.notificationOriginator == null) {
                LOGGER.debug((Serializable)((Object)"Authentication failure trap not sent because NotificationOriginator not set in SNMPv2MIB"));
            } else {
                this.notificationOriginator.notify(new OctetString(), SnmpConstants.authenticationFailure, new VariableBinding[0]);
            }
        }
    }

    public static SysUpTime getSysUpTime(OctetString context) {
        return sysUpTimes.get(context);
    }

    public void setNotificationOriginator(NotificationOriginator notificationOriginator) {
        this.notificationOriginator = notificationOriginator;
    }

    public NotificationOriginator getNotificationOriginator() {
        return this.notificationOriginator;
    }

    public MOScalar<Integer32> getSnmpEnableAuthenTraps() {
        return this.snmpEnableAuthenTraps;
    }

    public class SysOREntry
    extends DefaultMOTable<DefaultMOTableRow, MOColumn, DefaultMOMutableTableModel<DefaultMOTableRow>>
    implements AgentCapabilityList {
        public SysOREntry(OID oid, MOTableIndex index, MOColumn<?>[] columns) {
            super(oid, index, (MOColumn[])columns);
        }

        @Override
        public OID addSysOREntry(OID sysORID, OctetString sysORDescr) {
            return SNMPv2MIB.this.addSysOREntry(sysORID, sysORDescr);
        }

        @Override
        public MOTableRow removeSysOREntry(OID index) {
            return SNMPv2MIB.this.removeSysOREntry(index);
        }
    }

    public static class SysUpTimeImpl
    extends MOScalar<TimeTicks>
    implements SysUpTime,
    Serializable {
        private static final long serialVersionUID = 1L;
        private long startTime = System.nanoTime();

        public SysUpTimeImpl() {
            super(new OID(SnmpConstants.sysUpTime), MOAccessImpl.ACCESS_READ_ONLY, new TimeTicks(0L));
        }

        @Override
        public TimeTicks getValue() {
            long ticks = (System.nanoTime() - this.startTime) / 10000000L;
            return new TimeTicks(ticks & 0xFFFFFFFFL);
        }

        @Override
        public TimeTicks get() {
            return this.getValue();
        }
    }

    public static final class SnmpEnableAuthenTrapsEnum {
        public static final int enabled = 1;
        public static final int disabled = 2;
    }
}

