/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo.ext;

import java.util.HashMap;
import java.util.Map;
import org.snmp4j.agent.MOAccess;
import org.snmp4j.agent.mo.DefaultMOFactory;
import org.snmp4j.agent.mo.MOAccessImpl;
import org.snmp4j.agent.mo.MOFactory;

public class SimMOFactory
extends DefaultMOFactory {
    private Map<Number, MOAccess> accessModes = new HashMap<Number, MOAccess>();
    private static boolean simulationModeEnabled;
    private static SimMOFactory instance;

    protected SimMOFactory() {
    }

    public static synchronized MOFactory getInstance() {
        if (instance == null) {
            instance = new SimMOFactory();
        }
        return instance;
    }

    public static void setSimulationModeEnabled(boolean simulationMode) {
        simulationModeEnabled = simulationMode;
    }

    public static boolean isSimulationModeEnabled() {
        return simulationModeEnabled;
    }

    @Override
    public synchronized MOAccess createAccess(int moAccess) {
        MOAccess accessObj = this.accessModes.get(moAccess);
        if (accessObj == null) {
            accessObj = new SimMOAccess(moAccess);
            this.accessModes.put(moAccess, accessObj);
        }
        return accessObj;
    }

    public class SimMOAccess
    extends MOAccessImpl {
        public SimMOAccess(int moAccess) {
            super(moAccess);
        }

        @Override
        public boolean isAccessibleForCreate() {
            if (SimMOFactory.isSimulationModeEnabled()) {
                return true;
            }
            return super.isAccessibleForCreate();
        }

        @Override
        public boolean isAccessibleForWrite() {
            if (SimMOFactory.isSimulationModeEnabled()) {
                return true;
            }
            return super.isAccessibleForWrite();
        }
    }
}

