/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.request;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.snmp4j.agent.request.Request;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.smi.OID;

public abstract class AbstractRequest<U extends SubRequest<U>, S, R>
implements Request<S, R, U> {
    protected List<U> subrequests;
    protected S source;
    protected R response;
    protected int phase = -1;
    protected int errorStatus = 0;
    protected int repeaterStartIndex;
    protected int repeaterRowSize;
    protected int reprocessCounter = 0;
    protected int transactionID;

    public AbstractRequest(S source) {
        this.source = source;
    }

    @Override
    public S getSource() {
        return this.source;
    }

    @Override
    public R getResponse() {
        return this.response;
    }

    public abstract boolean isBulkRequest();

    @Override
    public U find(OID prefix) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            SubRequest sreq = (SubRequest)it.next();
            if (!sreq.getVariableBinding().getOid().startsWith(prefix)) continue;
            return (U)sreq;
        }
        return null;
    }

    protected synchronized void initSubRequests() {
        if (this.subrequests == null) {
            this.setupSubRequests();
        }
    }

    protected abstract void setupSubRequests();

    protected abstract int getMaxPhase();

    @Override
    public int nextPhase() {
        if (this.phase >= this.getMaxPhase()) {
            throw new NoSuchElementException("Requested phase does not exists");
        }
        this.resetCompletionStatus();
        switch (this.phase) {
            case 1: {
                if (this.getErrorStatus() != 0) {
                    this.phase = 4;
                    break;
                }
                this.phase = 2;
                break;
            }
            case 2: {
                if (this.getErrorStatus() != 0) {
                    this.phase = 3;
                    break;
                }
                this.phase = 4;
                break;
            }
            case 3: {
                this.phase = 4;
                break;
            }
            default: {
                this.phase = 1;
            }
        }
        return this.phase;
    }

    @Override
    public boolean isComplete() {
        return this.getErrorStatus() != 0 || this.getPhase() >= this.getMaxPhase() && this.isPhaseComplete();
    }

    @Override
    public U get(int index) {
        return (U)((SubRequest)this.subrequests.get(index));
    }

    @Override
    public int getPhase() {
        return this.phase;
    }

    @Override
    public int getErrorIndex() {
        if (this.errorStatus == 0) {
            return 0;
        }
        this.initSubRequests();
        int index = 1;
        for (SubRequest sreq : this.subrequests) {
            if (sreq.getStatus().getErrorStatus() != 0) {
                return index;
            }
            ++index;
        }
        return 0;
    }

    @Override
    public int getErrorStatus() {
        this.initSubRequests();
        if (this.errorStatus == 0) {
            for (SubRequest sreq : this.subrequests) {
                if (sreq.getStatus().getErrorStatus() == 0) continue;
                return sreq.getStatus().getErrorStatus();
            }
        }
        return this.errorStatus;
    }

    @Override
    public int getTransactionID() {
        return this.transactionID;
    }

    @Override
    public void setPhase(int phase) throws NoSuchElementException {
        if (phase < 0 || phase > this.getMaxPhase()) {
            throw new NoSuchElementException("Illegal phase identifier: " + phase);
        }
        if (this.phase != phase) {
            this.resetCompletionStatus();
        }
        this.phase = phase;
    }

    protected void resetCompletionStatus() {
        this.initSubRequests();
        for (SubRequest subReq : this.subrequests) {
            subReq.getStatus().setPhaseComplete(false);
            subReq.getStatus().setProcessed(false);
        }
    }

    @Override
    public synchronized void resetProcessedStatus() {
        for (SubRequest sreq : this.subrequests) {
            sreq.getStatus().setProcessed(sreq.getStatus().isPhaseComplete());
        }
    }

    @Override
    public void setErrorStatus(int errorStatus) {
        this.errorStatus = errorStatus;
    }

    public boolean equals(Object obj) {
        return obj instanceof Request && this.transactionID == ((Request)obj).getTransactionID();
    }

    public int hashCode() {
        return this.transactionID;
    }

    @Override
    public int getReprocessCounter() {
        return this.reprocessCounter;
    }

    @Override
    public void incReprocessCounter() {
        ++this.reprocessCounter;
    }

    public String toString() {
        return this.getClass().getName() + "[phase=" + this.phase + ",errorStatus=" + this.errorStatus + ",source=" + this.source + ",response=" + this.response + ",transactionID=" + this.transactionID + ",repeaterStartIndex=" + this.repeaterStartIndex + ",repeaterRowSize=" + this.repeaterRowSize + ",reprocessCounter=" + this.reprocessCounter + ",subrequests=" + this.subrequests + "]";
    }
}

