/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo;

import org.snmp4j.agent.ManagedObject;
import org.snmp4j.agent.mo.DeniableEventObject;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.Variable;

public class MOChangeEvent
extends DeniableEventObject {
    private static final long serialVersionUID = 2377168127200875177L;
    private ManagedObject changedObject;
    private OID oid;
    private Variable oldValue;
    private Variable newValue;
    private Modification modification;
    private OidType oidType;

    public MOChangeEvent(Object source, ManagedObject changedObject, OID oid, Variable oldValue, Variable newValue) {
        this(source, changedObject, oid, oldValue, newValue, true);
        this.modification = this.getModificationFromValues(oldValue, newValue);
        this.oidType = OidType.fullyQualified;
    }

    protected Modification getModificationFromValues(Variable oldValue, Variable newValue) {
        if (oldValue == null && newValue != null) {
            return Modification.added;
        }
        if (oldValue != null && newValue == null) {
            return Modification.removed;
        }
        return Modification.updated;
    }

    public MOChangeEvent(Object source, ManagedObject changedObject, OID index, Modification modification) {
        super(source, false);
        this.changedObject = changedObject;
        this.oid = index;
        this.modification = modification;
        this.oidType = OidType.index;
    }

    public MOChangeEvent(Object source, ManagedObject changedObject, OID oid, Variable oldValue, Variable newValue, boolean deniable) {
        super(source, deniable);
        this.changedObject = changedObject;
        this.oid = oid;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    public ManagedObject getChangedObject() {
        return this.changedObject;
    }

    public OID getOID() {
        return this.oid;
    }

    public Variable getOldValue() {
        return this.oldValue;
    }

    public Variable getNewValue() {
        return this.newValue;
    }

    public Modification getModification() {
        return this.modification;
    }

    public OidType getOidType() {
        return this.oidType;
    }

    @Override
    public String toString() {
        return "MOChangeEvent{changedObject=" + this.changedObject + ", oid=" + this.oid + ", oldValue=" + this.oldValue + ", newValue=" + this.newValue + ", modification=" + this.modification + ", oidType=" + this.oidType + "}";
    }

    public static enum OidType {
        fullyQualified,
        instanceSuffix,
        index;

    }

    public static enum Modification {
        created,
        added,
        updated,
        removed;

    }
}

