/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.snmp4j.agent.MOAccess;
import org.snmp4j.agent.mo.DefaultMOMutableRow2PC;
import org.snmp4j.agent.mo.DefaultMOMutableTableModel;
import org.snmp4j.agent.mo.DefaultMOTable;
import org.snmp4j.agent.mo.LinkedMOFactory;
import org.snmp4j.agent.mo.MOAccessImpl;
import org.snmp4j.agent.mo.MOColumn;
import org.snmp4j.agent.mo.MOFactory;
import org.snmp4j.agent.mo.MOMutableColumn;
import org.snmp4j.agent.mo.MOScalar;
import org.snmp4j.agent.mo.MOTable;
import org.snmp4j.agent.mo.MOTableIndex;
import org.snmp4j.agent.mo.MOTableIndexValidator;
import org.snmp4j.agent.mo.MOTableModel;
import org.snmp4j.agent.mo.MOTableRelation;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.MOTableSubIndex;
import org.snmp4j.agent.mo.snmp.SNMPv2TC;
import org.snmp4j.agent.mo.snmp.tc.TextualConvention;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.Variable;

public class DefaultMOFactory
implements MOFactory,
LinkedMOFactory {
    private Map textualConventions = new HashMap();
    private Map links;
    private static MOFactory instance;

    protected DefaultMOFactory() {
    }

    public static MOFactory getInstance() {
        if (instance == null) {
            instance = new DefaultMOFactory();
            DefaultMOFactory.addSNMPv2TCs(instance);
        }
        return instance;
    }

    public static void setInstance(MOFactory factory) {
        instance = factory;
    }

    public static void addSNMPv2TCs(MOFactory factory) {
        Collection tcs = new SNMPv2TC().getTextualConventions();
        Iterator it = tcs.iterator();
        while (it.hasNext()) {
            TextualConvention tc = (TextualConvention)it.next();
            factory.addTextualConvention(tc);
        }
    }

    protected Map getTextualConventions() {
        return this.textualConventions;
    }

    public synchronized void addTextualConvention(TextualConvention tc) {
        HashMap<String, TextualConvention> tcMap = (HashMap<String, TextualConvention>)this.textualConventions.get(tc.getModuleName());
        if (tcMap == null) {
            tcMap = new HashMap<String, TextualConvention>(10);
            this.textualConventions.put(tc.getModuleName(), tcMap);
        }
        tcMap.put(tc.getName(), tc);
    }

    public synchronized void removeTextualConvention(TextualConvention tc) {
        Map tcMap = (Map)this.textualConventions.get(tc.getModuleName());
        if (tcMap != null) {
            tcMap.remove(tc.getName());
            if (tcMap.isEmpty()) {
                this.textualConventions.remove(tc.getModuleName());
            }
        }
    }

    public synchronized TextualConvention getTextualConvention(String moduleName, String name) {
        Map tcMap = (Map)this.textualConventions.get(moduleName);
        if (tcMap != null) {
            return (TextualConvention)tcMap.get(name);
        }
        return null;
    }

    public MOColumn createColumn(int columnID, int syntax, MOAccess access) {
        return new MOMutableColumn(columnID, syntax, access);
    }

    public MOColumn createColumn(int columnID, int syntax, MOAccess access, Variable defaultValue, boolean mutableInService) {
        return new MOMutableColumn(columnID, syntax, access, defaultValue, mutableInService);
    }

    public MOTableRelation createTableRelation(MOTable baseTable, MOTable dependentTable) {
        return new MOTableRelation(baseTable, dependentTable);
    }

    public MOTableRow createRow(OID index, Variable[] values) throws UnsupportedOperationException {
        return new DefaultMOMutableRow2PC(index, values);
    }

    public MOScalar createScalar(OID id, MOAccess access, Variable value) {
        return new MOScalar(id, access, value);
    }

    public MOTable createTable(OID oid, MOTableIndex indexDef, MOColumn[] columns) {
        return this.createTable(oid, indexDef, columns, this.createTableModel(oid, indexDef, columns));
    }

    public MOTable createTable(OID oid, MOTableIndex indexDef, MOColumn[] columns, MOTableModel model) {
        return new DefaultMOTable(oid, indexDef, columns, model);
    }

    public MOTableModel createTableModel(OID tableOID, MOTableIndex indexDef, MOColumn[] columns) {
        return new DefaultMOMutableTableModel();
    }

    public void freeRow(MOTableRow row) {
    }

    public MOTableIndex createIndex(MOTableSubIndex[] subIndexes, boolean impliedLength) {
        return new MOTableIndex(subIndexes, impliedLength);
    }

    public MOTableSubIndex createSubIndex(int smiSyntax) {
        return new MOTableSubIndex(smiSyntax);
    }

    public MOTableSubIndex createSubIndex(OID oid, int smiSyntax) {
        return new MOTableSubIndex(oid, smiSyntax);
    }

    public MOTableSubIndex createSubIndex(int smiSyntax, int minLength, int maxLength) {
        return new MOTableSubIndex(smiSyntax, minLength, maxLength);
    }

    public MOTableSubIndex createSubIndex(OID oid, int smiSyntax, int minLength, int maxLength) {
        return new MOTableSubIndex(oid, smiSyntax, minLength, maxLength);
    }

    public MOTableIndex createIndex(MOTableSubIndex[] subIndexes, boolean impliedLength, MOTableIndexValidator validator) {
        return new MOTableIndex(subIndexes, impliedLength, validator);
    }

    public MOColumn createColumn(int columnID, int syntax, MOAccess access, String tcModuleName, String textualConvention) {
        TextualConvention tc = this.getTextualConvention(tcModuleName, textualConvention);
        if (tc != null) {
            return tc.createColumn(columnID, syntax, access, null, true);
        }
        return this.createColumn(columnID, syntax, access);
    }

    public MOColumn createColumn(int columnID, int syntax, MOAccess access, Variable defaultValue, boolean mutableInService, String tcModuleName, String textualConvention) {
        TextualConvention tc = this.getTextualConvention(tcModuleName, textualConvention);
        if (tc != null) {
            return tc.createColumn(columnID, syntax, access, defaultValue, mutableInService);
        }
        return this.createColumn(columnID, syntax, access, defaultValue, mutableInService);
    }

    public MOScalar createScalar(OID id, MOAccess access, Variable value, String tcModuleName, String textualConvention) {
        TextualConvention tc = this.getTextualConvention(tcModuleName, textualConvention);
        if (tc != null) {
            return tc.createScalar(id, access, value);
        }
        return this.createScalar(id, access, value);
    }

    public MOAccess createAccess(int moAccess) {
        return MOAccessImpl.getInstance(moAccess);
    }

    public void setLink(OID oid, Object instrumentationHelperObject) {
        if (this.links == null) {
            this.initLinkMap();
        }
        this.links.put(oid, instrumentationHelperObject);
    }

    public Object getLink(OID oid) {
        if (this.links != null) {
            OID searchOID = new OID(oid);
            Object result = null;
            while (searchOID.size() > 0) {
                Object v = this.links.get(searchOID);
                result = v;
                if (v != null) break;
                searchOID.trim(1);
            }
            return result;
        }
        return null;
    }

    protected synchronized void initLinkMap() {
        if (this.links == null) {
            this.links = new HashMap();
        }
    }
}

