/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksException;
import org.smooks.api.TypedKey;
import org.smooks.io.AbstractOutputStreamResource;

public class ResourceWriter
extends Writer {
    private final String resourceName;
    private final Writer delegateWriter;

    public ResourceWriter(ExecutionContext executionContext, String resourceName) {
        this.resourceName = resourceName;
        this.delegateWriter = this.getOutputWriter(resourceName, executionContext);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.delegateWriter == null) {
            throw new SmooksException(String.format("Output resource [%s] not bound to context. Hint: configure an [%s] implementation or re-order resources", this.resourceName, AbstractOutputStreamResource.class.getName()));
        }
        this.delegateWriter.write(cbuf, off, len);
    }

    @Override
    public void flush() throws IOException {
        if (this.delegateWriter != null) {
            this.delegateWriter.flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.delegateWriter != null) {
            this.delegateWriter.close();
        }
    }

    protected Writer getOutputWriter(String resourceName, ExecutionContext executionContext) throws SmooksException {
        TypedKey resourceKey = TypedKey.of((String)(AbstractOutputStreamResource.OUTPUTSTREAM_CONTEXT_KEY_PREFIX + resourceName));
        Object outputResource = executionContext.get(resourceKey);
        if (outputResource == null) {
            AbstractOutputStreamResource resource = (AbstractOutputStreamResource)executionContext.get(TypedKey.of((String)(AbstractOutputStreamResource.RESOURCE_CONTEXT_KEY_PREFIX + resourceName)));
            OutputStream outputStream = this.openOutputStream(resource, executionContext);
            if (outputStream != null) {
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, resource.getWriterEncoding());
                executionContext.put(resourceKey, (Object)outputStreamWriter);
                return outputStreamWriter;
            }
            return null;
        }
        if (outputResource instanceof Writer) {
            return (Writer)outputResource;
        }
        if (outputResource instanceof OutputStream) {
            throw new SmooksException(String.format("An output stream to the [%s] resource is already open. Cannot open a Writer to this resource now", resourceName));
        }
        throw new SmooksException(String.format("Invalid execution context state. Value stored under context key [%s] must be [java.io.OutputStream] or [java.io.Writer] and not [%s]", resourceKey, outputResource.getClass().getName()));
    }

    protected OutputStream openOutputStream(AbstractOutputStreamResource resource, ExecutionContext executionContext) {
        if (resource != null) {
            try {
                return resource.getOutputStream(executionContext);
            }
            catch (IOException e) {
                throw new SmooksException(String.format("Unable to set output stream for [%s]", resource.getResourceName()), (Throwable)e);
            }
        }
        return null;
    }

    public Writer getDelegateWriter() {
        return this.delegateWriter;
    }
}

