/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.xml;

import jakarta.annotation.PostConstruct;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import javax.inject.Inject;
import org.jaxen.saxpath.SAXPathException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.api.ApplicationContext;
import org.smooks.api.TypedKey;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.config.ResourceConfigSeq;
import org.smooks.engine.lookup.NamespaceManagerLookup;
import org.smooks.engine.lookup.ResourceConfigSeqsLookup;
import org.smooks.namespace.NamespaceDeclarationStack;

public class NamespaceManager {
    public static final TypedKey<NamespaceDeclarationStack> NAMESPACE_DECLARATION_STACK_TYPED_KEY = TypedKey.of();
    private static final Logger LOGGER = LoggerFactory.getLogger(NamespaceManager.class);
    @Inject
    private ResourceConfig resourceConfig;
    @Inject
    private ApplicationContext applicationContext;

    @PostConstruct
    public void postConstruct() throws SAXPathException {
        Properties newNamespaces = this.resourceConfig.toProperties();
        for (ResourceConfigSeq resourceConfigSeq : (List)this.applicationContext.getRegistry().lookup((Function)new ResourceConfigSeqsLookup())) {
            for (int i = 0; i < resourceConfigSeq.size(); ++i) {
                resourceConfigSeq.get(i).getSelectorPath().setNamespaces(newNamespaces);
            }
        }
        LOGGER.debug("Adding namespace prefix-to-uri mappings: {}", (Object)newNamespaces);
        Optional currentNamespaces = (Optional)this.applicationContext.getRegistry().lookup((Function)new NamespaceManagerLookup());
        if (currentNamespaces.isPresent()) {
            ((Properties)currentNamespaces.get()).putAll((Map<?, ?>)newNamespaces);
        } else {
            this.applicationContext.getRegistry().registerObject(NamespaceManager.class, (Object)newNamespaces);
        }
    }
}

