/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.resource.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.smooks.api.resource.config.ReaderConfigurator;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.engine.resource.config.DefaultResourceConfig;
import org.xml.sax.XMLReader;

public class GenericReaderConfigurator
implements ReaderConfigurator {
    private Class<?> readerClass;
    private Properties parameters = new Properties();
    private final List<String> featuresOn = new ArrayList<String>();
    private final List<String> featuresOff = new ArrayList<String>();
    private String targetProfile;

    public GenericReaderConfigurator() {
    }

    public GenericReaderConfigurator(Class<? extends XMLReader> readerClass) {
        this.readerClass = readerClass;
    }

    public Properties getParameters() {
        return this.parameters;
    }

    public GenericReaderConfigurator setParameters(Properties parameters) {
        this.parameters = parameters;
        return this;
    }

    public GenericReaderConfigurator setFeature(String feature, boolean on) {
        if (on) {
            this.featuresOn.add(feature);
        } else {
            this.featuresOff.add(feature);
        }
        return this;
    }

    public GenericReaderConfigurator setTargetProfile(String targetProfile) {
        this.targetProfile = targetProfile;
        return this;
    }

    public List<ResourceConfig> toConfig() {
        DefaultResourceConfig resourceConfig = new DefaultResourceConfig();
        resourceConfig.setSelector("org.xml.sax.driver", new Properties());
        if (this.readerClass != null) {
            resourceConfig.setResource(this.readerClass.getName());
        }
        if (this.targetProfile != null) {
            resourceConfig.setProfile(this.targetProfile);
        }
        Set<Map.Entry<Object, Object>> entries = this.parameters.entrySet();
        for (Map.Entry<Object, Object> entry : entries) {
            resourceConfig.setParameter((String)entry.getKey(), (String)entry.getValue());
        }
        for (String featureOn : this.featuresOn) {
            resourceConfig.setParameter("feature-on", featureOn);
        }
        for (String featureOff : this.featuresOff) {
            resourceConfig.setParameter("feature-off", featureOff);
        }
        ArrayList<ResourceConfig> resourceConfigs = new ArrayList<ResourceConfig>();
        resourceConfigs.add(resourceConfig);
        return resourceConfigs;
    }
}

