/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.report;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.smooks.api.ApplicationContext;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksException;
import org.smooks.api.delivery.ContentDeliveryConfig;
import org.smooks.api.delivery.ContentHandlerBinding;
import org.smooks.api.delivery.event.ContentDeliveryConfigExecutionEvent;
import org.smooks.api.delivery.event.ExecutionEvent;
import org.smooks.api.delivery.event.ResourceAwareEvent;
import org.smooks.api.io.Sink;
import org.smooks.api.lifecycle.DOMFilterLifecycle;
import org.smooks.api.lifecycle.FilterLifecycle;
import org.smooks.assertion.AssertArgument;
import org.smooks.engine.delivery.dom.DOMContentDeliveryConfig;
import org.smooks.engine.delivery.event.BasicExecutionEventListener;
import org.smooks.engine.delivery.event.FragmentExecutionEvent;
import org.smooks.engine.delivery.event.StartFragmentExecutionEvent;
import org.smooks.engine.delivery.event.VisitExecutionEvent;
import org.smooks.engine.delivery.event.VisitSequence;
import org.smooks.engine.report.ReportConfiguration;
import org.smooks.engine.report.model.DOMReport;
import org.smooks.engine.report.model.MessageNode;
import org.smooks.engine.report.model.Report;
import org.smooks.engine.report.model.ReportInfoNode;
import org.smooks.engine.report.model.ResultNode;
import org.smooks.io.sink.JavaSink;
import org.smooks.io.sink.StringSink;
import org.smooks.support.DomUtils;
import org.w3c.dom.Element;

public abstract class AbstractReportGenerator
extends BasicExecutionEventListener
implements FilterLifecycle,
DOMFilterLifecycle {
    private final ReportConfiguration reportConfiguration;
    private Report report;
    private int messageNodeCounter;
    private int reportInfoNodeCounter;
    private final List<ExecutionEvent> preProcessingEvents = new ArrayList<ExecutionEvent>();
    private final List<ExecutionEvent> processingEvents = new ArrayList<ExecutionEvent>();
    private final Stack<ReportNode> reportNodeStack = new Stack();
    private final List<ReportNode> allNodes = new ArrayList<ReportNode>();

    protected AbstractReportGenerator(ReportConfiguration reportConfiguration, ApplicationContext applicationContext) {
        AssertArgument.isNotNull((Object)reportConfiguration, (String)"reportConfiguration");
        AssertArgument.isNotNull((Object)applicationContext, (String)"applicationContext");
        applicationContext.getRegistry().registerObject((Object)this);
        this.reportConfiguration = reportConfiguration;
        this.setFilterEvents(reportConfiguration.getFilterEvents());
    }

    public ReportConfiguration getReportConfiguration() {
        return this.reportConfiguration;
    }

    public Writer getOutputWriter() {
        return this.reportConfiguration.getOutputWriter();
    }

    @Override
    public void onEvent(ExecutionEvent executionEvent) {
        AssertArgument.isNotNull((Object)executionEvent, (String)"executionEvent");
        if (this.ignoreEvent(executionEvent)) {
            return;
        }
        if (executionEvent instanceof StartFragmentExecutionEvent) {
            ReportNode node = new ReportNode((StartFragmentExecutionEvent)executionEvent);
            this.allNodes.add(node);
            this.processNewElementEvent(node);
        } else if (this.reportNodeStack.isEmpty()) {
            this.preProcessingEvents.add(executionEvent);
        } else if (executionEvent instanceof FragmentExecutionEvent) {
            ReportNode reportNode = this.getReportNode(((FragmentExecutionEvent)executionEvent).getFragment().unwrap());
            if (reportNode != null) {
                reportNode.elementProcessingEvents.add(executionEvent);
            }
        } else {
            this.processingEvents.add(executionEvent);
        }
    }

    public void onAssemblyStarted(ExecutionContext executionContext) {
        try {
            this.mapMessageNodeVisits(((DOMReport)this.report).getAssemblies());
        }
        catch (IOException e) {
            throw new SmooksException((Throwable)e);
        }
    }

    public void onProcessingStarted(ExecutionContext executionContext) {
    }

    public void onSerializationStarted(ExecutionContext executionContext) {
        try {
            this.mapMessageNodeVisits(this.report.getProcessings());
        }
        catch (IOException e) {
            throw new SmooksException((Throwable)e);
        }
    }

    public void onPreFilter(ExecutionContext executionContext) {
        ContentDeliveryConfig contentDeliveryConfig = executionContext.getContentDeliveryRuntime().getContentDeliveryConfig();
        this.report = contentDeliveryConfig instanceof DOMContentDeliveryConfig ? new DOMReport() : new Report();
        this.mapConfigBuilderEvents(contentDeliveryConfig.getContentDeliveryConfigExecutionEvents());
    }

    public void onPostFilter(ExecutionContext executionContext) {
        try {
            this.processFinishEvent(executionContext);
        }
        catch (IOException e) {
            throw new SmooksException((Throwable)e);
        }
    }

    @Override
    protected boolean ignoreEvent(ExecutionEvent event) {
        if (!super.ignoreEvent(event)) {
            if (event instanceof ResourceAwareEvent && !this.reportConfiguration.showDefaultAppliedResources()) {
                return ((ResourceAwareEvent)event).getResourceConfig().isSystem();
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processFinishEvent(ExecutionContext executionContext) throws IOException {
        if (this.report instanceof DOMReport) {
            if (this.report.getProcessings().isEmpty()) {
                this.mapMessageNodeVisits(this.report.getProcessings());
            } else {
                this.mapMessageNodeVisits(((DOMReport)this.report).getSerializations());
            }
        } else {
            this.mapMessageNodeVisits(this.report.getProcessings());
        }
        ArrayList<ResultNode> resultNodes = new ArrayList<ResultNode>();
        List sinks = (List)executionContext.get(Sink.SINKS_TYPED_KEY);
        this.report.setResults(resultNodes);
        if (sinks != null) {
            for (Sink sink : sinks) {
                if (sink == null) continue;
                ResultNode resultNode = new ResultNode();
                resultNodes.add(resultNode);
                if (sink instanceof JavaSink) {
                    resultNode.setSummary("This Smooks Filtering operation produced a JavaSink.  The following is an XML serialization of the JavaResult bean Map entries.");
                } else if (sink instanceof StringSink) {
                    resultNode.setSummary("This Smooks Filtering operation produced the following StreamSink.");
                } else {
                    resultNode.setSummary("Cannot show Smooks Filtering Sink. Modify the code and use a '" + StringSink.class.getName() + "' Result in the call to the Smooks.filter() method.");
                }
                resultNode.setDetail(sink.toString());
            }
        }
        try {
            this.applyTemplate(this.report);
        }
        finally {
            Writer writer = this.reportConfiguration.getOutputWriter();
            try {
                writer.flush();
            }
            finally {
                if (this.reportConfiguration.autoCloseWriter()) {
                    writer.close();
                }
            }
        }
    }

    private void processNewElementEvent(ReportNode node) {
        if (this.reportNodeStack.isEmpty()) {
            this.reportNodeStack.push(node);
        } else {
            ReportNode head = this.reportNodeStack.peek();
            while (head != null && node.depth <= head.depth) {
                this.reportNodeStack.pop();
                if (!this.reportNodeStack.isEmpty()) {
                    head = this.reportNodeStack.peek();
                    continue;
                }
                head = null;
            }
            node.parent = head;
            if (node.parent != null) {
                node.parent.children.add(node);
            }
            this.reportNodeStack.push(node);
        }
    }

    private void mapConfigBuilderEvents(List<ContentDeliveryConfigExecutionEvent> configBuilderEvents) {
    }

    private void mapMessageNodeVisits(List<MessageNode> visits) throws IOException {
        if (!this.allNodes.isEmpty()) {
            this.mapNode((ReportNode)this.reportNodeStack.elementAt(0), visits);
        }
        this.preProcessingEvents.clear();
        this.processingEvents.clear();
        this.reportNodeStack.clear();
        this.allNodes.clear();
    }

    private void mapNode(ReportNode reportNode, List<MessageNode> visits) {
        MessageNode messageNode = new MessageNode();
        messageNode.setNodeId(this.messageNodeCounter);
        messageNode.setElementName(reportNode.getElementName());
        messageNode.setVisitBefore(true);
        messageNode.setDepth(reportNode.getDepth());
        this.mapNodeEvents(VisitSequence.BEFORE, reportNode, messageNode);
        visits.add(messageNode);
        ++this.messageNodeCounter;
        List children = reportNode.children;
        for (ReportNode child : children) {
            this.mapNode(child, visits);
        }
        messageNode = new MessageNode();
        messageNode.setNodeId(this.messageNodeCounter);
        messageNode.setElementName(reportNode.getElementName());
        messageNode.setVisitBefore(false);
        messageNode.setDepth(reportNode.getDepth());
        this.mapNodeEvents(VisitSequence.AFTER, reportNode, messageNode);
        visits.add(messageNode);
        ++this.messageNodeCounter;
    }

    private void mapNodeEvents(VisitSequence visitSequence, ReportNode reportNode, MessageNode messageNode) {
        List<ExecutionEvent> events = reportNode.getElementProcessingEvents();
        for (ExecutionEvent event : events) {
            VisitExecutionEvent visitEvent;
            if (!(event instanceof VisitExecutionEvent) || (visitEvent = (VisitExecutionEvent)event).getSequence() != visitSequence) continue;
            ReportInfoNode reportInfoNode = new ReportInfoNode();
            ContentHandlerBinding configMapping = ((VisitExecutionEvent)event).getVisitorBinding();
            messageNode.addExecInfoNode(reportInfoNode);
            reportInfoNode.setNodeId(this.reportInfoNodeCounter);
            reportInfoNode.setSummary(configMapping.getContentHandler().getClass().getSimpleName() + ": " + visitEvent.getReportSummary());
            reportInfoNode.setDetail(visitEvent.getReportDetail());
            reportInfoNode.setResourceXML(configMapping.getResourceConfig().toXml());
            reportInfoNode.setContextState(visitEvent.getExecutionContextState());
            ++this.reportInfoNodeCounter;
        }
    }

    public abstract void applyTemplate(Report var1) throws IOException;

    private ReportNode getReportNode(Object element) {
        for (ReportNode node : this.allNodes) {
            if (node.element != element) continue;
            return node;
        }
        return null;
    }

    public class ReportNode {
        private ReportNode parent;
        private final List<ReportNode> children = new ArrayList<ReportNode>();
        private final Object element;
        private final int depth;
        private final List<ExecutionEvent> elementProcessingEvents = new ArrayList<ExecutionEvent>();

        public ReportNode(StartFragmentExecutionEvent eventPresentEvent) {
            this.element = eventPresentEvent.getFragment().unwrap();
            this.depth = eventPresentEvent.getDepth();
        }

        public String getElementName() {
            return DomUtils.getName((Element)this.element);
        }

        public String toString() {
            return this.element + " (depth " + this.depth + ")";
        }

        public ReportNode getParent() {
            return this.parent;
        }

        public List<ReportNode> getChildren() {
            return this.children;
        }

        public Object getElement() {
            return this.element;
        }

        public int getDepth() {
            return this.depth;
        }

        public List<ExecutionEvent> getElementProcessingEvents() {
            return this.elementProcessingEvents;
        }
    }
}

