/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.plugin;

import org.smooks.Smooks;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksException;
import org.smooks.api.io.Sink;
import org.smooks.api.io.Source;
import org.smooks.assertion.AssertArgument;
import org.smooks.engine.plugin.SinkFactory;
import org.smooks.engine.plugin.SinkType;
import org.smooks.engine.plugin.SourceFactory;
import org.smooks.engine.plugin.SourceSink;
import org.smooks.io.sink.ByteSink;
import org.smooks.io.sink.JavaSink;
import org.smooks.io.sink.StringSink;

public class PayloadProcessor {
    private final Smooks smooks;
    private final SinkType sinkType;
    private String javaResultBeanId;

    public PayloadProcessor(Smooks smooks, SinkType sinkType) {
        AssertArgument.isNotNull((Object)smooks, (String)"smooks");
        AssertArgument.isNotNull((Object)((Object)sinkType), (String)"sinkType");
        this.smooks = smooks;
        this.sinkType = sinkType;
    }

    public void setJavaResultBeanId(String javaResultBeanId) {
        AssertArgument.isNotNullAndNotEmpty((String)javaResultBeanId, (String)"javaResultBeanId");
        this.javaResultBeanId = javaResultBeanId;
    }

    public final Object process(Object payload, ExecutionContext executionContext) throws SmooksException {
        Sink sink;
        Source source;
        AssertArgument.isNotNull((Object)payload, (String)"payload");
        if (payload instanceof SourceSink) {
            SourceSink sourceSink = (SourceSink)payload;
            source = sourceSink.getSource();
            sink = sourceSink.getSink();
        } else {
            source = SourceFactory.getInstance().createSource(payload);
            sink = SinkFactory.getInstance().createSink(this.sinkType);
        }
        this.smooks.filterSource(executionContext, source, sink);
        if (sink instanceof JavaSink) {
            if (this.javaResultBeanId != null) {
                return ((JavaSink)sink).getResultMap().get(this.javaResultBeanId);
            }
            return ((JavaSink)sink).getResultMap();
        }
        if (sink instanceof StringSink) {
            return ((StringSink)sink).getResult();
        }
        if (sink instanceof ByteSink) {
            return ((ByteSink)sink).getResult();
        }
        return sink;
    }
}

