/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.expression;

import org.smooks.api.SmooksConfigException;
import org.smooks.api.expression.ExecutionContextExpressionEvaluator;
import org.smooks.api.expression.ExpressionEvaluator;
import org.smooks.support.ClassUtils;

public class ExpressionEvaluatorFactory {
    public ExpressionEvaluator create(String className, String conditionExpression) {
        try {
            ExpressionEvaluator evaluator = (ExpressionEvaluator)ClassUtils.forName((String)className, ExpressionEvaluatorFactory.class).newInstance();
            if (!(evaluator instanceof ExecutionContextExpressionEvaluator)) {
                throw new SmooksConfigException("Unsupported ExpressionEvaluator type '" + className + "'.  Currently only support '" + ExecutionContextExpressionEvaluator.class.getName() + "' implementations.");
            }
            evaluator.setExpression(conditionExpression);
            return evaluator;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new SmooksConfigException("Failed to load ExpressionEvaluator Class '" + className + "'.", (Throwable)e);
        }
        catch (ClassCastException e) {
            throw new SmooksConfigException("Class '" + className + "' is not a valid ExpressionEvaluator.  It doesn't implement " + ExpressionEvaluator.class.getName());
        }
    }
}

