/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.delivery.sax.ng.pointer;

import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksException;
import org.smooks.api.TypedKey;
import org.smooks.engine.delivery.event.VisitSequence;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EventPointer {
    private final Node pointerNode;

    public EventPointer(Node node) {
        if (!EventPointer.isPointer(node)) {
            throw new SmooksException("Node is not a pointer element");
        }
        this.pointerNode = node;
    }

    public EventPointer(Document factory, VisitSequence visitSequence) {
        Element pointerElement = factory.createElementNS("https://www.smooks.org", "pointer");
        pointerElement.setAttribute("visit", visitSequence.toString());
        pointerElement.setAttribute("reference", TypedKey.of().getName());
        this.pointerNode = pointerElement;
    }

    public Node getPointerNode() {
        return this.pointerNode;
    }

    public static boolean isPointer(Node node) {
        return node instanceof Element && node.getNamespaceURI() != null && node.getNamespaceURI().equals("https://www.smooks.org") && node.getLocalName().equals("pointer");
    }

    public TypedKey<Node> getReference() {
        return TypedKey.of((String)this.pointerNode.getAttributes().getNamedItem("reference").getNodeValue());
    }

    public VisitSequence getVisit() {
        return VisitSequence.valueOf(this.pointerNode.getAttributes().getNamedItem("visit").getNodeValue());
    }

    public Node dereference(ExecutionContext executionContext) {
        return (Node)executionContext.get(this.getReference());
    }
}

