/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.delivery.sax.ng;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.SmooksException;
import org.smooks.api.delivery.ContentHandlerBinding;
import org.smooks.api.delivery.Filter;
import org.smooks.api.delivery.FilterBypass;
import org.smooks.api.resource.visitor.sax.ng.AfterVisitor;
import org.smooks.api.resource.visitor.sax.ng.BeforeVisitor;
import org.smooks.api.resource.visitor.sax.ng.ChildrenVisitor;
import org.smooks.engine.delivery.AbstractContentDeliveryConfig;
import org.smooks.engine.delivery.ContentHandlerBindingIndex;
import org.smooks.engine.delivery.ordering.Sorter;
import org.smooks.engine.delivery.sax.ng.SaxNgFilter;
import org.smooks.engine.delivery.sax.ng.SaxNgVisitorBindings;
import org.smooks.engine.lookup.GlobalParamsLookup;

public class SaxNgContentDeliveryConfig
extends AbstractContentDeliveryConfig {
    private final Map<String, SaxNgVisitorBindings> saxNgVisitorBindingsCache = new ConcurrentHashMap<String, SaxNgVisitorBindings>();
    private final ThreadLocal<DocumentBuilder> cachedDocumentBuilder = new ThreadLocal();
    private final ContentHandlerBindingIndex<ChildrenVisitor> childVisitorIndex = new ContentHandlerBindingIndex();
    private final ContentHandlerBindingIndex<BeforeVisitor> beforeVisitorIndex = new ContentHandlerBindingIndex();
    private final ContentHandlerBindingIndex<AfterVisitor> afterVisitorIndex = new ContentHandlerBindingIndex();
    private volatile Map<String, SaxNgVisitorBindings> reducedIndex;
    private Integer maxNodeDepth;
    private Boolean rewriteEntities;
    private Boolean maintainElementStack;
    private Boolean reverseVisitOrderOnVisitAfter;
    private Boolean terminateOnVisitorException;
    private Optional<FilterBypass> filterBypass;

    public ContentHandlerBindingIndex<BeforeVisitor> getBeforeVisitorIndex() {
        return this.beforeVisitorIndex;
    }

    public ContentHandlerBindingIndex<ChildrenVisitor> getChildVisitorIndex() {
        return this.childVisitorIndex;
    }

    public ContentHandlerBindingIndex<AfterVisitor> getAfterVisitorIndex() {
        return this.afterVisitorIndex;
    }

    public FilterBypass getFilterBypass() {
        if (this.filterBypass == null) {
            this.filterBypass = Optional.ofNullable(this.getFilterBypass(this.beforeVisitorIndex, this.afterVisitorIndex));
        }
        return this.filterBypass.orElse(null);
    }

    public Filter newFilter(ExecutionContext executionContext) {
        DocumentBuilder documentBuilder = this.cachedDocumentBuilder.get();
        if (documentBuilder == null) {
            try {
                documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                this.cachedDocumentBuilder.set(documentBuilder);
            }
            catch (ParserConfigurationException e) {
                throw new SmooksException((Throwable)e);
            }
        }
        return new SaxNgFilter(executionContext, documentBuilder, this.getCloseSource(), this.getCloseSink());
    }

    public void sort() throws SmooksConfigException {
        this.beforeVisitorIndex.sort(Sorter.SortOrder.PRODUCERS_FIRST);
        this.childVisitorIndex.sort(Sorter.SortOrder.PRODUCERS_FIRST);
        this.afterVisitorIndex.sort(Sorter.SortOrder.CONSUMERS_FIRST);
    }

    public void addToExecutionLifecycleSets() throws SmooksConfigException {
        this.addToExecutionLifecycleSets(this.beforeVisitorIndex);
        this.addToExecutionLifecycleSets(this.afterVisitorIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SaxNgVisitorBindings get(String selector) {
        if (this.reducedIndex == null) {
            SaxNgContentDeliveryConfig saxNgContentDeliveryConfig = this;
            synchronized (saxNgContentDeliveryConfig) {
                if (this.reducedIndex == null) {
                    this.reducedIndex = this.reduceIndex();
                }
            }
        }
        return this.reducedIndex.get(selector);
    }

    protected Map<String, SaxNgVisitorBindings> reduceIndex() {
        HashMap<String, SaxNgVisitorBindings> reducedIndex = new HashMap<String, SaxNgVisitorBindings>();
        ArrayList starVBs = new ArrayList();
        ArrayList starVCs = new ArrayList();
        ArrayList starVAs = new ArrayList();
        if (this.beforeVisitorIndex.get((Object)"*") != null) {
            starVBs.addAll(this.beforeVisitorIndex.get((Object)"*"));
        }
        if (this.beforeVisitorIndex.get((Object)"//") != null) {
            starVBs.addAll(this.beforeVisitorIndex.get((Object)"//"));
        }
        if (this.childVisitorIndex.get((Object)"*") != null) {
            starVCs.addAll(this.childVisitorIndex.get((Object)"*"));
        }
        if (this.childVisitorIndex.get((Object)"//") != null) {
            starVCs.addAll(this.childVisitorIndex.get((Object)"//"));
        }
        if (this.afterVisitorIndex.get((Object)"*") != null) {
            starVAs.addAll(this.afterVisitorIndex.get((Object)"*"));
        }
        if (this.afterVisitorIndex.get((Object)"//") != null) {
            starVAs.addAll(this.afterVisitorIndex.get((Object)"//"));
        }
        HashSet<String> selectors = new HashSet<String>();
        selectors.addAll(this.beforeVisitorIndex.keySet());
        selectors.addAll(this.afterVisitorIndex.keySet());
        for (String selector : selectors) {
            boolean isStar;
            SaxNgVisitorBindings visitorBindings = new SaxNgVisitorBindings();
            List beforeVisitors = this.beforeVisitorIndex.getOrDefault(selector, new ArrayList());
            List childVisitors = this.childVisitorIndex.getOrDefault(selector, new ArrayList());
            List afterVisitors = this.afterVisitorIndex.getOrDefault(selector, new ArrayList());
            boolean bl = isStar = selector.equals("*") || selector.equals("//");
            if (!isStar) {
                beforeVisitors.addAll(starVBs);
            }
            visitorBindings.setBeforeVisitors(beforeVisitors);
            if (!isStar) {
                childVisitors.addAll(starVCs);
            }
            visitorBindings.setChildVisitors(childVisitors);
            if (!isStar) {
                afterVisitors.addAll(starVAs);
            }
            visitorBindings.setAfterVisitors(afterVisitors);
            reducedIndex.put(selector, visitorBindings);
        }
        Boolean smooksVisitorsSort = ((GlobalParamsLookup.ParameterAccessor)this.registry.lookup((Function)new GlobalParamsLookup())).getParameterValue("smooks.visitors.sort", true);
        if (smooksVisitorsSort.booleanValue()) {
            this.sort();
        }
        return reducedIndex;
    }

    public SaxNgVisitorBindings get(String ... selectors) {
        SaxNgVisitorBindings saxNgVisitorBindings = this.saxNgVisitorBindingsCache.get(String.join((CharSequence)":", selectors));
        if (saxNgVisitorBindings == null) {
            SaxNgVisitorBindings starStarVisitorBindings;
            saxNgVisitorBindings = new SaxNgVisitorBindings();
            saxNgVisitorBindings.setBeforeVisitors(new ArrayList<ContentHandlerBinding<BeforeVisitor>>());
            saxNgVisitorBindings.setChildVisitors(new ArrayList<ContentHandlerBinding<ChildrenVisitor>>());
            saxNgVisitorBindings.setAfterVisitors(new ArrayList<ContentHandlerBinding<AfterVisitor>>());
            for (String selector : selectors) {
                boolean isStar;
                SaxNgVisitorBindings visitorBindings = this.get(selector);
                if (visitorBindings == null) continue;
                List<ContentHandlerBinding<BeforeVisitor>> beforeVisitorBindings = visitorBindings.getBeforeVisitors();
                List<ContentHandlerBinding<ChildrenVisitor>> childVisitorBindings = visitorBindings.getChildVisitors();
                List<ContentHandlerBinding<AfterVisitor>> afterVisitorBindings = visitorBindings.getAfterVisitors();
                if (beforeVisitorBindings != null) {
                    for (ContentHandlerBinding<BeforeVisitor> contentHandlerBinding : beforeVisitorBindings) {
                        isStar = contentHandlerBinding.getResourceConfig().getSelectorPath().getSelector().equals("*") || contentHandlerBinding.getResourceConfig().getSelectorPath().getSelector().equals("//");
                        if (isStar) continue;
                        saxNgVisitorBindings.getBeforeVisitors().add(contentHandlerBinding);
                    }
                }
                if (childVisitorBindings != null) {
                    for (ContentHandlerBinding<BeforeVisitor> contentHandlerBinding : childVisitorBindings) {
                        isStar = contentHandlerBinding.getResourceConfig().getSelectorPath().getSelector().equals("*") || contentHandlerBinding.getResourceConfig().getSelectorPath().getSelector().equals("//");
                        if (isStar) continue;
                        saxNgVisitorBindings.getChildVisitors().add(contentHandlerBinding);
                    }
                }
                if (afterVisitorBindings == null) continue;
                for (ContentHandlerBinding<BeforeVisitor> contentHandlerBinding : afterVisitorBindings) {
                    isStar = contentHandlerBinding.getResourceConfig().getSelectorPath().getSelector().equals("*") || contentHandlerBinding.getResourceConfig().getSelectorPath().getSelector().equals("//");
                    if (isStar) continue;
                    saxNgVisitorBindings.getAfterVisitors().add(contentHandlerBinding);
                }
            }
            SaxNgVisitorBindings starVisitorBindings = this.get("*");
            if (starVisitorBindings != null) {
                saxNgVisitorBindings.getBeforeVisitors().addAll(starVisitorBindings.getBeforeVisitors());
                saxNgVisitorBindings.getChildVisitors().addAll(starVisitorBindings.getChildVisitors());
                saxNgVisitorBindings.getAfterVisitors().addAll(starVisitorBindings.getAfterVisitors());
            }
            if ((starStarVisitorBindings = this.get("//")) != null) {
                saxNgVisitorBindings.getBeforeVisitors().addAll(starStarVisitorBindings.getBeforeVisitors());
                saxNgVisitorBindings.getChildVisitors().addAll(starStarVisitorBindings.getChildVisitors());
                saxNgVisitorBindings.getAfterVisitors().addAll(starStarVisitorBindings.getAfterVisitors());
            }
            this.saxNgVisitorBindingsCache.put(String.join((CharSequence)":", selectors), saxNgVisitorBindings);
        }
        if (saxNgVisitorBindings.getBeforeVisitors().isEmpty() && saxNgVisitorBindings.getChildVisitors().isEmpty() && saxNgVisitorBindings.getAfterVisitors().isEmpty()) {
            return null;
        }
        return saxNgVisitorBindings;
    }

    public boolean isRewriteEntities() {
        if (this.rewriteEntities == null) {
            this.rewriteEntities = Boolean.parseBoolean((String)((GlobalParamsLookup.ParameterAccessor)this.registry.lookup((Function)new GlobalParamsLookup())).getParameterValue("entities.rewrite"));
        }
        return this.rewriteEntities;
    }

    public boolean isMaintainElementStack() {
        if (this.maintainElementStack == null) {
            this.maintainElementStack = Boolean.parseBoolean((String)((GlobalParamsLookup.ParameterAccessor)this.registry.lookup((Function)new GlobalParamsLookup())).getParameterValue("maintain.element.stack"));
        }
        return this.maintainElementStack;
    }

    public boolean isReverseVisitOrderOnVisitAfter() {
        if (this.reverseVisitOrderOnVisitAfter == null) {
            this.reverseVisitOrderOnVisitAfter = Boolean.parseBoolean(((GlobalParamsLookup.ParameterAccessor)this.registry.lookup((Function)new GlobalParamsLookup())).getParameterValue("reverse.visit.order.on.visit.after", "true"));
        }
        return this.reverseVisitOrderOnVisitAfter;
    }

    public boolean isTerminateOnVisitorException() {
        if (this.terminateOnVisitorException == null) {
            this.terminateOnVisitorException = Boolean.parseBoolean((String)((GlobalParamsLookup.ParameterAccessor)this.registry.lookup((Function)new GlobalParamsLookup())).getParameterValue("terminate.on.visitor.exception"));
        }
        return this.terminateOnVisitorException;
    }

    public int getMaxNodeDepth() {
        if (this.maxNodeDepth == null) {
            this.maxNodeDepth = Integer.parseInt((String)((GlobalParamsLookup.ParameterAccessor)this.registry.lookup((Function)new GlobalParamsLookup())).getParameterValue("max.node.depth"));
        }
        return this.maxNodeDepth;
    }
}

