/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.delivery.interceptor;

import jakarta.annotation.PostConstruct;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksException;
import org.smooks.api.delivery.ContentHandlerBinding;
import org.smooks.api.delivery.event.ExecutionEventListener;
import org.smooks.api.delivery.fragment.Fragment;
import org.smooks.api.resource.visitor.Visitor;
import org.smooks.api.resource.visitor.dom.DOMElementVisitor;
import org.smooks.api.resource.visitor.sax.ng.ElementVisitor;
import org.smooks.engine.delivery.event.VisitExecutionEvent;
import org.smooks.engine.delivery.event.VisitSequence;
import org.smooks.engine.delivery.fragment.NodeFragment;
import org.smooks.engine.delivery.interceptor.AbstractInterceptorVisitor;
import org.smooks.engine.delivery.sax.ng.terminate.TerminateException;
import org.smooks.engine.lookup.GlobalParamsLookup;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ExceptionInterceptor
extends AbstractInterceptorVisitor
implements ElementVisitor,
DOMElementVisitor {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ExceptionInterceptor.class);
    protected static final char PATH_SEPARATOR = '/';
    protected static final String LINE_SEPARATOR = System.lineSeparator();
    protected static final String DIVIDER = LINE_SEPARATOR + "---------------------------------------------------------------------------------------------------------------------------------------" + LINE_SEPARATOR;
    protected boolean terminateOnVisitorException;
    protected String visitBeforeExceptionMessage;
    protected String visitAfterExceptionMessage;
    protected String visitChildTextExceptionMessage;
    protected String visitChildElementExceptionMessage;

    @PostConstruct
    public void postConstruct() {
        this.terminateOnVisitorException = Boolean.parseBoolean((String)((GlobalParamsLookup.ParameterAccessor)this.applicationContext.getRegistry().lookup((Function)new GlobalParamsLookup())).getParameterValue("terminate.on.visitor.exception"));
        String errorContext = LINE_SEPARATOR + LINE_SEPARATOR + "Error Context" + DIVIDER;
        errorContext = errorContext + "Event => %s" + LINE_SEPARATOR + "Selector => " + this.getTarget().getResourceConfig().getSelectorPath().getSelector() + LINE_SEPARATOR + "Content handler => " + ((Visitor)this.getTarget().getContentHandler()).getClass().getName();
        this.visitBeforeExceptionMessage = "Error while processing start event" + errorContext;
        this.visitAfterExceptionMessage = "Error while processing end event" + errorContext;
        this.visitChildTextExceptionMessage = "Error while processing text event" + errorContext;
        this.visitChildElementExceptionMessage = "Error while processing child event" + errorContext;
    }

    public void visitBefore(Element element, ExecutionContext executionContext) {
        this.intercept(this.visitBeforeInvocation, executionContext, this.visitBeforeExceptionMessage, new NodeFragment(element), VisitSequence.BEFORE, element, executionContext);
    }

    public void visitAfter(Element element, ExecutionContext executionContext) {
        this.intercept(this.visitAfterInvocation, executionContext, this.visitAfterExceptionMessage, new NodeFragment(element), VisitSequence.AFTER, element, executionContext);
    }

    public void visitChildText(CharacterData characterData, ExecutionContext executionContext) {
        this.intercept(this.visitChildTextInvocation, executionContext, this.visitChildTextExceptionMessage, new NodeFragment(characterData), VisitSequence.AFTER, characterData, executionContext);
    }

    public void visitChildElement(Element childElement, ExecutionContext executionContext) {
        try {
            this.intercept(this.visitChildElementInvocation, childElement, executionContext);
        }
        catch (Throwable t) {
            this.processVisitorException(t, this.visitChildElementExceptionMessage, executionContext, new NodeFragment(childElement), VisitSequence.AFTER, (ContentHandlerBinding<Visitor>)this.visitorBinding);
        }
    }

    protected <T extends Visitor> void intercept(AbstractInterceptorVisitor.Invocation<T> invocation, ExecutionContext executionContext, String exceptionMessage, Fragment<?> fragment, VisitSequence visitSequence, Object ... invocationArgs) {
        try {
            this.intercept(invocation, invocationArgs);
        }
        catch (Throwable t) {
            this.processVisitorException(t, exceptionMessage, executionContext, fragment, visitSequence, (ContentHandlerBinding<Visitor>)this.visitorBinding);
        }
    }

    protected void processVisitorException(Throwable t, String exceptionMessage, ExecutionContext executionContext, Fragment<?> fragment, VisitSequence visitSequence, ContentHandlerBinding<Visitor> visitorBinding) {
        for (ExecutionEventListener executionEventListener : executionContext.getContentDeliveryRuntime().getExecutionEventListeners()) {
            executionEventListener.onEvent(new VisitExecutionEvent(fragment, visitorBinding, visitSequence, executionContext, t));
        }
        if (t instanceof TerminateException) {
            throw (TerminateException)((Object)t);
        }
        if (executionContext.getTerminationError() == null) {
            executionContext.setTerminationError(t);
        }
        String completeExceptionMessage = String.format(exceptionMessage, this.toPath((Node)fragment.unwrap()));
        if (this.terminateOnVisitorException) {
            if (t instanceof SmooksException) {
                throw (SmooksException)t;
            }
            throw new SmooksException(completeExceptionMessage + DIVIDER, t);
        }
        LOGGER.error(completeExceptionMessage + LINE_SEPARATOR + LINE_SEPARATOR + "Stack Trace" + DIVIDER + this.stackTraceToString(t));
    }

    protected String toPath(Node node) {
        StringBuilder path = new StringBuilder().append('/').append(node.getNodeName());
        for (node = node.getParentNode(); node != null && !(node instanceof Document); node = node.getParentNode()) {
            path.insert(0, '/' + node.getNodeName());
        }
        return path.toString();
    }

    protected String stackTraceToString(Throwable e) {
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)writer, true);
        e.printStackTrace(printWriter);
        return writer.toString();
    }
}

