/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.delivery.dom;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.api.ExecutionContext;
import org.smooks.api.Registry;
import org.smooks.api.SmooksException;
import org.smooks.api.TypedKey;
import org.smooks.api.delivery.ContentDeliveryRuntime;
import org.smooks.api.delivery.ContentHandler;
import org.smooks.api.delivery.ContentHandlerBinding;
import org.smooks.api.delivery.event.ExecutionEventListener;
import org.smooks.api.delivery.fragment.Fragment;
import org.smooks.api.io.Sink;
import org.smooks.api.io.Source;
import org.smooks.api.lifecycle.DOMFilterLifecycle;
import org.smooks.api.lifecycle.LifecycleManager;
import org.smooks.api.lifecycle.LifecyclePhase;
import org.smooks.api.lifecycle.PostFragmentLifecycle;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.visitor.Visitor;
import org.smooks.api.resource.visitor.dom.DOMVisitAfter;
import org.smooks.api.resource.visitor.dom.DOMVisitBefore;
import org.smooks.api.resource.visitor.dom.VisitPhase;
import org.smooks.engine.delivery.AbstractFilter;
import org.smooks.engine.delivery.ContentHandlerBindingIndex;
import org.smooks.engine.delivery.dom.DOMContentDeliveryConfig;
import org.smooks.engine.delivery.dom.DOMParser;
import org.smooks.engine.delivery.event.ResourceTargetingExecutionEvent;
import org.smooks.engine.delivery.event.StartFragmentExecutionEvent;
import org.smooks.engine.delivery.event.VisitExecutionEvent;
import org.smooks.engine.delivery.event.VisitSequence;
import org.smooks.engine.delivery.fragment.NodeFragment;
import org.smooks.engine.lifecycle.AssemblyStartedDOMFilterLifecyclePhase;
import org.smooks.engine.lifecycle.PostFragmentPhase;
import org.smooks.engine.lifecycle.ProcessingStartedDOMFilterLifecyclePhase;
import org.smooks.engine.lookup.GlobalParamsLookup;
import org.smooks.engine.lookup.InstanceLookup;
import org.smooks.engine.lookup.LifecycleManagerLookup;
import org.smooks.engine.report.AbstractReportGenerator;
import org.smooks.engine.resource.visitor.dom.Serializer;
import org.smooks.engine.resource.visitor.dom.TextSerializerVisitor;
import org.smooks.io.Stream;
import org.smooks.io.sink.DOMSink;
import org.smooks.io.sink.JavaSink;
import org.smooks.io.sink.StreamSink;
import org.smooks.io.sink.WriterSink;
import org.smooks.io.source.DOMSource;
import org.smooks.io.source.JavaSource;
import org.smooks.io.source.ReaderSource;
import org.smooks.io.source.StreamSource;
import org.smooks.io.source.URLSource;
import org.smooks.support.DomUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SmooksDOMFilter
extends AbstractFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmooksDOMFilter.class);
    private final ExecutionContext executionContext;
    private final DOMContentDeliveryConfig deliveryConfig;
    private static final TypedKey<Node> DELIVERY_NODE_REQUEST_KEY = TypedKey.of();
    private final Boolean closeSource;
    private final Boolean closeSink;
    private final Boolean reverseVisitOrderOnVisitAfter;
    private final ContentDeliveryRuntime contentDeliveryRuntime;
    private final LifecycleManager lifecycleManager;
    private Boolean terminateOnVisitorException;
    private List<ContentHandlerBinding<DOMVisitBefore>> globalAssemblyBefores;
    private List<ContentHandlerBinding<DOMVisitAfter>> globalAssemblyAfters;
    private List<ContentHandlerBinding<DOMVisitBefore>> globalProcessingBefores;
    private List<ContentHandlerBinding<DOMVisitAfter>> globalProcessingAfters;
    private static final String[] GLOBAL_SELECTORS = new String[]{"*", "//"};

    public SmooksDOMFilter(ExecutionContext executionContext) {
        if (executionContext == null) {
            throw new IllegalArgumentException("null 'executionContext' arg passed in constructor call.");
        }
        this.executionContext = executionContext;
        this.contentDeliveryRuntime = executionContext.getContentDeliveryRuntime();
        this.deliveryConfig = (DOMContentDeliveryConfig)this.contentDeliveryRuntime.getContentDeliveryConfig();
        Registry registry = executionContext.getApplicationContext().getRegistry();
        this.lifecycleManager = (LifecycleManager)registry.lookup((Function)new LifecycleManagerLookup());
        this.closeSource = Boolean.parseBoolean((String)((GlobalParamsLookup.ParameterAccessor)registry.lookup((Function)new GlobalParamsLookup())).getParameterValue("close.source"));
        this.closeSink = Boolean.parseBoolean((String)((GlobalParamsLookup.ParameterAccessor)registry.lookup((Function)new GlobalParamsLookup())).getParameterValue("close.sink"));
        this.reverseVisitOrderOnVisitAfter = Boolean.parseBoolean(((GlobalParamsLookup.ParameterAccessor)registry.lookup((Function)new GlobalParamsLookup())).getParameterValue("reverse.visit.order.on.visit.after", "true"));
        for (ExecutionEventListener executionEventListener : this.contentDeliveryRuntime.getExecutionEventListeners()) {
            if (!(executionEventListener instanceof AbstractReportGenerator)) continue;
            this.terminateOnVisitorException = false;
            break;
        }
        if (this.terminateOnVisitorException == null) {
            this.terminateOnVisitorException = Boolean.parseBoolean((String)((GlobalParamsLookup.ParameterAccessor)registry.lookup((Function)new GlobalParamsLookup())).getParameterValue("terminate.on.visitor.exception"));
        }
    }

    public void doFilter() throws SmooksException {
        Source source = (Source)this.executionContext.get(Source.SOURCE_TYPED_KEY);
        Sink sink = this.getSink(this.executionContext, StreamSink.class);
        if (sink == null && (sink = this.getSink(this.executionContext, WriterSink.class)) == null) {
            sink = this.getSink(this.executionContext, DOMSink.class);
        }
        this.doFilter(source, sink);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doFilter(Source source, Sink sink) {
        if (!(source instanceof StreamSource || source instanceof ReaderSource || source instanceof DOMSource || source instanceof JavaSource || source instanceof URLSource)) {
            throw new IllegalArgumentException(source.getClass().getName() + " Source types not yet supported by the DOM Filter.");
        }
        if (!(sink == null || sink instanceof StreamSink || sink instanceof WriterSink || sink instanceof DOMSink || sink instanceof JavaSink)) {
            throw new IllegalArgumentException(sink.getClass().getName() + " Sinks types not yet supported by the DOM Filter.");
        }
        try {
            Node resultNode;
            if (source instanceof DOMSource) {
                Node node = ((DOMSource)source).getNode();
                if (node instanceof Document) {
                    resultNode = this.filter((Document)node);
                } else {
                    if (!(node instanceof Element)) throw new IllegalArgumentException("DOMSource Source types must contain a Document or Element node.");
                    resultNode = this.filter((Element)node);
                }
            } else {
                resultNode = this.filter(source);
            }
            if (sink instanceof WriterSink || sink instanceof StreamSink) {
                Writer writer = this.getWriter(sink, this.executionContext);
                try {
                    this.serialize(resultNode, writer);
                    writer.flush();
                    return;
                }
                catch (IOException e) {
                    LOGGER.debug("Error writing result to output stream.", (Throwable)e);
                }
                return;
            } else {
                if (!(sink instanceof DOMSink)) return;
                ((DOMSink)sink).setNode(resultNode);
            }
            return;
        }
        finally {
            if (this.closeSource.booleanValue()) {
                this.close(source);
            }
            if (this.closeSink.booleanValue()) {
                this.close(sink);
            }
        }
    }

    public void close() {
    }

    public Node filter(Source source) {
        Node deliveryNode;
        if (source == null) {
            throw new IllegalArgumentException("null 'source' arg passed in method call.");
        }
        try {
            DOMParser parser = new DOMParser(this.executionContext);
            Document document = parser.parse(source);
            deliveryNode = this.filter(document);
        }
        catch (Exception cause) {
            throw new SmooksException("Unable to filter InputStream for target profile [" + this.executionContext.getTargetProfiles().getBaseProfile() + "].", (Throwable)cause);
        }
        return deliveryNode;
    }

    public Node filter(Document doc) {
        if (doc.getDocumentElement() == null) {
            LOGGER.debug("Empty Document [" + this.executionContext.getDocumentSource() + "].  Not performaing any processing.");
            return doc;
        }
        Node deliveryNode = this.filter(doc.getDocumentElement());
        if (deliveryNode == null) {
            deliveryNode = doc;
        }
        return deliveryNode;
    }

    public Node filter(final Element element) {
        this.executionContext.put(Stream.STREAM_WRITER_TYPED_KEY, (Object)new Writer(){

            @Override
            public void write(char[] cbuf, int off, int len) {
                StringWriter stringWriter = new StringWriter();
                stringWriter.write(cbuf, off, len);
                Element resultNode = TextSerializerVisitor.createTextElement(element, stringWriter.toString());
                DomUtils.replaceNode(resultNode, (Node)element);
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
            }
        });
        ContentHandlerBindingIndex<DOMVisitBefore> visitBeforeContentHandlerBindingIndex = this.deliveryConfig.getAssemblyVisitBeforeIndex();
        ContentHandlerBindingIndex<DOMVisitAfter> visitAfterContentHandlerBindingIndex = this.deliveryConfig.getAssemblyVisitAfterIndex();
        this.globalAssemblyBefores = visitBeforeContentHandlerBindingIndex.get(GLOBAL_SELECTORS);
        this.globalAssemblyAfters = visitAfterContentHandlerBindingIndex.get(GLOBAL_SELECTORS);
        Registry registry = this.executionContext.getApplicationContext().getRegistry();
        LifecycleManager lifecycleManager = (LifecycleManager)registry.lookup((Function)new LifecycleManagerLookup());
        AssemblyStartedDOMFilterLifecyclePhase assemblyStartedDOMFilterLifecyclePhase = new AssemblyStartedDOMFilterLifecyclePhase(this.executionContext);
        for (Object domFilterLifecycle : ((Map)registry.lookup(new InstanceLookup<DOMFilterLifecycle>(DOMFilterLifecycle.class))).values()) {
            lifecycleManager.applyPhase(domFilterLifecycle, (LifecyclePhase)assemblyStartedDOMFilterLifecyclePhase);
        }
        if (this.applyAssembly(visitBeforeContentHandlerBindingIndex, visitAfterContentHandlerBindingIndex)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Starting assembly phase [" + this.executionContext.getTargetProfiles().getBaseProfile() + "]");
            }
            this.assemble(element, true);
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("No assembly units configured for device [" + this.executionContext.getTargetProfiles().getBaseProfile() + "]");
        }
        ProcessingStartedDOMFilterLifecyclePhase processingStartedDOMFilterLifecyclePhase = new ProcessingStartedDOMFilterLifecyclePhase(this.executionContext);
        for (DOMFilterLifecycle domFilterLifecycle : ((Map)registry.lookup(new InstanceLookup<DOMFilterLifecycle>(DOMFilterLifecycle.class))).values()) {
            lifecycleManager.applyPhase((Object)domFilterLifecycle, (LifecyclePhase)processingStartedDOMFilterLifecyclePhase);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Starting processing phase [" + this.executionContext.getTargetProfiles().getBaseProfile() + "]");
        }
        this.globalProcessingBefores = this.deliveryConfig.getProcessingVisitBeforeIndex().get(GLOBAL_SELECTORS);
        if (this.globalProcessingBefores != null && this.globalProcessingBefores.isEmpty()) {
            this.globalProcessingBefores = null;
        }
        this.globalProcessingAfters = this.deliveryConfig.getProcessingVisitAfterIndex().get(GLOBAL_SELECTORS);
        if (this.globalProcessingAfters != null && this.globalProcessingAfters.isEmpty()) {
            this.globalProcessingAfters = null;
        }
        ArrayList<ElementProcessor> transList = new ArrayList<ElementProcessor>();
        this.buildProcessingList(transList, element, true);
        int transListLength = transList.size();
        for (int i = 0; i < transListLength; ++i) {
            ElementProcessor elementTrans = (ElementProcessor)transList.get(i);
            elementTrans.process(this.executionContext);
        }
        return (Node)this.executionContext.get(DELIVERY_NODE_REQUEST_KEY);
    }

    private boolean applyAssembly(ContentHandlerBindingIndex<DOMVisitBefore> visitBefores, ContentHandlerBindingIndex<DOMVisitAfter> visitAfters) {
        return !visitBefores.isEmpty() || !visitAfters.isEmpty() || this.globalAssemblyBefores != null && !this.globalAssemblyBefores.isEmpty() || this.globalAssemblyAfters != null && !this.globalAssemblyAfters.isEmpty();
    }

    private void assemble(Element element, boolean isRoot) {
        List<ContentHandlerBinding<DOMVisitAfter>> elementVisitAfters;
        List<ContentHandlerBinding<DOMVisitBefore>> elementVisitBefores;
        List<Node> nodeListCopy = this.copyList(element.getChildNodes());
        ContentHandlerBindingIndex<DOMVisitBefore> visitBeforeTable = this.deliveryConfig.getAssemblyVisitBeforeIndex();
        ContentHandlerBindingIndex<DOMVisitAfter> visitAfterTable = this.deliveryConfig.getAssemblyVisitAfterIndex();
        String elementName = DomUtils.getName(element);
        for (ExecutionEventListener executionEventListener : this.contentDeliveryRuntime.getExecutionEventListeners()) {
            executionEventListener.onEvent(new StartFragmentExecutionEvent<Node>(new NodeFragment(element)));
        }
        if (isRoot) {
            elementVisitBefores = visitBeforeTable.get("#document", elementName);
            elementVisitAfters = visitAfterTable.get("#document", elementName);
        } else {
            elementVisitBefores = visitBeforeTable.get((Object)elementName);
            elementVisitAfters = visitAfterTable.get((Object)elementName);
        }
        if (elementVisitBefores != null && !elementVisitBefores.isEmpty()) {
            this.applyAssemblyBefores(element, elementVisitBefores);
        }
        if (this.globalAssemblyBefores != null && !this.globalAssemblyBefores.isEmpty()) {
            this.applyAssemblyBefores(element, this.globalAssemblyBefores);
        }
        for (Node aNodeListCopy : nodeListCopy) {
            Node child = aNodeListCopy;
            if (child.getNodeType() != 1) continue;
            this.assemble((Element)child, false);
        }
        if (elementVisitAfters != null && !elementVisitAfters.isEmpty()) {
            this.applyAssemblyAfters(element, elementVisitAfters);
        }
        if (this.globalAssemblyAfters != null && !this.globalAssemblyAfters.isEmpty()) {
            this.applyAssemblyAfters(element, this.globalAssemblyAfters);
        }
    }

    private void applyAssemblyBefores(Element element, List<ContentHandlerBinding<DOMVisitBefore>> assemblyBefores) {
        NodeFragment nodeFragment = new NodeFragment(element);
        for (ContentHandlerBinding<DOMVisitBefore> configMap : assemblyBefores) {
            ResourceConfig resourceConfig = configMap.getResourceConfig();
            if (!nodeFragment.isMatch(resourceConfig.getSelectorPath(), this.executionContext)) continue;
            for (Object executionEventListener : this.contentDeliveryRuntime.getExecutionEventListeners()) {
                executionEventListener.onEvent(new ResourceTargetingExecutionEvent<Node>(nodeFragment, resourceConfig, VisitSequence.BEFORE, VisitPhase.ASSEMBLY));
            }
            DOMVisitBefore assemblyUnit = (DOMVisitBefore)configMap.getContentHandler();
            try {
                Object executionEventListener;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("(Assembly) Calling visitBefore on element [" + DomUtils.getXPath(element) + "]. Config [" + resourceConfig + "]");
                }
                assemblyUnit.visitBefore(element, this.executionContext);
                executionEventListener = this.contentDeliveryRuntime.getExecutionEventListeners().iterator();
                while (executionEventListener.hasNext()) {
                    ExecutionEventListener executionEventListener2 = (ExecutionEventListener)executionEventListener.next();
                    executionEventListener2.onEvent(new VisitExecutionEvent<Node, DOMVisitBefore>(nodeFragment, configMap, VisitSequence.BEFORE, this.executionContext));
                }
            }
            catch (Throwable e) {
                String errorMsg = "(Assembly) visitBefore failed [" + assemblyUnit.getClass().getName() + "] on [" + this.executionContext.getDocumentSource() + ":" + DomUtils.getXPath(element) + "].";
                this.processVisitorException(nodeFragment, e, configMap, VisitSequence.BEFORE, errorMsg);
            }
        }
    }

    private void applyAssemblyAfters(Element element, List<ContentHandlerBinding<DOMVisitAfter>> elementVisitAfters) {
        if (this.reverseVisitOrderOnVisitAfter.booleanValue()) {
            for (int i = elementVisitAfters.size() - 1; i >= 0; --i) {
                ContentHandlerBinding<DOMVisitAfter> configMap = elementVisitAfters.get(i);
                this.applyAssemblyAfter(element, configMap);
            }
        } else {
            for (ContentHandlerBinding<DOMVisitAfter> configMap : elementVisitAfters) {
                this.applyAssemblyAfter(element, configMap);
            }
        }
    }

    private void applyAssemblyAfter(Element element, ContentHandlerBinding<DOMVisitAfter> visitAfterBinding) {
        NodeFragment nodeFragment = new NodeFragment(element);
        ResourceConfig resourceConfig = visitAfterBinding.getResourceConfig();
        if (!nodeFragment.isMatch(resourceConfig.getSelectorPath(), this.executionContext)) {
            return;
        }
        DOMVisitAfter visitAfter = (DOMVisitAfter)visitAfterBinding.getContentHandler();
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("(Assembly) Calling visitAfter on element [" + DomUtils.getXPath(element) + "]. Config [" + resourceConfig + "]");
            }
            visitAfter.visitAfter(element, this.executionContext);
            for (ExecutionEventListener executionEventListener : this.contentDeliveryRuntime.getExecutionEventListeners()) {
                executionEventListener.onEvent(new VisitExecutionEvent<Node, DOMVisitAfter>(nodeFragment, visitAfterBinding, VisitSequence.AFTER, this.executionContext));
            }
        }
        catch (Throwable e) {
            String errorMsg = "(Assembly) visitAfter failed [" + visitAfter.getClass().getName() + "] on [" + this.executionContext.getDocumentSource() + ":" + DomUtils.getXPath(element) + "].";
            this.processVisitorException(nodeFragment, e, visitAfterBinding, VisitSequence.AFTER, errorMsg);
        }
    }

    private void buildProcessingList(List<ElementProcessor> processingList, Element element, boolean isRoot) {
        ElementProcessor processor;
        List<ContentHandlerBinding<PostFragmentLifecycle>> processingPostFragmentLifecycles;
        List<ContentHandlerBinding<DOMVisitAfter>> processingAfters;
        List<ContentHandlerBinding<DOMVisitBefore>> processingBefores;
        for (ExecutionEventListener executionEventListener : this.contentDeliveryRuntime.getExecutionEventListeners()) {
            executionEventListener.onEvent(new StartFragmentExecutionEvent<Node>(new NodeFragment(element)));
        }
        String elementName = DomUtils.getName(element);
        if (isRoot) {
            processingBefores = this.deliveryConfig.getProcessingVisitBeforeIndex().get("#document", elementName);
            processingAfters = this.deliveryConfig.getProcessingVisitAfterIndex().get("#document", elementName);
            processingPostFragmentLifecycles = this.deliveryConfig.getPostFragmentLifecycleIndex().get("#document", elementName);
        } else {
            processingBefores = this.deliveryConfig.getProcessingVisitBeforeIndex().get((Object)elementName);
            processingAfters = this.deliveryConfig.getProcessingVisitAfterIndex().get((Object)elementName);
            processingPostFragmentLifecycles = this.deliveryConfig.getPostFragmentLifecycleIndex().get((Object)elementName);
        }
        if (processingBefores != null && !processingBefores.isEmpty()) {
            processor = new ElementProcessor(element);
            processor.setVisitBefores(processingBefores);
            processingList.add(processor);
        }
        if (this.globalProcessingBefores != null) {
            processor = new ElementProcessor(element);
            processor.setVisitBefores(this.globalProcessingBefores);
            processingList.add(processor);
        }
        NodeList children = element.getChildNodes();
        int childCount = children.getLength();
        for (int i = 0; i < childCount; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            this.buildProcessingList(processingList, (Element)child, false);
        }
        if (processingAfters != null && !processingAfters.isEmpty()) {
            ElementProcessor processor2 = new ElementProcessor(element);
            processor2.setVisitAfters(processingAfters);
            processingList.add(processor2);
        }
        if (this.globalProcessingAfters != null) {
            ElementProcessor processor3 = new ElementProcessor(element);
            processor3.setVisitAfters(this.globalProcessingAfters);
            processingList.add(processor3);
        }
        if (processingPostFragmentLifecycles != null && !processingPostFragmentLifecycles.isEmpty()) {
            ElementProcessor processor4 = new ElementProcessor(element);
            processor4.setPostFragmentLifecycles(processingPostFragmentLifecycles);
            processingList.add(processor4);
        }
    }

    public void serialize(Node node, Writer writer) throws IOException, SmooksException {
        if (node == null) {
            throw new IllegalArgumentException("null 'doc' arg passed in method call.");
        }
        if (writer == null) {
            throw new IllegalArgumentException("null 'writer' arg passed in method call.");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Starting serialization phase [" + this.executionContext.getTargetProfiles().getBaseProfile() + "]");
        }
        Serializer serializer = new Serializer(node, this.executionContext);
        try {
            serializer.serialize(writer);
        }
        catch (Exception e) {
            throw new SmooksException("Unable to serialize document", (Throwable)e);
        }
    }

    private List<Node> copyList(NodeList nodeList) {
        ArrayList<Node> copy = new ArrayList<Node>(nodeList.getLength());
        int nodeCount = nodeList.getLength();
        for (int i = 0; i < nodeCount; ++i) {
            copy.add(nodeList.item(i));
        }
        return copy;
    }

    private void processVisitorException(Fragment<?> fragment, Throwable error, ContentHandlerBinding<? extends Visitor> configMapping, VisitSequence visitSequence, String errorMsg) throws SmooksException {
        for (ExecutionEventListener executionEventListener : this.executionContext.getContentDeliveryRuntime().getExecutionEventListeners()) {
            executionEventListener.onEvent(new VisitExecutionEvent(fragment, configMapping, visitSequence, this.executionContext, error));
        }
        this.executionContext.setTerminationError(error);
        if (this.terminateOnVisitorException.booleanValue()) {
            if (error instanceof SmooksException) {
                throw (SmooksException)error;
            }
            throw new SmooksException(errorMsg, error);
        }
        LOGGER.debug(errorMsg, error);
    }

    private class ElementProcessor {
        private final Element element;
        private List<ContentHandlerBinding<DOMVisitBefore>> visitBefores;
        private List<ContentHandlerBinding<DOMVisitAfter>> visitAfters;
        private List<ContentHandlerBinding<PostFragmentLifecycle>> postFragmentLifecycles;

        private ElementProcessor(Element element) {
            this.element = element;
        }

        private void setVisitBefores(List<ContentHandlerBinding<DOMVisitBefore>> visitBefores) {
            this.visitBefores = visitBefores;
        }

        private void setVisitAfters(List<ContentHandlerBinding<DOMVisitAfter>> visitAfters) {
            this.visitAfters = visitAfters;
        }

        public void setPostFragmentLifecycles(List<ContentHandlerBinding<PostFragmentLifecycle>> postFragmentLifecycles) {
            this.postFragmentLifecycles = postFragmentLifecycles;
        }

        private void process(ExecutionContext executionContext) {
            if (this.visitBefores != null) {
                for (ContentHandlerBinding<DOMVisitBefore> visitBefore : this.visitBefores) {
                    this.processMapping(executionContext, visitBefore, VisitSequence.BEFORE);
                }
            } else if (this.visitAfters != null) {
                int loopLength = this.visitAfters.size();
                if (SmooksDOMFilter.this.reverseVisitOrderOnVisitAfter.booleanValue()) {
                    for (int i = loopLength - 1; i >= 0; --i) {
                        ContentHandlerBinding<DOMVisitAfter> configMap = this.visitAfters.get(i);
                        this.processMapping(executionContext, configMap, VisitSequence.AFTER);
                    }
                } else {
                    for (ContentHandlerBinding<DOMVisitAfter> visitAfter : this.visitAfters) {
                        this.processMapping(executionContext, visitAfter, VisitSequence.AFTER);
                    }
                }
            } else {
                for (ContentHandlerBinding<PostFragmentLifecycle> postFragmentLifecycle : this.postFragmentLifecycles) {
                    this.processMapping(executionContext, postFragmentLifecycle, VisitSequence.CLEAN);
                }
            }
        }

        private void processMapping(ExecutionContext executionContext, ContentHandlerBinding<? extends Visitor> visitorBinding, VisitSequence visitSequence) {
            NodeFragment nodeFragment = new NodeFragment(this.element);
            ResourceConfig resourceConfig = visitorBinding.getResourceConfig();
            if (!nodeFragment.isMatch(resourceConfig.getSelectorPath(), executionContext)) {
                return;
            }
            if (visitSequence == VisitSequence.BEFORE) {
                for (Object executionEventListener : SmooksDOMFilter.this.contentDeliveryRuntime.getExecutionEventListeners()) {
                    executionEventListener.onEvent(new ResourceTargetingExecutionEvent<Node>(nodeFragment, resourceConfig, VisitSequence.BEFORE, new Object[0]));
                }
                DOMVisitBefore visitor = (DOMVisitBefore)visitorBinding.getContentHandler();
                try {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Applying processing resource [" + resourceConfig + "] to element [" + DomUtils.getXPath(this.element) + "] before applying resources to its child elements.");
                    }
                    visitor.visitBefore(this.element, executionContext);
                    for (ExecutionEventListener executionEventListener : SmooksDOMFilter.this.contentDeliveryRuntime.getExecutionEventListeners()) {
                        executionEventListener.onEvent(new VisitExecutionEvent<Node, Visitor>(nodeFragment, visitorBinding, VisitSequence.BEFORE, executionContext));
                    }
                }
                catch (Throwable e) {
                    String errorMsg = "Failed to apply processing unit [" + visitor.getClass().getName() + "] to [" + executionContext.getDocumentSource() + ":" + DomUtils.getXPath(this.element) + "].";
                    SmooksDOMFilter.this.processVisitorException(nodeFragment, e, (ContentHandlerBinding<? extends Visitor>)visitorBinding, VisitSequence.BEFORE, errorMsg);
                }
            } else if (visitSequence == VisitSequence.AFTER) {
                for (Object executionEventListener : SmooksDOMFilter.this.contentDeliveryRuntime.getExecutionEventListeners()) {
                    executionEventListener.onEvent(new ResourceTargetingExecutionEvent<Node>(nodeFragment, resourceConfig, VisitSequence.AFTER, new Object[0]));
                }
                DOMVisitAfter visitor = (DOMVisitAfter)visitorBinding.getContentHandler();
                try {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Applying processing resource [" + resourceConfig + "] to element [" + DomUtils.getXPath(this.element) + "] after applying resources to its child elements.");
                    }
                    visitor.visitAfter(this.element, executionContext);
                    for (ExecutionEventListener executionEventListener : SmooksDOMFilter.this.contentDeliveryRuntime.getExecutionEventListeners()) {
                        executionEventListener.onEvent(new VisitExecutionEvent<Node, Visitor>(nodeFragment, visitorBinding, VisitSequence.AFTER, executionContext));
                    }
                }
                catch (Throwable e) {
                    String errorMsg = "Failed to apply processing unit [" + visitor.getClass().getName() + "] to [" + executionContext.getDocumentSource() + ":" + DomUtils.getXPath(this.element) + "].";
                    SmooksDOMFilter.this.processVisitorException(nodeFragment, e, (ContentHandlerBinding<? extends Visitor>)visitorBinding, VisitSequence.BEFORE, errorMsg);
                }
            } else if (visitSequence == VisitSequence.CLEAN) {
                for (ExecutionEventListener executionEventListener : SmooksDOMFilter.this.contentDeliveryRuntime.getExecutionEventListeners()) {
                    executionEventListener.onEvent(new ResourceTargetingExecutionEvent<Node>(nodeFragment, resourceConfig, VisitSequence.CLEAN, new Object[0]));
                }
                ContentHandler contentHandler = visitorBinding.getContentHandler();
                if (contentHandler instanceof PostFragmentLifecycle) {
                    PostFragmentLifecycle visitor = (PostFragmentLifecycle)contentHandler;
                    try {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Cleaning up processing resource [" + resourceConfig + "] that was targeted to element [" + DomUtils.getXPath(this.element) + "].");
                        }
                        SmooksDOMFilter.this.lifecycleManager.applyPhase((Object)visitor, (LifecyclePhase)new PostFragmentPhase(nodeFragment, executionContext));
                        for (ExecutionEventListener executionEventListener : SmooksDOMFilter.this.contentDeliveryRuntime.getExecutionEventListeners()) {
                            executionEventListener.onEvent(new VisitExecutionEvent<Node, Visitor>(nodeFragment, visitorBinding, VisitSequence.CLEAN, executionContext));
                        }
                    }
                    catch (Throwable e) {
                        String errorMsg = "Failed to clean up [" + visitor.getClass().getName() + "]. Targeted at [" + executionContext.getDocumentSource() + ":" + DomUtils.getXPath(this.element) + "].";
                        SmooksDOMFilter.this.processVisitorException(nodeFragment, e, (ContentHandlerBinding<? extends Visitor>)visitorBinding, VisitSequence.CLEAN, errorMsg);
                    }
                }
            }
        }
    }
}

