/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.delivery;

import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksException;
import org.smooks.api.TypedKey;
import org.smooks.engine.delivery.AbstractParser;
import org.smooks.engine.delivery.replay.EndElementEvent;
import org.smooks.engine.delivery.replay.SAXEventReplay;
import org.smooks.engine.delivery.replay.StartElementEvent;
import org.smooks.engine.xml.NamespaceManager;
import org.smooks.namespace.NamespaceDeclarationStack;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DefaultHandler2;

public abstract class SmooksContentHandler
extends DefaultHandler2
implements SAXEventReplay {
    private static final TypedKey<SmooksContentHandler> SMOOKS_CONTENT_HANDLER_TYPED_KEY = TypedKey.of();
    private final ExecutionContext executionContext;
    private final SmooksContentHandler parentContentHandler;
    private SmooksContentHandler nestedContentHandler;
    private NamespaceDeclarationStack namespaceDeclarationStack;
    private boolean endReplayed;
    private SAXEventReplay lastEvent;
    private final StartElementEvent startEvent = new StartElementEvent();
    private final EndElementEvent endEvent = new EndElementEvent();
    private int depth;

    public SmooksContentHandler(ExecutionContext executionContext, SmooksContentHandler parentContentHandler) {
        this.executionContext = executionContext;
        this.parentContentHandler = parentContentHandler;
        this.attachHandler();
        if (parentContentHandler != null) {
            parentContentHandler.nestedContentHandler = this;
        }
    }

    public NamespaceDeclarationStack getNamespaceDeclarationStack() {
        if (this.namespaceDeclarationStack == null) {
            this.namespaceDeclarationStack = (NamespaceDeclarationStack)this.executionContext.get(NamespaceManager.NAMESPACE_DECLARATION_STACK_TYPED_KEY);
            if (this.namespaceDeclarationStack == null) {
                throw new IllegalStateException("NamespaceDeclarationStack instance not set on ExecutionContext.");
            }
        }
        return this.namespaceDeclarationStack;
    }

    public void replayStartElement() {
        this.parentContentHandler.replay(this);
    }

    @Override
    public final void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.getNamespaceDeclarationStack().pushNamespaces(qName, uri, attributes);
        this.startEvent.set(uri, localName, qName, attributes);
        this.lastEvent = this.startEvent;
        ++this.depth;
        this.startElement(this.startEvent);
        if (this.nestedContentHandler != null) {
            this.replay(this.nestedContentHandler);
        }
    }

    public abstract void startElement(StartElementEvent var1) throws SAXException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            this.endEvent.set(uri, localName, qName);
            this.lastEvent = this.endEvent;
            this.endElement(this.endEvent);
            --this.depth;
        }
        finally {
            if (!this.endReplayed && this.depth == 0 && this.parentContentHandler != null) {
                this.endReplayed = true;
                this.replay(this.parentContentHandler);
                XMLReader xmlReader = AbstractParser.getXMLReader(this.executionContext);
                xmlReader.setContentHandler(this.parentContentHandler);
                this.parentContentHandler.resetNestedContentHandler();
            }
        }
        this.getNamespaceDeclarationStack().popNamespaces();
    }

    public abstract void endElement(EndElementEvent var1) throws SAXException;

    @Override
    public void replay(ContentHandler handler) throws SmooksException {
        if (this.lastEvent != null) {
            this.lastEvent.replay(handler);
        }
    }

    private void attachHandler() {
        this.executionContext.put(SMOOKS_CONTENT_HANDLER_TYPED_KEY, (Object)this);
    }

    public static SmooksContentHandler getHandler(ExecutionContext executionContext) {
        return (SmooksContentHandler)executionContext.get(SMOOKS_CONTENT_HANDLER_TYPED_KEY);
    }

    public void detachHandler() {
        this.executionContext.remove(SMOOKS_CONTENT_HANDLER_TYPED_KEY);
    }

    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public SmooksContentHandler getParentContentHandler() {
        return this.parentContentHandler;
    }

    public SmooksContentHandler getNestedContentHandler() {
        return this.nestedContentHandler;
    }

    public void resetNestedContentHandler() {
        this.nestedContentHandler = null;
    }

    public abstract void close();
}

