/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.delivery;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.smooks.api.delivery.ReaderPool;
import org.xml.sax.XMLReader;

public class DynamicReaderPool
implements ReaderPool {
    private final AtomicReference<AtomicReferenceArray<Optional<XMLReader>>> xmlReaderPoolReference = new AtomicReference();

    public DynamicReaderPool() {
        this.xmlReaderPoolReference.set(new AtomicReferenceArray(16));
    }

    public XMLReader borrowXMLReader() {
        AtomicReferenceArray<Optional<XMLReader>> xmlReaderPool = this.xmlReaderPoolReference.get();
        for (int i = 0; i < xmlReaderPool.length(); ++i) {
            Optional<XMLReader> xmlReader = xmlReaderPool.get(i);
            if (xmlReader == null || !(xmlReader = xmlReaderPool.getAndSet(i, Optional.empty())).isPresent()) continue;
            return xmlReader.get();
        }
        return null;
    }

    public void returnXMLReader(XMLReader xmlReader) {
        AtomicReferenceArray<Optional<XMLReader>> xmlReaderPool = this.xmlReaderPoolReference.get();
        for (int i = 0; i < xmlReaderPool.length(); ++i) {
            Optional<XMLReader> optionalXMLReader = Optional.of(xmlReader);
            if (!xmlReaderPool.compareAndSet(i, Optional.empty(), optionalXMLReader) && !xmlReaderPool.compareAndSet(i, null, optionalXMLReader)) continue;
            return;
        }
        this.xmlReaderPoolReference.compareAndSet(xmlReaderPool, new AtomicReferenceArray(xmlReaderPool.length() * 2));
        this.returnXMLReader(xmlReader);
    }

    public Map<String, String> getProperties() {
        AtomicReferenceArray<Optional<XMLReader>> xmlReaderPool = this.xmlReaderPoolReference.get();
        HashMap<String, String> properties = new HashMap<String, String>(3);
        properties.put("readerPoolSize", String.valueOf(xmlReaderPool.length()));
        int unallocatedReaders = 0;
        int activeReaders = 0;
        for (int i = 0; i < xmlReaderPool.length(); ++i) {
            Optional<XMLReader> xmlReader = xmlReaderPool.get(i);
            if (xmlReader == null || xmlReader.isPresent()) {
                ++unallocatedReaders;
                continue;
            }
            ++activeReaders;
        }
        properties.put("unallocatedReaders", String.valueOf(unallocatedReaders));
        properties.put("activeReaders", String.valueOf(activeReaders));
        return properties;
    }
}

