/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.delivery;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.api.Registry;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.delivery.ContentDeliveryConfig;
import org.smooks.api.delivery.ContentDeliveryConfigBuilder;
import org.smooks.api.delivery.ContentHandler;
import org.smooks.api.delivery.ContentHandlerBinding;
import org.smooks.api.delivery.ContentHandlerFactory;
import org.smooks.api.delivery.FilterProvider;
import org.smooks.api.delivery.ResourceConfigExpander;
import org.smooks.api.delivery.VisitorAppender;
import org.smooks.api.delivery.event.ContentDeliveryConfigExecutionEvent;
import org.smooks.api.lifecycle.ContentDeliveryConfigLifecycle;
import org.smooks.api.lifecycle.LifecycleManager;
import org.smooks.api.lifecycle.LifecyclePhase;
import org.smooks.api.profile.ProfileSet;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.config.xpath.SelectorStep;
import org.smooks.api.resource.visitor.Visitor;
import org.smooks.assertion.AssertArgument;
import org.smooks.engine.delivery.AnyFilterType;
import org.smooks.engine.delivery.DefaultContentHandlerBinding;
import org.smooks.engine.delivery.JavaContentHandlerFactory;
import org.smooks.engine.delivery.event.DefaultContentDeliveryConfigExecutionEvent;
import org.smooks.engine.lifecycle.ContentDeliveryBuilderCreatedLifecyclePhase;
import org.smooks.engine.lifecycle.ContentDeliveryConfigCreatedLifecyclePhase;
import org.smooks.engine.lifecycle.ContentHandlersCreatedLifecyclePhase;
import org.smooks.engine.lookup.ContentHandlerFactoryLookup;
import org.smooks.engine.lookup.GlobalParamsLookup;
import org.smooks.engine.lookup.InstanceLookup;
import org.smooks.engine.lookup.LifecycleManagerLookup;
import org.smooks.engine.lookup.ResourceConfigsProfileSetLookup;
import org.smooks.engine.resource.config.DefaultResourceConfigSortComparator;
import org.smooks.engine.resource.config.xpath.step.ElementSelectorStep;

public class DefaultContentDeliveryConfigBuilder
implements ContentDeliveryConfigBuilder {
    protected static final String LINE_SEPARATOR = System.lineSeparator();
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultContentDeliveryConfigBuilder.class);
    private final ProfileSet profileSet;
    private final Registry registry;
    private final List<ResourceConfig> resourceConfigs = new ArrayList<ResourceConfig>();
    private final Map<String, List<ResourceConfig>> resourceConfigTable = new LinkedHashMap<String, List<ResourceConfig>>();
    private final List<ContentHandlerBinding<Visitor>> visitorBindings = new ArrayList<ContentHandlerBinding<Visitor>>();
    private final List<ContentDeliveryConfigExecutionEvent> configBuilderEvents = new ArrayList<ContentDeliveryConfigExecutionEvent>();
    private final List<FilterProvider> filterProviders;
    private final LifecycleManager lifecycleManager;
    private volatile ContentDeliveryConfig contentDeliveryConfig;

    public DefaultContentDeliveryConfigBuilder(ProfileSet profileSet, Registry registry, List<FilterProvider> filterProviders) {
        AssertArgument.isNotNull((Object)profileSet, (String)"profileSet");
        AssertArgument.isNotNull((Object)registry, (String)"registry");
        AssertArgument.isNotNull(filterProviders, (String)"filterProviders");
        this.profileSet = profileSet;
        this.registry = registry;
        this.filterProviders = filterProviders;
        this.lifecycleManager = (LifecycleManager)registry.lookup((Function)new LifecycleManagerLookup());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ContentDeliveryConfig build(List<ContentHandlerBinding<Visitor>> extendedContentHandlerBindings) {
        if (this.contentDeliveryConfig != null) return this.contentDeliveryConfig;
        Class<DefaultContentDeliveryConfigBuilder> clazz = DefaultContentDeliveryConfigBuilder.class;
        synchronized (DefaultContentDeliveryConfigBuilder.class) {
            if (this.contentDeliveryConfig != null) return this.contentDeliveryConfig;
            this.load(this.profileSet);
            this.fireEvent(Event.CONTENT_DELIVERY_BUILDER_CREATED);
            this.contentDeliveryConfig = this.buildConfig(extendedContentHandlerBindings);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.contentDeliveryConfig;
        }
    }

    protected ContentDeliveryConfig buildConfig(List<ContentHandlerBinding<Visitor>> extendedContentHandlerBindings) {
        if (extendedContentHandlerBindings != null) {
            this.visitorBindings.addAll(extendedContentHandlerBindings);
        }
        FilterProvider filterProvider = this.getFilterProvider();
        LOGGER.debug("Activating [{}] filter", (Object)filterProvider.getName());
        this.configBuilderEvents.add(new DefaultContentDeliveryConfigExecutionEvent("SAX/DOM support characteristics of the Resource Configuration map:" + LINE_SEPARATOR + this.getResourceFilterCharacteristics()));
        this.configBuilderEvents.add(new DefaultContentDeliveryConfigExecutionEvent(String.format("Activating [%s] filter", filterProvider.getName())));
        ContentDeliveryConfig contentDeliveryConfig = filterProvider.createContentDeliveryConfig(this.visitorBindings, this.registry, this.resourceConfigTable, this.configBuilderEvents);
        this.fireEvent(Event.CONTENT_DELIVERY_CONFIG_CREATED);
        return contentDeliveryConfig;
    }

    protected FilterProvider getFilterProvider() {
        AnyFilterType anyFilterType;
        List candidateFilterProviders = this.filterProviders.stream().filter(s -> s.isProvider(this.visitorBindings)).collect(Collectors.toList());
        String filterTypeParam = (String)((GlobalParamsLookup.ParameterAccessor)this.registry.lookup((Function)new GlobalParamsLookup())).getParameterValue("stream.filter.type");
        if (filterTypeParam.equals((anyFilterType = new AnyFilterType()).getName()) && candidateFilterProviders.isEmpty()) {
            throw new SmooksConfigException("Ambiguous Resource Config set. All content handlers must support processing on the SAX and/or DOM Filter:" + LINE_SEPARATOR + this.getResourceFilterCharacteristics());
        }
        if (filterTypeParam.equals(anyFilterType.getName())) {
            return (FilterProvider)candidateFilterProviders.get(0);
        }
        Optional<FilterProvider> filterProviderOptional = candidateFilterProviders.stream().filter(c -> c.getName().equalsIgnoreCase(filterTypeParam)).findFirst();
        if (filterProviderOptional.isPresent()) {
            return filterProviderOptional.get();
        }
        throw new SmooksConfigException(String.format("The configured filter [%s] cannot be used: %s filters can be used for the given set of visitors. Turn on debug logging for more information", filterTypeParam, Arrays.toString(candidateFilterProviders.stream().map(FilterProvider::getName).collect(Collectors.toList()).toArray())));
    }

    protected String getResourceFilterCharacteristics() {
        StringBuffer stringBuf = new StringBuffer();
        ArrayList<ContentHandler> printedHandlers = new ArrayList<ContentHandler>();
        stringBuf.append("\t\tDOM   SAX    Resource  ('x' equals supported)" + LINE_SEPARATOR);
        stringBuf.append("\t\t---------------------------------------------------------------------" + LINE_SEPARATOR);
        for (ContentHandlerBinding<Visitor> contentHandlerBinding : this.visitorBindings) {
            this.printHandlerCharacteristics(contentHandlerBinding, stringBuf, printedHandlers);
        }
        stringBuf.append(LINE_SEPARATOR).append(LINE_SEPARATOR);
        return stringBuf.toString();
    }

    protected void printHandlerCharacteristics(ContentHandlerBinding<Visitor> contentHandlerBinding, StringBuffer stringBuf, List<ContentHandler> printedHandlers) {
        ContentHandler handler = contentHandlerBinding.getContentHandler();
        if (printedHandlers.contains(handler)) {
            return;
        }
        printedHandlers.add(handler);
        stringBuf.append("\t\t ");
        Map<String, Boolean> supportedFilterProviders = this.getOrderedSupportedFilterProviders(contentHandlerBinding);
        for (Map.Entry<String, Boolean> supportedFilterProvider : supportedFilterProviders.entrySet()) {
            stringBuf.append(supportedFilterProvider.getValue() != false ? supportedFilterProvider.getKey() : " ").append("     ");
        }
        stringBuf.append(contentHandlerBinding.getResourceConfig()).append(LINE_SEPARATOR);
    }

    private Map<String, Boolean> getOrderedSupportedFilterProviders(ContentHandlerBinding<Visitor> contentHandlerBinding) {
        LinkedHashMap<String, Boolean> supportedFilterProviders = new LinkedHashMap<String, Boolean>();
        this.filterProviders.forEach(s -> supportedFilterProviders.put(s.getName(), s.isProvider(Collections.singletonList(contentHandlerBinding))));
        return supportedFilterProviders;
    }

    protected void load(ProfileSet profileSet) {
        this.resourceConfigs.clear();
        this.resourceConfigs.addAll(Arrays.asList((ResourceConfig[])this.registry.lookup((Function)new ResourceConfigsProfileSetLookup(this.registry, profileSet))));
        this.buildResourceConfigTable(this.resourceConfigs);
        this.sortResourceConfigs(this.resourceConfigTable, profileSet);
        this.extractContentHandlers();
        this.fireEvent(Event.CONTENT_HANDLERS_CREATED);
        if (LOGGER.isDebugEnabled()) {
            this.logResourceConfig(profileSet);
        }
    }

    protected void logResourceConfig(ProfileSet profileSet) {
        LOGGER.debug("==================================================================================================");
        LOGGER.debug("Resource configuration (sorted) for profile [" + profileSet.getBaseProfile() + "].  Sub Profiles: [" + profileSet + "]");
        Iterator<Map.Entry<String, List<ResourceConfig>>> configurations = this.resourceConfigTable.entrySet().iterator();
        int i = 0;
        while (configurations.hasNext()) {
            Map.Entry<String, List<ResourceConfig>> entry = configurations.next();
            List<ResourceConfig> resources = entry.getValue();
            LOGGER.debug(i + ") " + entry.getKey());
            for (int ii = 0; ii < resources.size(); ++ii) {
                LOGGER.debug("\t(" + ii + ") " + resources.get(ii));
            }
        }
        LOGGER.debug("==================================================================================================");
    }

    protected void buildResourceConfigTable(List<ResourceConfig> resourceConfigs) {
        for (ResourceConfig resourceConfig : resourceConfigs) {
            this.addResourceConfig(resourceConfig);
        }
    }

    protected void addResourceConfig(ResourceConfig config) {
        String target = config.getSelectorPath().getSelector();
        if (config.getSelectorPath().size() > 1) {
            for (int i = config.getSelectorPath().size(); i > 0; --i) {
                SelectorStep selectorStep = (SelectorStep)config.getSelectorPath().get(i - 1);
                if (!(selectorStep instanceof ElementSelectorStep)) continue;
                target = ((ElementSelectorStep)selectorStep).getQName().getLocalPart();
                break;
            }
        }
        this.addResourceConfig(target, config);
    }

    protected void addResourceConfig(String element, ResourceConfig resourceConfig) {
        List resourceConfigs;
        if (!this.resourceConfigs.contains(resourceConfig)) {
            this.resourceConfigs.add(resourceConfig);
        }
        if (!(resourceConfigs = this.resourceConfigTable.computeIfAbsent(element, k -> new ArrayList())).contains(resourceConfig)) {
            resourceConfigs.add(resourceConfig);
        }
    }

    protected void sortResourceConfigs(Map<String, List<ResourceConfig>> table, ProfileSet profileSet) {
        String sortParam = (String)((GlobalParamsLookup.ParameterAccessor)this.registry.lookup((Function)new GlobalParamsLookup())).getParameterValue("sort.resources");
        if (sortParam != null && sortParam.trim().equalsIgnoreCase("true")) {
            for (Map.Entry<String, List<ResourceConfig>> entry : table.entrySet()) {
                List<ResourceConfig> markupElResourceConfigs = entry.getValue();
                ResourceConfig[] resourceConfigs = markupElResourceConfigs.toArray(new ResourceConfig[0]);
                DefaultResourceConfigSortComparator sortComparator = new DefaultResourceConfigSortComparator(profileSet);
                Arrays.sort(resourceConfigs, sortComparator);
                entry.setValue(new ArrayList<ResourceConfig>(Arrays.asList(resourceConfigs)));
            }
        }
    }

    protected void extractContentHandlers() {
        ContentHandlerExtractionStrategy contentHandlerExtractionStrategy = new ContentHandlerExtractionStrategy(this.registry);
        ResourceConfigTableIterator resourceConfigTableIterator = new ResourceConfigTableIterator(contentHandlerExtractionStrategy);
        resourceConfigTableIterator.iterate();
    }

    protected void logExecutionEvent(ResourceConfig resourceConfig, String message) {
        this.configBuilderEvents.add(new DefaultContentDeliveryConfigExecutionEvent(resourceConfig, message));
    }

    protected void fireEvent(Event event) {
        Object lifecyclePhase;
        switch (event) {
            case CONTENT_HANDLERS_CREATED: {
                lifecyclePhase = new ContentHandlersCreatedLifecyclePhase();
                break;
            }
            case CONTENT_DELIVERY_BUILDER_CREATED: {
                lifecyclePhase = new ContentDeliveryBuilderCreatedLifecyclePhase();
                break;
            }
            case CONTENT_DELIVERY_CONFIG_CREATED: {
                lifecyclePhase = new ContentDeliveryConfigCreatedLifecyclePhase();
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        this.lifecycleManager.applyPhase(((Map)this.registry.lookup(new InstanceLookup<ContentDeliveryConfigLifecycle>(ContentDeliveryConfigLifecycle.class))).values(), (LifecyclePhase)lifecyclePhase);
    }

    private static interface ResourceConfigStrategy {
        public void applyStrategy(ResourceConfig var1);
    }

    private class ResourceConfigTableIterator {
        private final ResourceConfigStrategy strategy;

        private ResourceConfigTableIterator(ResourceConfigStrategy strategy) {
            this.strategy = strategy;
        }

        private void iterate() {
            for (ResourceConfig resourceConfig : DefaultContentDeliveryConfigBuilder.this.resourceConfigs) {
                this.strategy.applyStrategy(resourceConfig);
            }
        }
    }

    private final class ContentHandlerExtractionStrategy
    implements ResourceConfigStrategy {
        private final Registry registry;

        private ContentHandlerExtractionStrategy(Registry registry) {
            this.registry = registry;
        }

        @Override
        public void applyStrategy(ResourceConfig resourceConfig) {
            this.applyContentDeliveryUnitStrategy(resourceConfig);
        }

        private boolean applyContentDeliveryUnitStrategy(ResourceConfig resourceConfig) {
            if (resourceConfig.isJavaResource()) {
                ContentHandlerFactory contentHandlerFactory = (ContentHandlerFactory)this.registry.lookup((Function)new ContentHandlerFactoryLookup("class"));
                if (contentHandlerFactory == null) {
                    throw new SmooksConfigException(String.format("%s not found for content of type [class]. Hint: ensure the Smooks application context has the correct class loader set", ContentHandlerFactory.class.getName()));
                }
                return this.addContentHandler(resourceConfig, contentHandlerFactory);
            }
            String resourceType = resourceConfig.getResourceType();
            ContentHandlerFactory<?> contentHandlerFactory = this.tryCreateCreator(resourceType);
            if (contentHandlerFactory != null) {
                if (!(contentHandlerFactory instanceof JavaContentHandlerFactory)) {
                    return this.addContentHandler(resourceConfig, contentHandlerFactory);
                }
            } else if (resourceType != null) {
                DefaultContentDeliveryConfigBuilder.this.logExecutionEvent(resourceConfig, "Unable to create ContentHandler class instance for resource.  This is probably because there's no " + ContentHandlerFactory.class.getSimpleName() + " implementation for resource type '" + resourceType + "' available on the classpath.");
            }
            return false;
        }

        private ContentHandlerFactory<?> tryCreateCreator(String resourceType) {
            if (resourceType == null || resourceType.trim().isEmpty()) {
                LOGGER.debug("Request to attempt ContentHandlerFactory creation based on a null/empty resource type.");
                return null;
            }
            return (ContentHandlerFactory)this.registry.lookup((Function)new ContentHandlerFactoryLookup(resourceType));
        }

        private boolean addContentHandler(ResourceConfig resourceConfig, ContentHandlerFactory<?> contentHandlerFactory) {
            List additionalConfigs;
            Object contentHandler;
            try {
                contentHandler = contentHandlerFactory.create(resourceConfig);
            }
            catch (SmooksConfigException e) {
                throw e;
            }
            catch (Throwable thrown) {
                LOGGER.error("ContentHandlerFactory [{}] unable to create content handler for resource [{}] ", (Object)contentHandlerFactory.getClass().getName(), (Object)resourceConfig);
                throw thrown;
            }
            if (contentHandler instanceof Visitor) {
                DefaultContentDeliveryConfigBuilder.this.visitorBindings.add(new DefaultContentHandlerBinding<Visitor>((Visitor)contentHandler, resourceConfig));
            }
            if (contentHandler instanceof ResourceConfigExpander && (additionalConfigs = ((ResourceConfigExpander)contentHandler).expandConfigurations()) != null && !additionalConfigs.isEmpty()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Adding expansion resource configurations created by: " + resourceConfig);
                    for (ResourceConfig additionalConfig : additionalConfigs) {
                        LOGGER.debug("\tAdding expansion resource configuration: " + additionalConfig);
                    }
                }
                this.processExpansionConfigurations(additionalConfigs);
            }
            if (contentHandler instanceof VisitorAppender) {
                DefaultContentDeliveryConfigBuilder.this.visitorBindings.addAll(((VisitorAppender)contentHandler).addVisitors());
            }
            return true;
        }

        private void processExpansionConfigurations(List<ResourceConfig> additionalConfigs) {
            for (ResourceConfig resourceConfig : additionalConfigs) {
                this.registry.registerResourceConfig(resourceConfig);
                if (this.applyContentDeliveryUnitStrategy(resourceConfig)) continue;
                DefaultContentDeliveryConfigBuilder.this.addResourceConfig(resourceConfig);
            }
        }
    }

    protected static enum Event {
        CONTENT_HANDLERS_CREATED,
        CONTENT_DELIVERY_BUILDER_CREATED,
        CONTENT_DELIVERY_CONFIG_CREATED;

    }
}

