/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.delivery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.api.ExecutionContext;
import org.smooks.api.Registry;
import org.smooks.api.delivery.ContentDeliveryConfig;
import org.smooks.api.delivery.ContentHandlerBinding;
import org.smooks.api.delivery.ContentHandlerFactory;
import org.smooks.api.delivery.FilterBypass;
import org.smooks.api.delivery.event.ContentDeliveryConfigExecutionEvent;
import org.smooks.api.lifecycle.PostExecutionLifecycle;
import org.smooks.api.lifecycle.PreExecutionLifecycle;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.visitor.Visitor;
import org.smooks.engine.delivery.ContentHandlerBindingIndex;
import org.smooks.engine.lookup.ContentHandlerFactoryLookup;
import org.smooks.engine.lookup.GlobalParamsLookup;
import org.smooks.engine.resource.config.xpath.IndexedSelectorPath;
import org.smooks.engine.resource.config.xpath.step.DocumentSelectorStep;

public abstract class AbstractContentDeliveryConfig
implements ContentDeliveryConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractContentDeliveryConfig.class);
    protected Registry registry;
    protected Map<String, List<ResourceConfig>> resourceConfigTable = new LinkedHashMap<String, List<ResourceConfig>>();
    protected final Map objectsTable = new LinkedHashMap();
    protected final List<ContentDeliveryConfigExecutionEvent> configBuilderEvents = new ArrayList<ContentDeliveryConfigExecutionEvent>();
    protected final Set<PreExecutionLifecycle> preExecutionLifecycles = new LinkedHashSet<PreExecutionLifecycle>();
    protected final Set<PostExecutionLifecycle> postExecutionLifecycles = new LinkedHashSet<PostExecutionLifecycle>();
    protected Boolean isDefaultSerializationOn;
    protected Boolean closeSource;
    protected Boolean closeSink;

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public List<ResourceConfig> getResourceConfigs(String selector) {
        return this.resourceConfigTable.get(selector);
    }

    public void setResourceConfigs(Map<String, List<ResourceConfig>> resourceConfigTable) {
        this.resourceConfigTable = resourceConfigTable;
    }

    public Map<String, List<ResourceConfig>> getResourceConfigs() {
        return this.resourceConfigTable;
    }

    public List<?> getObjects(String selector) {
        ArrayList<Object> objects = (ArrayList<Object>)this.objectsTable.get(selector);
        if (objects == null) {
            List<ResourceConfig> resourceConfigs = this.resourceConfigTable.get(selector);
            if (resourceConfigs != null && resourceConfigs.size() > 0) {
                objects = new ArrayList<Object>(resourceConfigs.size());
                if (this.registry == null) {
                    throw new IllegalStateException("Call to getObjects() before the setRegistry() was called.");
                }
                for (ResourceConfig resourceConfig : resourceConfigs) {
                    objects.add(((ContentHandlerFactory)this.registry.lookup((Function)new ContentHandlerFactoryLookup("class"))).create(resourceConfig));
                }
            } else {
                objects = Collections.EMPTY_LIST;
            }
            this.objectsTable.put(selector, objects);
        }
        return objects;
    }

    public List<ContentDeliveryConfigExecutionEvent> getContentDeliveryConfigExecutionEvents() {
        return this.configBuilderEvents;
    }

    public boolean isDefaultSerializationOn() {
        if (this.isDefaultSerializationOn == null) {
            this.isDefaultSerializationOn = Boolean.valueOf((String)((GlobalParamsLookup.ParameterAccessor)this.registry.lookup((Function)new GlobalParamsLookup())).getParameterValue("default.serialization.on"));
        }
        return this.isDefaultSerializationOn;
    }

    public <T extends Visitor> void addToExecutionLifecycleSets(ContentHandlerBindingIndex<T> contentHandlerBindingIndex) {
        for (List<ContentHandlerBinding<T>> contentHandlerBindings : contentHandlerBindingIndex.values()) {
            for (ContentHandlerBinding<T> contentHandlerBinding : contentHandlerBindings) {
                if (contentHandlerBinding.getContentHandler() instanceof PreExecutionLifecycle) {
                    this.preExecutionLifecycles.add((PreExecutionLifecycle)contentHandlerBinding.getContentHandler());
                }
                if (!(contentHandlerBinding.getContentHandler() instanceof PostExecutionLifecycle)) continue;
                this.postExecutionLifecycles.add((PostExecutionLifecycle)contentHandlerBinding.getContentHandler());
            }
        }
    }

    public void executeHandlerInit(ExecutionContext executionContext) {
        for (PreExecutionLifecycle preExecutionLifecycle : this.preExecutionLifecycles) {
            preExecutionLifecycle.onPreExecution(executionContext);
        }
    }

    public void executeHandlerCleanup(ExecutionContext executionContext) {
        for (PostExecutionLifecycle postExecutionLifecycle : this.postExecutionLifecycles) {
            try {
                postExecutionLifecycle.onPostExecution(executionContext);
            }
            catch (Throwable t) {
                LOGGER.error("Error during Visit handler cleanup.", t);
            }
        }
    }

    protected FilterBypass getFilterBypass(ContentHandlerBindingIndex<?> ... contentHandlerBindingIndexes) {
        for (ContentHandlerBindingIndex<?> contentHandlerBindingIndex : contentHandlerBindingIndexes) {
            Collection<List<ContentHandlerBinding<?>>> contentHandlerBindings = contentHandlerBindingIndex.values();
            long userContentHandlerBindingsCount = contentHandlerBindings.stream().flatMap(l -> l.stream().filter(c -> !c.getResourceConfig().isSystem())).count();
            if (userContentHandlerBindingsCount <= 1L) continue;
            return null;
        }
        HashSet<FilterBypass> bypassSet = new HashSet<FilterBypass>();
        for (ContentHandlerBindingIndex<?> contentHandlerBindingIndex : contentHandlerBindingIndexes) {
            Collection<List<ContentHandlerBinding<?>>> contentHandlerBindings = contentHandlerBindingIndex.values();
            long userContentHandlerBindingsCount = contentHandlerBindings.stream().flatMap(l -> l.stream().filter(c -> !c.getResourceConfig().isSystem())).count();
            if (userContentHandlerBindingsCount != 1L) continue;
            FilterBypass filterBypass = this.getFilterBypass((ContentHandlerBindingIndex<T>)contentHandlerBindingIndex);
            if (filterBypass != null) {
                bypassSet.add(filterBypass);
                continue;
            }
            return null;
        }
        if (bypassSet.size() == 1) {
            return (FilterBypass)bypassSet.iterator().next();
        }
        return null;
    }

    private <T extends Visitor> FilterBypass getFilterBypass(ContentHandlerBindingIndex<T> contentHandlerBindingIndex) {
        Set<Map.Entry<String, List<ContentHandlerBinding<T>>>> entries = contentHandlerBindingIndex.entrySet();
        for (Map.Entry<String, List<ContentHandlerBinding<T>>> entry : entries) {
            Visitor visitor;
            ContentHandlerBinding<T> configMap = entry.getValue().get(0);
            ResourceConfig resourceConfig = configMap.getResourceConfig();
            if (resourceConfig.isSystem()) continue;
            if (resourceConfig.getSelectorPath() instanceof IndexedSelectorPath && ((IndexedSelectorPath)resourceConfig.getSelectorPath()).getTargetSelectorStep() instanceof DocumentSelectorStep && (visitor = (Visitor)configMap.getContentHandler()) instanceof FilterBypass) {
                return (FilterBypass)visitor;
            }
            return null;
        }
        return null;
    }

    protected boolean getCloseSource() {
        if (this.closeSource == null) {
            this.closeSource = Boolean.parseBoolean((String)((GlobalParamsLookup.ParameterAccessor)this.registry.lookup((Function)new GlobalParamsLookup())).getParameterValue("close.source"));
        }
        return this.closeSource;
    }

    protected boolean getCloseSink() {
        if (this.closeSink == null) {
            this.closeSink = Boolean.parseBoolean((String)((GlobalParamsLookup.ParameterAccessor)this.registry.lookup((Function)new GlobalParamsLookup())).getParameterValue("close.sink"));
        }
        return this.closeSink;
    }
}

