/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.converter;

import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Properties;
import org.smooks.api.SmooksConfigException;
import org.smooks.engine.converter.LocaleAwareTypeConverter;

public abstract class DateLocaleAwareTypeConverter<S, T>
extends LocaleAwareTypeConverter<S, T> {
    public static final String FORMAT = "format";
    public static final String ZONE_ID = "zoneId";
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    protected String format;
    protected ZoneId zoneId = ZoneId.systemDefault();
    protected DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss");

    @Override
    public void setConfiguration(Properties properties) throws SmooksConfigException {
        super.setConfiguration(properties);
        if (properties != null) {
            this.format = properties.getProperty(FORMAT, DEFAULT_DATE_FORMAT);
            if (this.format == null) {
                throw new SmooksConfigException("Decoder must specify a 'format' parameter.");
            }
            if (properties.getProperty(ZONE_ID) != null) {
                this.zoneId = ZoneId.of(properties.getProperty(ZONE_ID));
            }
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(this.format.trim());
            if (this.getLocale() != null) {
                dateTimeFormatter = dateTimeFormatter.withLocale(this.getLocale());
            }
            if (this.zoneId != null) {
                dateTimeFormatter = dateTimeFormatter.withZone(this.zoneId);
            }
            this.dateTimeFormatter = dateTimeFormatter;
        }
    }
}

