/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.converter;

import org.smooks.api.converter.TypeConverter;
import org.smooks.api.converter.TypeConverterDescriptor;
import org.smooks.api.converter.TypeConverterException;
import org.smooks.api.converter.TypeConverterFactory;
import org.smooks.engine.converter.DefaultTypeConverterDescriptor;
import org.smooks.support.ClassUtils;

public class ClassConverterFactory
implements TypeConverterFactory<String, Class> {
    public TypeConverter<String, Class> createTypeConverter() {
        return value -> {
            try {
                return ClassUtils.forName((String)value.trim(), ClassConverterFactory.class);
            }
            catch (ClassNotFoundException e) {
                throw new TypeConverterException("Failed to decode '" + value + "' as a Java Class.", (Throwable)e);
            }
        };
    }

    public TypeConverterDescriptor<Class<String>, Class<Class>> getTypeConverterDescriptor() {
        return new DefaultTypeConverterDescriptor<Class<String>, Class<Class>>(String.class, Class.class);
    }
}

