/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.bean.context;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.smooks.api.bean.context.BeanIdStore;
import org.smooks.api.bean.repository.BeanId;
import org.smooks.assertion.AssertArgument;
import org.smooks.engine.bean.repository.DefaultBeanId;

public class DefaultBeanIdStore
implements BeanIdStore {
    private volatile HashMap<String, BeanId> beanIdMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BeanId register(String beanIdName) {
        AssertArgument.isNotEmpty((String)beanIdName, (String)"beanIdName");
        BeanId beanId = this.beanIdMap.get(beanIdName);
        if (beanId == null) {
            DefaultBeanIdStore defaultBeanIdStore = this;
            synchronized (defaultBeanIdStore) {
                beanId = this.beanIdMap.get(beanIdName);
                if (beanId == null) {
                    HashMap newBeanIdMap = (HashMap)this.beanIdMap.clone();
                    beanId = new DefaultBeanId(this, newBeanIdMap.size(), beanIdName);
                    newBeanIdMap.put(beanIdName, beanId);
                    this.beanIdMap = newBeanIdMap;
                }
            }
        }
        return beanId;
    }

    public BeanId getBeanId(String beanId) {
        return this.beanIdMap.get(beanId);
    }

    public boolean containsBeanId(String beanId) {
        return this.beanIdMap.containsKey(beanId);
    }

    public Map<String, BeanId> getBeanIdMap() {
        return Collections.unmodifiableMap(this.beanIdMap);
    }

    public int size() {
        return this.beanIdMap.size();
    }
}

