/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine;

import com.fasterxml.classmate.TypeResolver;
import jakarta.annotation.Resource;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.api.NotAppContextScoped;
import org.smooks.api.Registry;
import org.smooks.api.SmooksException;
import org.smooks.api.TypedKey;
import org.smooks.api.converter.TypeConverterFactory;
import org.smooks.api.lifecycle.LifecycleManager;
import org.smooks.api.lifecycle.LifecyclePhase;
import org.smooks.api.profile.ProfileSet;
import org.smooks.api.profile.ProfileStore;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.config.ResourceConfigSeq;
import org.smooks.api.resource.config.loader.ResourceConfigLoader;
import org.smooks.assertion.AssertArgument;
import org.smooks.engine.converter.TypeConverterFactoryLoader;
import org.smooks.engine.injector.Scope;
import org.smooks.engine.lifecycle.DefaultLifecycleManager;
import org.smooks.engine.lifecycle.PostConstructLifecyclePhase;
import org.smooks.engine.lifecycle.PreDestroyLifecyclePhase;
import org.smooks.engine.lookup.GlobalResourceConfigSeqLookup;
import org.smooks.engine.lookup.LifecycleManagerLookup;
import org.smooks.engine.lookup.ResourceConfigSeqsLookup;
import org.smooks.engine.lookup.converter.TypeConverterFactoryLookup;
import org.smooks.engine.resource.config.DefaultResourceConfigSeq;

public class DefaultRegistry
implements Registry {
    private static final Logger LOGGER = LoggerFactory.getLogger(Registry.class);
    private final Map<Object, Object> registry = new ConcurrentHashMap<Object, Object>();
    private final ClassLoader classLoader;
    private final ResourceConfigLoader resourceConfigLoader;

    public DefaultRegistry(ClassLoader classLoader, ResourceConfigLoader resourceConfigLoader, ProfileStore profileStore) {
        AssertArgument.isNotNull((Object)classLoader, (String)"classLoader");
        AssertArgument.isNotNull((Object)resourceConfigLoader, (String)"resourceConfigLoader");
        AssertArgument.isNotNull((Object)profileStore, (String)"profileStore");
        this.classLoader = classLoader;
        this.registerObject(ProfileStore.class, profileStore);
        Set<TypeConverterFactory<?, ?>> typeConverterFactories = new TypeConverterFactoryLoader().load(classLoader);
        this.registerObject(TypeConverterFactoryLookup.TYPE_CONVERTER_FACTORY_REGISTRY_KEY, typeConverterFactories);
        this.registerObject(LifecycleManager.class, new DefaultLifecycleManager());
        DefaultResourceConfigSeq globalResourceConfigSeq = new DefaultResourceConfigSeq("global");
        globalResourceConfigSeq.setSystem(true);
        this.registerObject(ResourceConfigSeq.class, globalResourceConfigSeq);
        ArrayList<DefaultResourceConfigSeq> resourceConfigSeqs = new ArrayList<DefaultResourceConfigSeq>();
        resourceConfigSeqs.add(globalResourceConfigSeq);
        this.registerObject(new TypeResolver().resolve(List.class, new Type[]{ResourceConfigSeq.class}), resourceConfigSeqs);
        this.resourceConfigLoader = resourceConfigLoader;
    }

    public void registerObject(Object value) {
        String candidateName;
        AssertArgument.isNotNull((Object)value, (String)"value");
        String name = value.getClass().isAnnotationPresent(Resource.class) && !value.getClass().getAnnotation(Resource.class).name().isEmpty() ? (this.registry.containsKey(candidateName = value.getClass().getAnnotation(Resource.class).name()) ? candidateName + ":" + UUID.randomUUID() : candidateName) : value.getClass().getName() + ":" + UUID.randomUUID();
        this.registerObject(name, value);
    }

    public void registerObject(Object key, Object value) {
        AssertArgument.isNotNull((Object)key, (String)"key");
        AssertArgument.isNotNull((Object)value, (String)"value");
        if (this.registry.putIfAbsent(key, value) != null) {
            throw new SmooksException(String.format("Duplicate registered object for object with key [%s]", key));
        }
    }

    public void deRegisterObject(Object key) {
        this.registry.remove(key);
    }

    public <R> R lookup(Function<Map<Object, Object>, R> function) {
        return function.apply(Collections.unmodifiableMap(this.registry));
    }

    public <T> T lookup(Object key) {
        Object entry = this.registry.get(key);
        if (entry instanceof NotAppContextScoped.Ref) {
            return (T)((NotAppContextScoped.Ref)entry).get();
        }
        return (T)entry;
    }

    public <T> T lookup(TypedKey<T> key) {
        return this.lookup((Object)key);
    }

    public ResourceConfigSeq registerResources(String baseURI, InputStream inputStream) {
        AssertArgument.isNotEmpty((String)baseURI, (String)"baseURI");
        AssertArgument.isNotNull((Object)inputStream, (String)"inputStream");
        ResourceConfigSeq resourceConfigSeq = this.resourceConfigLoader.load(inputStream, baseURI, this.classLoader);
        this.registerResourceConfigSeq(resourceConfigSeq);
        return resourceConfigSeq;
    }

    protected void addProfileSets(List<ProfileSet> profileSets) {
        ProfileStore profileStore = (ProfileStore)this.lookup(ProfileStore.class);
        if (profileSets == null) {
            return;
        }
        for (ProfileSet profileSet : profileSets) {
            profileStore.addProfileSet(profileSet);
        }
    }

    public void registerResourceConfig(ResourceConfig resourceConfig) {
        AssertArgument.isNotNull((Object)resourceConfig, (String)"resourceConfig");
        this.lookup(new LifecycleManagerLookup()).applyPhase((Object)resourceConfig, (LifecyclePhase)new PostConstructLifecyclePhase(new Scope(this)));
        this.lookup(new GlobalResourceConfigSeqLookup()).add(resourceConfig);
    }

    public void registerResourceConfigSeq(ResourceConfigSeq resourceConfigSeq) {
        this.lookup(new ResourceConfigSeqsLookup()).add(resourceConfigSeq);
        this.lookup(new LifecycleManagerLookup()).applyPhase((Object)resourceConfigSeq, (LifecyclePhase)new PostConstructLifecyclePhase(new Scope(this)));
        this.addProfileSets(resourceConfigSeq.getProfiles());
    }

    public void close() {
        LOGGER.debug("Un-initializing all ContentHandler instances allocated through this registry");
        for (Object registeredObject : this.registry.values()) {
            LOGGER.debug("Un-initializing ContentHandler instance: {}", (Object)registeredObject.getClass().getName());
            try {
                this.lookup(new LifecycleManagerLookup()).applyPhase(registeredObject, (LifecyclePhase)new PreDestroyLifecyclePhase());
            }
            catch (Throwable throwable) {
                LOGGER.error("Error un-initializing " + registeredObject.getClass().getName() + ".", throwable);
            }
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }
}

