/*
 * Decompiled with CFR 0.152.
 */
package org.smooks;

import java.util.List;
import java.util.function.Function;
import org.smooks.StreamFilterType;
import org.smooks.api.Registry;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.config.ResourceConfigSeq;
import org.smooks.engine.DefaultFilterSettings;
import org.smooks.engine.delivery.dom.DOMFilterType;
import org.smooks.engine.delivery.sax.ng.SaxNgFilterType;
import org.smooks.engine.lookup.ResourceConfigSeqsLookup;
import org.smooks.engine.resource.config.GlobalParamsResourceConfig;

@Deprecated
public class FilterSettings {
    public static final FilterSettings DEFAULT_DOM = new FilterSettings(StreamFilterType.DOM);
    public static final FilterSettings DEFAULT_SAX_NG = new FilterSettings(StreamFilterType.SAX_NG);
    private final org.smooks.api.FilterSettings v2FilterSettings = new DefaultFilterSettings();

    public FilterSettings() {
    }

    public static FilterSettings newDOMSettings() {
        return new FilterSettings(StreamFilterType.DOM);
    }

    public static FilterSettings newSaxNgSettings() {
        return new FilterSettings(StreamFilterType.SAX_NG);
    }

    public FilterSettings(StreamFilterType filterType) {
        this.assertNonStaticDecl();
        if (filterType.equals((Object)StreamFilterType.DOM)) {
            this.v2FilterSettings.setFilterType((org.smooks.api.delivery.StreamFilterType)new DOMFilterType());
        } else {
            this.v2FilterSettings.setFilterType((org.smooks.api.delivery.StreamFilterType)new SaxNgFilterType());
        }
    }

    public FilterSettings setFilterType(StreamFilterType filterType) {
        this.assertNonStaticDecl();
        if (filterType.equals((Object)StreamFilterType.DOM)) {
            this.v2FilterSettings.setFilterType((org.smooks.api.delivery.StreamFilterType)new DOMFilterType());
        } else {
            this.v2FilterSettings.setFilterType((org.smooks.api.delivery.StreamFilterType)new SaxNgFilterType());
        }
        return this;
    }

    public FilterSettings setRewriteEntities(boolean rewriteEntities) {
        this.assertNonStaticDecl();
        this.v2FilterSettings.setRewriteEntities(rewriteEntities);
        return this;
    }

    public FilterSettings setDefaultSerializationOn(boolean defaultSerializationOn) {
        this.assertNonStaticDecl();
        this.v2FilterSettings.setDefaultSerializationOn(defaultSerializationOn);
        return this;
    }

    public FilterSettings setTerminateOnException(boolean terminateOnException) {
        this.assertNonStaticDecl();
        this.v2FilterSettings.setTerminateOnException(terminateOnException);
        return this;
    }

    public FilterSettings setMaintainElementStack(boolean maintainElementStack) {
        this.assertNonStaticDecl();
        this.v2FilterSettings.setMaintainElementStack(maintainElementStack);
        return this;
    }

    public FilterSettings setCloseSource(boolean closeSource) {
        this.assertNonStaticDecl();
        this.v2FilterSettings.setCloseSource(closeSource);
        return this;
    }

    public FilterSettings setCloseSink(boolean closeSink) {
        this.assertNonStaticDecl();
        this.v2FilterSettings.setCloseSink(closeSink);
        return this;
    }

    public FilterSettings setReaderPoolSize(int readerPoolSize) {
        this.assertNonStaticDecl();
        this.v2FilterSettings.setReaderPoolSize(readerPoolSize);
        return this;
    }

    public FilterSettings setMaxNodeDepth(int maxNodeDepth) {
        this.assertNonStaticDecl();
        this.v2FilterSettings.setMaxNodeDepth(maxNodeDepth);
        return this;
    }

    public StreamFilterType getFilterType() {
        org.smooks.api.delivery.StreamFilterType streamFilterType = this.v2FilterSettings.getFilterType();
        if (streamFilterType instanceof DOMFilterType) {
            return StreamFilterType.DOM;
        }
        return StreamFilterType.SAX_NG;
    }

    public Boolean isRewriteEntities() {
        return this.v2FilterSettings.isRewriteEntities();
    }

    public Boolean isDefaultSerializationOn() {
        return this.v2FilterSettings.isDefaultSerializationOn();
    }

    public Boolean isTerminateOnException() {
        return this.v2FilterSettings.isTerminateOnException();
    }

    public Boolean isMaintainElementStack() {
        return this.v2FilterSettings.isMaintainElementStack();
    }

    public Boolean isCloseSource() {
        return this.v2FilterSettings.isCloseSource();
    }

    public Boolean isCloseSink() {
        return this.v2FilterSettings.isCloseSink();
    }

    public Integer getReaderPoolSize() {
        return this.v2FilterSettings.getReaderPoolSize();
    }

    public Integer getMaxNodeDepth() {
        return this.v2FilterSettings.getMaxNodeDepth();
    }

    protected void applySettings(Registry registry) {
        this.removeParameter("stream.filter.type", registry);
        this.removeParameter("entities.rewrite", registry);
        this.removeParameter("default.serialization.on", registry);
        this.removeParameter("terminate.on.visitor.exception", registry);
        this.removeParameter("maintain.element.stack", registry);
        this.removeParameter("close.source", registry);
        this.removeParameter("close.sink", registry);
        this.removeParameter("reader.pool.size", registry);
        this.removeParameter("max.node.depth", registry);
        this.setParameter("stream.filter.type", this.v2FilterSettings.getFilterType().getName(), registry);
        this.setParameter("entities.rewrite", Boolean.toString(this.v2FilterSettings.isRewriteEntities()), registry);
        this.setParameter("default.serialization.on", Boolean.toString(this.v2FilterSettings.isDefaultSerializationOn()), registry);
        this.setParameter("terminate.on.visitor.exception", Boolean.toString(this.v2FilterSettings.isTerminateOnException()), registry);
        this.setParameter("maintain.element.stack", Boolean.toString(this.v2FilterSettings.isMaintainElementStack()), registry);
        this.setParameter("close.source", Boolean.toString(this.v2FilterSettings.isCloseSource()), registry);
        this.setParameter("close.sink", Boolean.toString(this.v2FilterSettings.isCloseSink()), registry);
        this.setParameter("reader.pool.size", Integer.toString(this.v2FilterSettings.getReaderPoolSize()), registry);
        this.setParameter("max.node.depth", Integer.toString(this.v2FilterSettings.getMaxNodeDepth()), registry);
    }

    private void assertNonStaticDecl() {
        if (this == DEFAULT_DOM || this == DEFAULT_SAX_NG) {
            throw new UnsupportedOperationException("Invalid attempt to modify static filter type declaration.");
        }
    }

    private void setParameter(String name, Object value, Registry registry) {
        GlobalParamsResourceConfig globalParamsResourceConfig = new GlobalParamsResourceConfig();
        globalParamsResourceConfig.setParameter(name, value);
        registry.registerResourceConfig((ResourceConfig)globalParamsResourceConfig);
    }

    private void removeParameter(String name, Registry registry) {
        for (ResourceConfigSeq resourceConfigSeq : (List)registry.lookup((Function)new ResourceConfigSeqsLookup())) {
            for (int i = 0; i < resourceConfigSeq.size(); ++i) {
                ResourceConfig nextResourceConfig = resourceConfigSeq.get(i);
                if (!"global-parameters".equals(nextResourceConfig.getSelectorPath().getSelector())) continue;
                nextResourceConfig.removeParameter(name);
            }
        }
    }
}

