/*
 * Decompiled with CFR 0.152.
 */
package org.smartrplace.apps.humidity.warning.impl.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.stream.DoubleStream;
import org.ogema.core.model.Resource;
import org.ogema.model.locations.Room;
import org.smartrplace.apps.humidity.warning.impl.Utils;
import org.smartrplace.apps.humidity.warning.impl.pattern.HumidityPattern;
import org.smartrplace.apps.humidity.warning.impl.pattern.TemperaturePattern;
import org.smartrplace.apps.humidity.warning.impl.pattern.WarningConfigurationPattern;

class RoomConfig {
    final Room room;
    final List<HumidityPattern> humiditySensors = new ArrayList<HumidityPattern>(2);
    final List<TemperaturePattern> temperatureSensors = new ArrayList<TemperaturePattern>(2);
    volatile WarningConfigurationPattern warningConfig;
    private boolean finished = false;
    private float avgHumidity;
    private float avgTemperatureCelsius;
    private float dewPointCelsius;

    RoomConfig(Room room) {
        Room r = room;
        while (r.isReference(true)) {
            r = (Room)r.getLocationResource();
        }
        this.room = r;
    }

    void calcAverages() {
        this.avgTemperatureCelsius = this.temperatureSensors.isEmpty() ? Float.NaN : (float)this.temperatureSensors.stream().mapToDouble(pattern -> pattern.reading.getCelsius()).average().orElse(Double.NaN);
        this.avgHumidity = this.humiditySensors.isEmpty() ? Float.NaN : (float)this.humiditySensors.stream().mapToDouble(pattern -> pattern.reading.getValue()).average().orElse(Double.NaN);
        this.dewPointCelsius = !Float.isFinite(this.avgTemperatureCelsius) || !Float.isFinite(this.avgHumidity) ? Float.NaN : Utils.calculateDewPoint(this.avgTemperatureCelsius, this.avgHumidity);
        this.finished = true;
    }

    private void checkState() {
        if (!this.finished) {
            this.calcAverages();
        }
    }

    float getAverageHumidity() {
        this.checkState();
        return this.avgHumidity;
    }

    float getAverageTemperatureCelsius() {
        this.checkState();
        return this.avgTemperatureCelsius;
    }

    float getDewPointCelsius() {
        this.checkState();
        return this.dewPointCelsius;
    }

    int getHumidityThreshold(boolean highOrLow) {
        WarningConfigurationPattern warningConfig = this.warningConfig;
        if (highOrLow) {
            if (warningConfig != null && warningConfig.upperThresholdHumidity.isActive()) {
                return (int)(warningConfig.upperThresholdHumidity.getValue() * 100.0f);
            }
            return 65;
        }
        if (warningConfig != null && warningConfig.lowerThresholdHumidity.isActive()) {
            return (int)(warningConfig.lowerThresholdHumidity.getValue() * 100.0f);
        }
        return 35;
    }

    void setHumidityThreshold(boolean highOrLow, int newValue) {
        WarningConfigurationPattern warningConfig = this.warningConfig;
        if (warningConfig == null || newValue < 0 || newValue > 100) {
            return;
        }
        if (highOrLow && !warningConfig.upperThresholdHumidity.isActive() || !highOrLow && !warningConfig.lowerThresholdHumidity.isActive()) {
            return;
        }
        if (highOrLow) {
            warningConfig.upperThresholdHumidity.setValue((float)newValue / 100.0f);
        } else {
            warningConfig.lowerThresholdHumidity.setValue((float)newValue / 100.0f);
        }
    }

    boolean thresholdViolated(boolean highOrLow) {
        OptionalDouble opt;
        WarningConfigurationPattern warningConfig = this.warningConfig;
        if (warningConfig == null) {
            return false;
        }
        if (highOrLow && !warningConfig.upperThresholdHumidity.isActive() || !highOrLow && !warningConfig.lowerThresholdHumidity.isActive()) {
            return false;
        }
        DoubleStream ds = this.humiditySensors.stream().mapToDouble(sensor -> sensor.reading.getValue()).filter(val -> val >= 0.0 && val <= 1.0);
        OptionalDouble optionalDouble = opt = highOrLow ? ds.max() : ds.min();
        if (!opt.isPresent()) {
            return false;
        }
        return highOrLow ? opt.getAsDouble() > (double)warningConfig.upperThresholdHumidity.getValue() : opt.getAsDouble() < (double)warningConfig.lowerThresholdHumidity.getValue();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RoomConfig)) {
            return false;
        }
        return ((RoomConfig)obj).room.equalsLocation((Resource)this.room);
    }

    public int hashCode() {
        return Objects.hash(this.room);
    }

    public String toString() {
        return "RoomConfig[" + this.room.getLocation() + "]";
    }
}

