/*
 * Decompiled with CFR 0.152.
 */
package org.smartrplace.apps.humidity.warning.impl.gui;

import de.iwes.widgets.api.extended.html.bricks.PageSnippet;
import de.iwes.widgets.api.services.NameService;
import de.iwes.widgets.api.widgets.OgemaWidget;
import de.iwes.widgets.api.widgets.WidgetPage;
import de.iwes.widgets.api.widgets.dynamics.TriggeredAction;
import de.iwes.widgets.api.widgets.dynamics.TriggeringAction;
import de.iwes.widgets.api.widgets.html.HtmlItem;
import de.iwes.widgets.api.widgets.html.StaticTable;
import de.iwes.widgets.api.widgets.localisation.OgemaLocale;
import de.iwes.widgets.api.widgets.sessionmanagement.OgemaHttpRequest;
import de.iwes.widgets.html.alert.Alert;
import de.iwes.widgets.html.complextable.DynamicTable;
import de.iwes.widgets.html.complextable.DynamicTableData;
import de.iwes.widgets.html.complextable.RowTemplate;
import de.iwes.widgets.html.form.checkbox.Checkbox2;
import de.iwes.widgets.html.form.checkbox.CheckboxEntry;
import de.iwes.widgets.html.form.checkbox.DefaultCheckboxEntry;
import de.iwes.widgets.html.form.label.Header;
import de.iwes.widgets.html.form.label.Label;
import de.iwes.widgets.html.form.slider.Slider;
import de.iwes.widgets.html.form.textfield.ValueInputField;
import de.iwes.widgets.html.html5.Flexbox;
import de.iwes.widgets.html.icon.Icon;
import de.iwes.widgets.html.icon.IconType;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalDouble;
import org.ogema.core.model.Resource;
import org.ogema.core.model.ResourceList;
import org.ogema.core.model.simple.FloatResource;
import org.ogema.core.model.simple.TimeResource;
import org.ogema.core.resourcemanager.AccessPriority;
import org.ogema.core.resourcemanager.pattern.ResourcePatternAccess;
import org.ogema.model.locations.Room;
import org.ogema.model.prototypes.PhysicalElement;
import org.ogema.model.sensors.HumiditySensor;
import org.smartrplace.apps.humidity.warning.impl.Utils;
import org.smartrplace.apps.humidity.warning.impl.gui.RoomConfig;
import org.smartrplace.apps.humidity.warning.impl.pattern.HumidityPattern;
import org.smartrplace.apps.humidity.warning.impl.pattern.TemperaturePattern;
import org.smartrplace.apps.humidity.warning.impl.pattern.WarningConfigurationPattern;
import org.smartrplace.apps.humidity.warning.model.WarningConfiguration;

public class HumidityPage {
    private static final long MINUTE = 60000L;
    private final WidgetPage<?> page;
    private final Header header;
    private final Alert alert;
    private final Label outsideLabel;
    private final Label outsideTemp;
    private final DynamicTable<RoomConfig> roomTable;

    public HumidityPage(WidgetPage<?> page, final ResourcePatternAccess rpa, final ResourceList<WarningConfiguration> configsBase) {
        this.page = page;
        this.header = new Header(page, "header", "Humidity Warnings");
        this.alert = new Alert(page, "alert", "");
        this.alert.setDefaultVisibility(false);
        this.header.setDefaultColor("blue");
        this.outsideLabel = new Label(page, "outsideLab");
        this.outsideLabel.setDefaultText("Outside temperature:");
        this.outsideTemp = new Label(page, "outsideTemp"){

            public void onGET(OgemaHttpRequest req) {
                OptionalDouble opt = rpa.getPatterns(TemperaturePattern.class, AccessPriority.PRIO_LOWEST).stream().filter(sensor -> sensor.room != null).filter(sensor -> sensor.room.type().isActive() && sensor.room.type().getValue() == 0).mapToDouble(sensor -> sensor.reading.getCelsius()).average();
                if (!opt.isPresent()) {
                    this.setText("unknown", req);
                } else {
                    this.setText(String.format("%.2f\u00b0C", opt.getAsDouble()), req);
                }
            }
        };
        this.roomTable = new DynamicTable<RoomConfig>(page, "roomTable"){

            public void onGET(OgemaHttpRequest req) {
                this.updateRows(HumidityPage.getByRooms(rpa), req);
            }
        };
        this.roomTable.addDefaultStyle(DynamicTableData.BOLD_HEADER);
        this.roomTable.setRowTemplate((RowTemplate)new RowTemplate<RoomConfig>(){
            private final Map<String, Object> header = new LinkedHashMap<String, Object>();
            {
                this.header.put("room", "Room");
                this.header.put("sensors", "Sensors");
                this.header.put("humidity", "Current humidity");
                this.header.put("temp", "Temperature");
                this.header.put("dew", "Dew point");
                this.header.put("warnings", "Warnings");
            }

            public String getLineId(RoomConfig object) {
                return object.room.getLocation();
            }

            public Map<String, Object> getHeader() {
                return this.header;
            }

            public RowTemplate.Row addRow(RoomConfig object, OgemaHttpRequest req) {
                RowTemplate.Row row = new RowTemplate.Row();
                String id = this.getLineId(object);
                RoomLabel roomLabel = new RoomLabel((OgemaWidget)HumidityPage.this.roomTable, "room_" + id, req, object);
                SensorsLabel sensorsLabel = new SensorsLabel((OgemaWidget)HumidityPage.this.roomTable, "sensors_" + id, req, object);
                HumidityLabel humidityLabel = new HumidityLabel((OgemaWidget)HumidityPage.this.roomTable, "humidity_" + id, req, object);
                TemperatureLabel tempLabel = new TemperatureLabel((OgemaWidget)HumidityPage.this.roomTable, "temp_" + id, req, object);
                DewPointLabel dewPointLabel = new DewPointLabel((OgemaWidget)HumidityPage.this.roomTable, "dew_" + id, req, object);
                PageSnippet warningsSnippet = new PageSnippet((OgemaWidget)HumidityPage.this.roomTable, "warnings_" + id, req);
                warningsSnippet.append((OgemaWidget)new WarningsFlex((OgemaWidget)warningsSnippet, "lowFlex_" + id, req, object, true, (ResourceList<WarningConfiguration>)configsBase), req).append((OgemaWidget)new WarningsFlex((OgemaWidget)warningsSnippet, "highFlex_" + id, req, object, false, (ResourceList<WarningConfiguration>)configsBase), req);
                row.addCell("room", (Object)roomLabel, 1);
                row.addCell("sensors", (Object)sensorsLabel, 1);
                row.addCell("humidity", (Object)humidityLabel, 1);
                row.addCell("temp", (Object)tempLabel, 1);
                row.addCell("dew", (Object)dewPointLabel, 1);
                row.addCell("warnings", (Object)warningsSnippet, 7);
                return row;
            }
        });
        this.buildPage();
        this.setDependencies();
    }

    private final void buildPage() {
        this.page.append((OgemaWidget)this.header).linebreak().append((OgemaWidget)this.alert).append((HtmlItem)new StaticTable(1, 3, new int[]{2, 2, 8}).setContent(0, 0, (OgemaWidget)this.outsideLabel).setContent(0, 1, (OgemaWidget)this.outsideTemp)).linebreak().append(this.roomTable);
    }

    private final void setDependencies() {
    }

    private static final Collection<RoomConfig> getByRooms(ResourcePatternAccess rpa) {
        List sensors = rpa.getPatterns(HumidityPattern.class, AccessPriority.PRIO_LOWEST);
        LinkedHashMap<String, RoomConfig> rooms = new LinkedHashMap<String, RoomConfig>();
        for (HumidityPattern sensor : sensors) {
            Room r2 = sensor.room;
            if (r2 == null) continue;
            String loc = r2.getLocation();
            RoomConfig cfg = (RoomConfig)rooms.get(loc);
            if (cfg == null) {
                cfg = new RoomConfig(r2);
                rooms.put(loc, cfg);
            }
            cfg.humiditySensors.add(sensor);
        }
        rpa.getPatterns(WarningConfigurationPattern.class, AccessPriority.PRIO_LOWEST).forEach(warning -> {
            Room r = warning.room;
            RoomConfig cfg = (RoomConfig)rooms.get(r.getLocation());
            if (cfg == null) {
                cfg = new RoomConfig(r);
                rooms.put(r.getLocation(), cfg);
            }
            cfg.warningConfig = warning;
        });
        rpa.getPatterns(TemperaturePattern.class, AccessPriority.PRIO_LOWEST).forEach(tempSens -> {
            Room r = tempSens.room;
            if (r == null) {
                return;
            }
            RoomConfig cfg = (RoomConfig)rooms.get(r.getLocation());
            if (cfg == null) {
                return;
            }
            cfg.temperatureSensors.add((TemperaturePattern)((Object)tempSens));
        });
        rooms.values().forEach(r -> r.calcAverages());
        return rooms.values();
    }

    private static final class DewPointLabel
    extends Label {
        private final RoomConfig room;

        public DewPointLabel(OgemaWidget parent, String id, OgemaHttpRequest req, RoomConfig room) {
            super(parent, id, req);
            this.room = room;
        }

        public void onGET(OgemaHttpRequest req) {
            float temp = this.room.getDewPointCelsius();
            if (Float.isNaN(temp)) {
                this.setText("-", req);
            } else {
                this.setText(String.format("%.2f", Float.valueOf(temp)) + "\u00b0C", req);
            }
        }
    }

    private static final class TemperatureLabel
    extends Label {
        private final RoomConfig room;

        public TemperatureLabel(OgemaWidget parent, String id, OgemaHttpRequest req, RoomConfig room) {
            super(parent, id, req);
            this.room = room;
        }

        public void onGET(OgemaHttpRequest req) {
            float temp = this.room.getAverageTemperatureCelsius();
            if (Float.isNaN(temp)) {
                this.setText("-", req);
            } else {
                this.setText(String.format("%.2f", Float.valueOf(temp)) + "\u00b0C", req);
            }
        }
    }

    private static final class HumidityLabel
    extends Label {
        private final RoomConfig room;

        public HumidityLabel(OgemaWidget parent, String id, OgemaHttpRequest req, RoomConfig room) {
            super(parent, id, req);
            this.room = room;
        }

        public void onGET(OgemaHttpRequest req) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (HumidityPattern sensor : this.room.humiditySensors) {
                if (!first) {
                    sb.append("<br>");
                }
                if (!sensor.reading.isActive()) {
                    sb.append("No value");
                    continue;
                }
                int value = (int)(sensor.reading.getValue() * 100.0f);
                sb.append(value).append('%');
            }
            this.setHtml(sb.toString(), req);
        }
    }

    private static final class SensorsLabel
    extends Label {
        private final RoomConfig room;

        public SensorsLabel(OgemaWidget parent, String id, OgemaHttpRequest req, RoomConfig room) {
            super(parent, id, req);
            this.room = room;
        }

        public void onGET(OgemaHttpRequest req) {
            NameService nameService = this.getNameService();
            OgemaLocale locale = req.getLocale();
            StringBuilder sb = new StringBuilder();
            StringBuilder tooltipBuilder = new StringBuilder();
            boolean first = true;
            for (HumidityPattern sensor : this.room.humiditySensors) {
                if (!first) {
                    sb.append("<br>");
                    tooltipBuilder.append(',').append('\n');
                }
                first = false;
                sb.append(Utils.getName((PhysicalElement)sensor.model, nameService, locale));
                tooltipBuilder.append(((HumiditySensor)sensor.model).getLocation());
            }
            this.setHtml(sb.toString(), req);
            this.setToolTip(tooltipBuilder.toString(), req);
        }
    }

    private static final class RoomLabel
    extends Label {
        private final RoomConfig room;

        public RoomLabel(OgemaWidget parent, String id, OgemaHttpRequest req, RoomConfig room) {
            super(parent, id, req);
            this.room = room;
        }

        public void onGET(OgemaHttpRequest req) {
            String name = Utils.getName((PhysicalElement)this.room.room, this.getNameService(), req.getLocale());
            this.setText(name, req);
            this.setToolTip(this.room.room.getLocation(), req);
        }
    }

    private static final class WarningsFlex
    extends Flexbox {
        private final Checkbox2 active;
        private final Slider humiditySlider;
        private final Icon icon;
        private final Label timeoutLabel;
        private final ValueInputField<Integer> timeoutMinutes;

        public WarningsFlex(OgemaWidget parent, String id, OgemaHttpRequest req, final RoomConfig room, final boolean highOrLow, final ResourceList<WarningConfiguration> cfgsBase) {
            super(parent, id, req);
            this.active = new Checkbox2((OgemaWidget)this, "check_" + highOrLow + "_" + id, req){

                public void onGET(OgemaHttpRequest req) {
                    boolean active = room.warningConfig != null && (highOrLow ? room.warningConfig.upperThresholdHumidity.isActive() : room.warningConfig.lowerThresholdHumidity.isActive());
                    this.setState("", active, req);
                }

                public synchronized void onPOSTComplete(String data, OgemaHttpRequest req) {
                    boolean active = this.isChecked("", req);
                    if (!active && room.warningConfig != null) {
                        if (highOrLow) {
                            room.warningConfig.upperThresholdHumidity.delete();
                        } else {
                            room.warningConfig.lowerThresholdHumidity.delete();
                        }
                        if (!room.warningConfig.upperThresholdHumidity.isActive() && !room.warningConfig.lowerThresholdHumidity.isActive()) {
                            ((WarningConfiguration)room.warningConfig.model).delete();
                            room.warningConfig = null;
                        }
                    } else if (active) {
                        WarningConfigurationPattern cfg = room.warningConfig;
                        if (cfg == null) {
                            WarningConfiguration cfg0 = (WarningConfiguration)cfgsBase.add();
                            cfg0.room().setAsReference((Resource)room.room);
                            room.warningConfig = cfg = new WarningConfigurationPattern((Resource)cfg0);
                        }
                        int value = humiditySlider.getValue(req);
                        FloatResource target = highOrLow ? cfg.upperThresholdHumidity : cfg.lowerThresholdHumidity;
                        ((FloatResource)target.create()).setValue((float)value / 100.0f);
                        target.activate(false);
                        ((WarningConfiguration)cfg.model).activate(false);
                    }
                }
            };
            boolean nowActive = room.warningConfig != null && (highOrLow ? room.warningConfig.upperThresholdHumidity.isActive() : room.warningConfig.lowerThresholdHumidity.isActive());
            DefaultCheckboxEntry entry = new DefaultCheckboxEntry("", highOrLow ? "High humidity" : "Low humidity", nowActive);
            this.active.addEntry((CheckboxEntry)entry, req);
            int defaultThreshold = room.getHumidityThreshold(highOrLow);
            this.humiditySlider = new Slider((OgemaWidget)this, "humSlider_" + highOrLow + "_" + id, req, 0, 100, defaultThreshold){

                public void onGET(OgemaHttpRequest req) {
                    this.setValue(room.getHumidityThreshold(highOrLow), req);
                }

                public void onPOSTComplete(String data, OgemaHttpRequest req) {
                    int value = this.getValue(req);
                    room.setHumidityThreshold(highOrLow, value);
                }
            };
            this.humiditySlider.setMargin("-0.5em", true, false, false, false, req);
            this.humiditySlider.setMargin("0.5em", false, true, false, true, req);
            this.icon = new Icon((OgemaWidget)this, "icon_" + highOrLow + "_" + id, req){

                public void onGET(OgemaHttpRequest req) {
                    if (!active.isChecked("", req)) {
                        this.setIconType(null, req);
                        return;
                    }
                    boolean violated = room.thresholdViolated(highOrLow);
                    this.setIconType(violated ? IconType.FAIL : IconType.CHECK_MARK, req);
                }
            };
            this.timeoutLabel = new Label((OgemaWidget)this, "timeoutLab_" + highOrLow + "_" + id, req){

                public void onGET(OgemaHttpRequest req) {
                    WarningConfigurationPattern cfg = room.warningConfig;
                    if (cfg == null || !active.isChecked("", req)) {
                        this.setWidgetVisibility(false, req);
                        return;
                    }
                    this.setWidgetVisibility(true, req);
                }
            };
            this.timeoutLabel.setText("Timeout in minutes", req);
            this.timeoutLabel.setToolTip("A message will be sent only after the threshold has been violated for this long.", req);
            this.timeoutLabel.setMargin("0.5em", true, true, false, false, req);
            this.timeoutMinutes = new ValueInputField<Integer>((OgemaWidget)this, "timeout_" + highOrLow + "_" + id, Integer.class, req){

                public void onGET(OgemaHttpRequest req) {
                    TimeResource timeout;
                    WarningConfigurationPattern cfg = room.warningConfig;
                    if (cfg == null || !active.isChecked("", req)) {
                        this.setWidgetVisibility(false, req);
                        return;
                    }
                    this.setWidgetVisibility(true, req);
                    TimeResource timeResource = timeout = highOrLow ? cfg.upperTimeout : cfg.lowerTimeout;
                    if (!timeout.isActive()) {
                        this.setNumericalValue(0, req);
                    } else {
                        this.setNumericalValue((int)(timeout.getValue() / 60000L), req);
                    }
                }

                public void onPOSTComplete(String data, OgemaHttpRequest req) {
                    WarningConfigurationPattern cfg = room.warningConfig;
                    if (cfg == null || !active.isChecked("", req)) {
                        return;
                    }
                    TimeResource timeout = highOrLow ? cfg.upperTimeout : cfg.lowerTimeout;
                    timeout.create();
                    timeout.setValue((long)((Integer)this.getNumericalValue(req)).intValue() * 60000L);
                    timeout.activate(false);
                }
            };
            this.timeoutMinutes.setLowerBound(0.0, req);
            this.timeoutMinutes.setMargin("0.5em", true, true, false, true, req);
            this.buildWidget(req);
            this.setDependencies(req);
        }

        private final void buildWidget(OgemaHttpRequest req) {
            this.addItem((OgemaWidget)this.active, req).addItem((OgemaWidget)this.humiditySlider, req).addItem((OgemaWidget)this.timeoutLabel, req).addItem(this.timeoutMinutes, req).addItem((OgemaWidget)this.icon, req);
        }

        private final void setDependencies(OgemaHttpRequest req) {
            this.active.triggerAction((OgemaWidget)this.humiditySlider, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST, req);
            this.active.triggerAction((OgemaWidget)this.icon, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST, req);
            this.active.triggerAction((OgemaWidget)this.timeoutLabel, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST, req);
            this.active.triggerAction(this.timeoutMinutes, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST, req);
            this.humiditySlider.triggerAction((OgemaWidget)this.icon, TriggeringAction.POST_REQUEST, TriggeredAction.GET_REQUEST, req);
        }
    }
}

