/*
 * Decompiled with CFR 0.152.
 */
package org.smartrplace.apps.humidity.warning.impl;

import de.iwes.widgets.api.services.NameService;
import de.iwes.widgets.api.widgets.localisation.OgemaLocale;
import org.ogema.core.model.Resource;
import org.ogema.model.prototypes.PhysicalElement;

public class Utils {
    private static final double a = 7.5;
    private static final double b = 237.3;

    public static final String getName(PhysicalElement device, NameService nameService, OgemaLocale locale) {
        String name0 = null;
        if (nameService != null && (name0 = nameService.getName((Resource)device, locale, false, true)) == null) {
            Resource parent = Utils.getParentSecure((Resource)device);
            while (!(parent == null || parent instanceof PhysicalElement && (name0 = nameService.getName(parent, locale, false, true)) != null)) {
                parent = Utils.getParentSecure(parent);
            }
        }
        if (name0 == null) {
            name0 = device.name().isActive() ? device.name().getValue() : device.getLocation();
        }
        return name0.length() < 50 ? name0 : name0.substring(0, 50);
    }

    public static float calculateDewPoint(float t, float h) {
        if (!Float.isFinite(t) || !Float.isFinite(h)) {
            return Float.NaN;
        }
        double log = Math.log10(h);
        double tempFactor = 237.3 + (double)t;
        return (float)(237.3 * (7.5 * (double)t + tempFactor * log) / (1779.75 - tempFactor * log));
    }

    private static Resource getParentSecure(Resource r) {
        try {
            return r.getParent();
        }
        catch (SecurityException e) {
            return null;
        }
    }
}

