/*
 * Decompiled with CFR 0.152.
 */
package org.smartrplace.apps.humidity.warning.impl;

import de.iwes.widgets.api.OgemaGuiService;
import de.iwes.widgets.api.services.MessagingService;
import de.iwes.widgets.api.services.NameService;
import de.iwes.widgets.api.widgets.WidgetApp;
import de.iwes.widgets.api.widgets.WidgetPage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ForkJoinPool;
import org.ogema.core.application.AppID;
import org.ogema.core.application.Application;
import org.ogema.core.application.ApplicationManager;
import org.ogema.core.model.Resource;
import org.ogema.core.model.ResourceList;
import org.ogema.core.resourcemanager.AccessPriority;
import org.ogema.core.resourcemanager.CompoundResourceEvent;
import org.ogema.core.resourcemanager.pattern.PatternChangeListener;
import org.ogema.core.resourcemanager.pattern.PatternListener;
import org.ogema.core.resourcemanager.pattern.ResourcePattern;
import org.ogema.core.resourcemanager.pattern.ResourcePatternAccess;
import org.ogema.model.locations.Room;
import org.ogema.model.sensors.HumiditySensor;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.smartrplace.apps.humidity.warning.impl.HumidityController;
import org.smartrplace.apps.humidity.warning.impl.gui.HumidityPage;
import org.smartrplace.apps.humidity.warning.impl.pattern.HumidityPattern;
import org.smartrplace.apps.humidity.warning.impl.pattern.WarningConfigurationPattern;
import org.smartrplace.apps.humidity.warning.model.WarningConfiguration;

@Component(service={Application.class})
public class HumidityWarningApp
implements Application,
PatternListener<WarningConfigurationPattern>,
PatternChangeListener<WarningConfigurationPattern> {
    private static final String BASE_RESOURCE = "humidityWarningAppBase";
    private ApplicationManager appMan;
    private Logger logger;
    private NameService nameService;
    private MessagingService messagingService;
    private final Map<Room, HumidityController> configs = new HashMap<Room, HumidityController>();
    private HumidityListener humidityListener;
    private WidgetApp wapp;
    private ResourceList<WarningConfiguration> configsBase;
    @Reference
    private OgemaGuiService widgetService;

    public void start(ApplicationManager appManager) {
        this.appMan = appManager;
        this.logger = appManager.getLogger();
        this.nameService = this.widgetService.getNameService();
        this.messagingService = this.widgetService.getMessagingService();
        this.messagingService.registerMessagingApp(appManager.getAppID(), "Humidity Warning App");
        this.humidityListener = new HumidityListener(this.configs, appManager.getResourcePatternAccess());
        appManager.getResourcePatternAccess().addPatternDemand(WarningConfigurationPattern.class, (PatternListener)this, AccessPriority.PRIO_LOWEST);
        appManager.getResourcePatternAccess().addPatternDemand(HumidityPattern.class, (PatternListener)this.humidityListener, AccessPriority.PRIO_LOWEST);
        this.configsBase = (ResourceList)appManager.getResourceManagement().createResource(BASE_RESOURCE, ResourceList.class);
        this.configsBase.setElementType(WarningConfiguration.class);
        this.wapp = this.widgetService.createWidgetApp("/org/smartrplace/apps/humidity-warning", appManager);
        this.wapp.createLazyStartPage(page -> new HumidityPage((WidgetPage<?>)page, appManager.getResourcePatternAccess(), this.configsBase));
    }

    public void stop(Application.AppStopReason reason) {
        ApplicationManager appMan = this.appMan;
        MessagingService messagingService = this.messagingService;
        AppID appId = appMan != null ? appMan.getAppID() : null;
        WidgetApp wapp = this.wapp;
        if (appMan != null) {
            try {
                appMan.getResourcePatternAccess().removePatternDemand(WarningConfigurationPattern.class, (PatternListener)this);
                appMan.getResourcePatternAccess().removePatternDemand(HumidityPattern.class, (PatternListener)this.humidityListener);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (messagingService != null && appId != null) {
            try {
                messagingService.unregisterMessagingApp(appId);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.wapp = null;
        this.appMan = null;
        this.logger = null;
        this.humidityListener = null;
        this.messagingService = null;
        this.nameService = null;
        this.configsBase = null;
        if (wapp != null) {
            ForkJoinPool.commonPool().submit(() -> ((WidgetApp)wapp).close());
        }
    }

    public void patternAvailable(WarningConfigurationPattern pattern) {
        this.newPattern(pattern);
        this.appMan.getResourcePatternAccess().addPatternChangeListener((ResourcePattern)pattern, (PatternChangeListener)this, WarningConfigurationPattern.class);
    }

    private HumidityController newPattern(WarningConfigurationPattern pattern) {
        Room room = (Room)pattern.room.getLocationResource();
        if (this.configs.containsKey(room)) {
            this.logger.warn("Duplicate warning configuration {}, {}", (Object)pattern.model, (Object)this.configs.get(room).getConfig());
            return null;
        }
        HumidityController controller = new HumidityController(pattern, this.appMan, this.messagingService, this.nameService);
        this.configs.put(room, controller);
        this.humidityListener.patterns.values().stream().filter(sensor -> sensor.room.equalsLocation((Resource)room)).forEach(sensor -> controller.addSensor((HumidityPattern)((Object)sensor), false));
        controller.valueChanged();
        return controller;
    }

    private HumidityController patternGone(WarningConfigurationPattern pattern) {
        HumidityController controller;
        Room room = (Room)pattern.room.getLocationResource();
        if (this.configs.containsKey(room)) {
            controller = this.configs.remove(room);
        } else {
            Optional<HumidityController> opt = this.configs.values().stream().filter(c -> ((WarningConfiguration)c.getConfig().model).equalsLocation(pattern.model)).findAny();
            if (opt.isPresent()) {
                controller = opt.get();
                this.configs.values().remove(controller);
            } else {
                controller = null;
            }
        }
        if (controller != null) {
            controller.close();
        }
        return controller;
    }

    public void patternUnavailable(WarningConfigurationPattern pattern) {
        this.patternGone(pattern);
        this.appMan.getResourcePatternAccess().removePatternChangeListener((ResourcePattern)pattern, (PatternChangeListener)this);
    }

    public void patternChanged(WarningConfigurationPattern instance, List<CompoundResourceEvent<?>> changes) {
        this.patternGone(instance);
        this.newPattern(instance);
    }

    private static final class HumidityListener
    implements PatternListener<HumidityPattern>,
    PatternChangeListener<HumidityPattern> {
        private final Map<String, HumidityPattern> patterns = new HashMap<String, HumidityPattern>();
        private final Map<Room, HumidityController> configs;
        private final ResourcePatternAccess rpa;

        public HumidityListener(Map<Room, HumidityController> configs, ResourcePatternAccess rpa) {
            this.configs = configs;
            this.rpa = rpa;
        }

        public void patternChanged(HumidityPattern pattern, List<CompoundResourceEvent<?>> changes) {
            this.patterns.remove(((HumiditySensor)pattern.model).getLocation());
            this.patterns.put(((HumiditySensor)pattern.model).getLocation(), pattern);
        }

        private void newSensor(HumidityPattern pattern) {
            this.patterns.put(((HumiditySensor)pattern.model).getLocation(), pattern);
            HumidityController controller = this.configs.get(pattern.room.getLocationResource());
            if (controller != null) {
                controller.addSensor(pattern, true);
            }
        }

        private void sensorGone(HumidityPattern pattern) {
            this.patterns.remove(((HumiditySensor)pattern.model).getLocation());
            this.configs.values().forEach(controller -> controller.removeSensor(pattern));
        }

        public void patternAvailable(HumidityPattern pattern) {
            this.newSensor(pattern);
            this.rpa.addPatternChangeListener((ResourcePattern)pattern, (PatternChangeListener)this, HumidityPattern.class);
        }

        public void patternUnavailable(HumidityPattern pattern) {
            this.sensorGone(pattern);
            this.rpa.removePatternChangeListener((ResourcePattern)pattern, (PatternChangeListener)this);
        }
    }
}

