/*
 * Decompiled with CFR 0.152.
 */
package org.smartrplace.apps.humidity.warning.impl;

import de.iwes.widgets.api.messaging.Message;
import de.iwes.widgets.api.messaging.MessagePriority;
import de.iwes.widgets.api.services.MessagingService;
import de.iwes.widgets.api.services.NameService;
import de.iwes.widgets.api.widgets.localisation.OgemaLocale;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.DoubleStream;
import org.ogema.core.application.ApplicationManager;
import org.ogema.core.application.Timer;
import org.ogema.core.application.TimerListener;
import org.ogema.core.model.simple.BooleanResource;
import org.ogema.core.model.simple.FloatResource;
import org.ogema.core.model.simple.TimeResource;
import org.ogema.core.resourcemanager.ResourceStructureEvent;
import org.ogema.core.resourcemanager.ResourceStructureListener;
import org.ogema.core.resourcemanager.ResourceValueListener;
import org.ogema.model.prototypes.PhysicalElement;
import org.ogema.model.sensors.HumiditySensor;
import org.smartrplace.apps.humidity.warning.impl.MessageImpl;
import org.smartrplace.apps.humidity.warning.impl.Utils;
import org.smartrplace.apps.humidity.warning.impl.pattern.HumidityPattern;
import org.smartrplace.apps.humidity.warning.impl.pattern.WarningConfigurationPattern;
import org.smartrplace.apps.humidity.warning.model.WarningConfiguration;

class HumidityController
implements ResourceValueListener<FloatResource>,
TimerListener {
    private static final long DEFAULT_MIN_WARN_ITV = 3600000L;
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private final ApplicationManager appMan;
    private final MessagingService messagingService;
    private final NameService nameService;
    private final Map<String, HumidityPattern> sensors = new HashMap<String, HumidityPattern>(4);
    private final WarningConfigurationPattern config;
    private final Thresholdlistener thresholdListener = new Thresholdlistener(this);
    private float lastHumidityMax;
    private float lastHumidityMin;
    private float lastDewPointCelsius;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private long upperViolatingSince = Long.MAX_VALUE;
    private long lowerViolatingSince = Long.MAX_VALUE;
    private Timer timer;

    HumidityController(WarningConfigurationPattern config, ApplicationManager appMan, MessagingService messaging, NameService nameService) {
        this.config = config;
        this.appMan = appMan;
        this.messagingService = messaging;
        this.nameService = nameService;
        config.lowerThresholdHumidity.addStructureListener((ResourceStructureListener)this.thresholdListener);
        config.lowerThresholdHumidity.addValueListener((ResourceValueListener)this.thresholdListener);
        config.upperThresholdHumidity.addStructureListener((ResourceStructureListener)this.thresholdListener);
        config.upperThresholdHumidity.addValueListener((ResourceValueListener)this.thresholdListener);
    }

    WarningConfigurationPattern getConfig() {
        return this.config;
    }

    void valueChanged() {
        if (this.closed.get() || this.sensors.isEmpty()) {
            return;
        }
        float maxHumidity = HumidityController.getMaxHumidity(this, true);
        float minHumidity = HumidityController.getMaxHumidity(this, false);
        if (Float.isFinite(maxHumidity) && Float.isFinite(minHumidity)) {
            this.checkWarning(maxHumidity, minHumidity);
        }
        this.lastHumidityMax = maxHumidity;
        this.lastHumidityMin = minHumidity;
    }

    private void checkWarning(float maxHumidity, float minHumidity) {
        long next;
        boolean lowWarning;
        float upperThreshold = this.config.upperThresholdHumidity.isActive() ? this.config.upperThresholdHumidity.getValue() : Float.NaN;
        float lowerThreshold = this.config.lowerThresholdHumidity.isActive() ? this.config.lowerThresholdHumidity.getValue() : Float.NaN;
        boolean isHighHumidity = Float.isFinite(upperThreshold) && maxHumidity > upperThreshold;
        boolean isLowHumidity = Float.isFinite(lowerThreshold) && maxHumidity < lowerThreshold;
        long time = this.appMan.getFrameworkTime();
        long minItv = this.getMinInterval();
        boolean highWarning = isHighHumidity && !((WarningConfiguration)this.config.model).isHigh() && (!this.config.lastWarningHighHumidity.isActive() || time - this.config.lastWarningHighHumidity.getValue() > minItv);
        boolean bl = lowWarning = isLowHumidity && !((WarningConfiguration)this.config.model).isLow() && (!this.config.lastWarningLowHumidity.isActive() || time - this.config.lastWarningLowHumidity.getValue() > minItv);
        if (!isHighHumidity) {
            ((WarningConfiguration)this.config.model).setHigh(false);
        }
        if (!isLowHumidity) {
            ((WarningConfiguration)this.config.model).setLow(false);
        }
        long nextExecHigh = Long.MAX_VALUE;
        if (highWarning) {
            long timeout;
            long l = timeout = this.config.upperTimeout.isActive() ? this.config.upperTimeout.getValue() : 0L;
            if (this.upperViolatingSince == Long.MAX_VALUE) {
                this.upperViolatingSince = time;
                if (timeout > 0L) {
                    highWarning = false;
                    nextExecHigh = timeout + 1000L;
                }
            } else if (time < this.upperViolatingSince + timeout) {
                highWarning = false;
                nextExecHigh = this.upperViolatingSince + timeout - time + 1000L;
            } else {
                this.upperViolatingSince = Long.MAX_VALUE;
            }
        } else {
            this.upperViolatingSince = Long.MAX_VALUE;
        }
        long nextExecLow = Long.MAX_VALUE;
        if (lowWarning) {
            long timeout;
            long l = timeout = this.config.lowerTimeout.isActive() ? this.config.lowerTimeout.getValue() : 0L;
            if (this.lowerViolatingSince == Long.MAX_VALUE) {
                this.lowerViolatingSince = time;
                if (timeout > 0L) {
                    nextExecLow = timeout + 1000L;
                    lowWarning = false;
                }
            } else if (time < this.lowerViolatingSince + timeout) {
                lowWarning = false;
                nextExecLow = this.lowerViolatingSince + timeout - time + 1000L;
            } else {
                this.lowerViolatingSince = Long.MAX_VALUE;
            }
        } else {
            this.lowerViolatingSince = Long.MAX_VALUE;
        }
        if (lowWarning || highWarning) {
            StringBuilder messageBuilder = new StringBuilder();
            if (highWarning) {
                this.appendHumidityLevelWarning((int)(maxHumidity * 100.0f), (int)(upperThreshold * 100.0f), true, time, messageBuilder);
                ((WarningConfiguration)this.config.model).setHigh(true);
            }
            if (lowWarning) {
                if (highWarning) {
                    messageBuilder.append("\r\n");
                }
                this.appendHumidityLevelWarning((int)(minHumidity * 100.0f), (int)(lowerThreshold * 100.0f), false, time, messageBuilder);
                ((WarningConfiguration)this.config.model).setLow(true);
            }
            this.sendWarning(messageBuilder, MessagePriority.MEDIUM);
            if (lowWarning) {
                ((TimeResource)this.config.lastWarningLowHumidity.create()).setValue(time);
                this.config.lastWarningLowHumidity.activate(false);
            }
            if (highWarning) {
                ((TimeResource)this.config.lastWarningHighHumidity.create()).setValue(time);
                this.config.lastWarningHighHumidity.activate(false);
            }
        }
        if ((next = Math.min(nextExecHigh, nextExecLow)) != Long.MAX_VALUE) {
            if (this.timer == null) {
                this.timer = this.appMan.createTimer(next, (TimerListener)this);
            } else {
                this.timer.setTimingInterval(next);
                this.timer.resume();
            }
        } else if (this.timer != null) {
            this.timer.destroy();
            this.timer = null;
        }
    }

    private long getMinInterval() {
        if (((WarningConfiguration)this.config.model).minWarningInterval().isActive()) {
            return ((WarningConfiguration)this.config.model).minWarningInterval().getValue();
        }
        return 3600000L;
    }

    private void appendHumidityLevelWarning(int value, int threshold, boolean highOrLow, long time, StringBuilder sb) {
        sb.append("Humidity in room ").append(Utils.getName((PhysicalElement)this.config.room.getLocationResource(), this.nameService, OgemaLocale.ENGLISH)).append(" has ");
        if (highOrLow) {
            sb.append("exceeded");
        } else {
            sb.append("fallen below");
        }
        sb.append(" the threshold value ").append(threshold).append("%. New value: ").append(value).append('%').append(", time: ");
        ZonedDateTime zdt = ZonedDateTime.ofInstant(Instant.ofEpochMilli(time), ZoneId.systemDefault());
        sb.append(formatter.format(zdt)).append('.');
    }

    private void sendWarning(StringBuilder msg, MessagePriority prio) {
        MessageImpl message = new MessageImpl("Humidity warning", msg.toString(), prio);
        this.messagingService.sendMessage(this.appMan, (Message)message);
    }

    void addSensor(HumidityPattern sensor, boolean triggerCheck) {
        if (this.closed.get()) {
            return;
        }
        this.sensors.put(((HumiditySensor)sensor.model).getLocation(), sensor);
        sensor.reading.addValueListener((ResourceValueListener)this);
        if (triggerCheck) {
            this.valueChanged();
        }
    }

    void removeSensor(HumidityPattern sensor) {
        if (this.closed.get()) {
            return;
        }
        if (this.sensors.remove(((HumiditySensor)sensor.model).getLocation()) != null) {
            sensor.reading.removeValueListener((ResourceValueListener)this);
            this.valueChanged();
        }
    }

    void close() {
        if (this.closed.getAndSet(true)) {
            return;
        }
        this.sensors.values().forEach(sensor -> sensor.reading.removeValueListener((ResourceValueListener)this));
        this.sensors.clear();
        this.config.lowerThresholdHumidity.removeStructureListener((ResourceStructureListener)this.thresholdListener);
        this.config.lowerThresholdHumidity.removeValueListener((ResourceValueListener)this.thresholdListener);
        this.config.upperThresholdHumidity.removeStructureListener((ResourceStructureListener)this.thresholdListener);
        this.config.upperThresholdHumidity.removeValueListener((ResourceValueListener)this.thresholdListener);
        if (this.timer != null) {
            this.timer.destroy();
            this.timer = null;
        }
    }

    public void resourceChanged(FloatResource resource) {
        this.valueChanged();
    }

    public void timerElapsed(Timer timer) {
        timer.stop();
        this.valueChanged();
    }

    private static final float getMaxHumidity(HumidityController controller, boolean maxOrMin) {
        BooleanResource avgres = ((WarningConfiguration)controller.config.model).useRoomAverage();
        boolean avg = avgres.isActive() ? avgres.getValue() : false;
        DoubleStream ds = controller.sensors.values().stream().mapToDouble(sensor -> sensor.reading.getValue()).filter(value -> value >= 0.0 && value <= 1.0);
        OptionalDouble opt = avg ? ds.average() : (maxOrMin ? ds.max() : ds.min());
        return (float)(opt.isPresent() ? opt.getAsDouble() : Double.NaN);
    }

    private static class Thresholdlistener
    implements ResourceStructureListener,
    ResourceValueListener<FloatResource> {
        private final HumidityController controller;

        public Thresholdlistener(HumidityController controller) {
            this.controller = controller;
        }

        public void resourceChanged(FloatResource resource) {
            this.controller.valueChanged();
        }

        public void resourceStructureChanged(ResourceStructureEvent event) {
            switch (event.getType()) {
                case RESOURCE_ACTIVATED: 
                case RESOURCE_CREATED: {
                    this.controller.valueChanged();
                }
            }
        }
    }
}

