/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.socket.transport;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartboot.socket.buffer.BufferPage;
import org.smartboot.socket.buffer.VirtualBuffer;
import org.smartboot.socket.transport.AioSession;
import org.smartboot.socket.transport.IoServerConfig;
import org.smartboot.socket.transport.UdpAioSession;
import org.smartboot.socket.transport.Worker;

public final class UdpChannel {
    private static final Logger LOGGER = LoggerFactory.getLogger(UdpChannel.class);
    private final BufferPage bufferPage;
    private ConcurrentLinkedQueue<ResponseUnit> responseTasks;
    private final Semaphore writeSemaphore = new Semaphore(1);
    private Worker worker;
    final IoServerConfig config;
    private final DatagramChannel channel;
    private SelectionKey selectionKey;
    private ResponseUnit failResponseUnit;

    UdpChannel(DatagramChannel channel, IoServerConfig config, BufferPage bufferPage) {
        this.channel = channel;
        this.bufferPage = bufferPage;
        this.config = config;
    }

    UdpChannel(DatagramChannel channel, Worker worker, IoServerConfig config, BufferPage bufferPage) {
        this(channel, config, bufferPage);
        this.responseTasks = new ConcurrentLinkedQueue();
        this.worker = worker;
        worker.addRegister(selector -> {
            try {
                this.selectionKey = channel.register((Selector)selector, 1, this);
            }
            catch (ClosedChannelException e) {
                e.printStackTrace();
            }
        });
    }

    void write(VirtualBuffer virtualBuffer, UdpAioSession session) {
        if (this.writeSemaphore.tryAcquire() && this.responseTasks.isEmpty() && this.send(virtualBuffer.buffer(), session) > 0) {
            virtualBuffer.clean();
            this.writeSemaphore.release();
            session.writeBuffer().flush();
            return;
        }
        this.responseTasks.offer(new ResponseUnit(session, virtualBuffer));
        if (this.selectionKey == null) {
            this.worker.addRegister(selector -> this.selectionKey.interestOps(this.selectionKey.interestOps() | 4));
        } else if ((this.selectionKey.interestOps() & 4) == 0) {
            this.selectionKey.interestOps(this.selectionKey.interestOps() | 4);
        }
    }

    void doWrite() {
        ResponseUnit responseUnit;
        while (true) {
            if (this.failResponseUnit == null) {
                responseUnit = this.responseTasks.poll();
            } else {
                responseUnit = this.failResponseUnit;
                this.failResponseUnit = null;
            }
            if (responseUnit == null) {
                this.writeSemaphore.release();
                if (this.responseTasks.isEmpty()) {
                    this.selectionKey.interestOps(this.selectionKey.interestOps() & 0xFFFFFFFB);
                    if (!this.responseTasks.isEmpty()) {
                        this.selectionKey.interestOps(this.selectionKey.interestOps() | 4);
                    }
                }
                return;
            }
            if (this.send(responseUnit.response.buffer(), responseUnit.session) <= 0) break;
            responseUnit.response.clean();
            responseUnit.session.writeBuffer().flush();
        }
        this.failResponseUnit = responseUnit;
        LOGGER.warn("send fail,will retry...");
    }

    private int send(ByteBuffer byteBuffer, UdpAioSession session) {
        if (this.config.getMonitor() != null) {
            this.config.getMonitor().beforeWrite((AioSession)session);
        }
        int size = 0;
        try {
            size = this.channel.send(byteBuffer, session.getRemoteAddress());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (this.config.getMonitor() != null) {
            this.config.getMonitor().afterWrite((AioSession)session, size);
        }
        return size;
    }

    public AioSession connect(SocketAddress remote) {
        return new UdpAioSession(this, remote, this.bufferPage);
    }

    public AioSession connect(String host, int port) {
        return this.connect(new InetSocketAddress(host, port));
    }

    public void close() {
        ResponseUnit task;
        LOGGER.info("close channel...");
        if (this.selectionKey != null) {
            Selector selector = this.selectionKey.selector();
            this.selectionKey.cancel();
            selector.wakeup();
            this.selectionKey = null;
        }
        try {
            if (this.channel != null) {
                this.channel.close();
            }
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
        }
        while ((task = this.responseTasks.poll()) != null) {
            task.response.clean();
        }
        if (this.failResponseUnit != null) {
            this.failResponseUnit.response.clean();
        }
    }

    BufferPage getBufferPage() {
        return this.bufferPage;
    }

    DatagramChannel getChannel() {
        return this.channel;
    }

    static final class ResponseUnit {
        private final UdpAioSession session;
        private final VirtualBuffer response;

        public ResponseUnit(UdpAioSession session, VirtualBuffer response) {
            this.session = session;
            this.response = response;
        }
    }
}

