/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.socket.transport;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.DatagramChannel;
import org.smartboot.socket.MessageProcessor;
import org.smartboot.socket.Protocol;
import org.smartboot.socket.buffer.BufferFactory;
import org.smartboot.socket.buffer.BufferPagePool;
import org.smartboot.socket.transport.IoServerConfig;
import org.smartboot.socket.transport.UdpChannel;
import org.smartboot.socket.transport.Worker;

public class UdpBootstrap {
    private BufferPagePool bufferPool;
    private BufferPagePool innerBufferPool = null;
    private final IoServerConfig config = new IoServerConfig();
    private Worker worker;
    private boolean innerWorker = false;

    public <Request> UdpBootstrap(Protocol<Request> protocol, MessageProcessor<Request> messageProcessor, Worker worker) {
        this(protocol, messageProcessor);
        this.worker = worker;
    }

    public <Request> UdpBootstrap(Protocol<Request> protocol, MessageProcessor<Request> messageProcessor) {
        this.config.setProtocol(protocol);
        this.config.setProcessor(messageProcessor);
    }

    public UdpChannel open() throws IOException {
        return this.open(0);
    }

    public UdpChannel open(int port) throws IOException {
        return this.open(null, port);
    }

    public UdpChannel open(String host, int port) throws IOException {
        if (this.config.isBannerEnabled()) {
            System.out.println("\n                               _                           _             _   \n                              ( )_                        ( )           ( )_ \n  ___   ___ ___     _ _  _ __ | ,_)     ___    _      ___ | |/')    __  | ,_)\n/',__)/' _ ` _ `\\ /'_` )( '__)| |     /',__) /'_`\\  /'___)| , <   /'__`\\| |  \n\\__, \\| ( ) ( ) |( (_| || |   | |_    \\__, \\( (_) )( (___ | |\\`\\ (  ___/| |_ \n(____/(_) (_) (_)`\\__,_)(_)   `\\__)   (____/`\\___/'`\\____)(_) (_)`\\____)`\\__)\r\n :: smart-socket[udp] ::\t(v1.6.6)");
        }
        if (this.bufferPool == null) {
            this.innerBufferPool = this.bufferPool = this.config.getBufferFactory().create();
        }
        if (this.worker == null) {
            this.innerWorker = true;
            this.worker = new Worker(this.bufferPool, this.config.getThreadNum());
        }
        DatagramChannel channel = DatagramChannel.open();
        channel.configureBlocking(false);
        if (port > 0) {
            InetSocketAddress inetSocketAddress = host == null ? new InetSocketAddress(port) : new InetSocketAddress(host, port);
            channel.socket().bind(inetSocketAddress);
        }
        return new UdpChannel(channel, this.worker, this.config, this.bufferPool.allocateBufferPage());
    }

    private synchronized void initWorker() throws IOException {
        if (this.worker != null) {
            return;
        }
    }

    public void shutdown() {
        if (this.innerWorker) {
            this.worker.shutdown();
        }
        if (this.innerBufferPool != null) {
            this.innerBufferPool.release();
        }
    }

    public final UdpBootstrap setReadBufferSize(int size) {
        this.config.setReadBufferSize(size);
        return this;
    }

    public final UdpBootstrap setThreadNum(int num) {
        this.config.setThreadNum(num);
        return this;
    }

    public final UdpBootstrap setBannerEnabled(boolean bannerEnabled) {
        this.config.setBannerEnabled(bannerEnabled);
        return this;
    }

    public final UdpBootstrap setBufferPagePool(BufferPagePool bufferPool) {
        this.bufferPool = bufferPool;
        this.config.setBufferFactory(BufferFactory.DISABLED_BUFFER_FACTORY);
        return this;
    }

    public final UdpBootstrap setBufferFactory(BufferFactory bufferFactory) {
        this.config.setBufferFactory(bufferFactory);
        this.bufferPool = null;
        return this;
    }
}

