/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.socket.timer;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import org.smartboot.socket.timer.Timer;
import org.smartboot.socket.timer.TimerTask;

public class HashedWheelTimer
implements Timer,
Runnable {
    private final long tickDuration;
    private final HashedWheelBucket[] wheel;
    private final int mask;
    private final Queue<HashedWheelTimerTask> newTimeouts = new ConcurrentLinkedQueue<HashedWheelTimerTask>();
    private final Queue<HashedWheelTimerTask> cancelledTimeouts = new ConcurrentLinkedQueue<HashedWheelTimerTask>();
    private final AtomicLong pendingTimeouts = new AtomicLong(0L);
    private volatile long startTime;
    private boolean running = true;
    public static final HashedWheelTimer DEFAULT_TIMER = new HashedWheelTimer(r -> new Thread(r, "defaultHashedWheelTimer"));
    private long tick;

    public HashedWheelTimer(ThreadFactory threadFactory) {
        this(threadFactory, 100L, 512);
    }

    public HashedWheelTimer(ThreadFactory threadFactory, long tickDuration, int ticksPerWheel) {
        this.wheel = HashedWheelTimer.createWheel(ticksPerWheel);
        this.mask = this.wheel.length - 1;
        this.tickDuration = TimeUnit.MILLISECONDS.toNanos(tickDuration);
        Thread workerThread = threadFactory.newThread(this);
        workerThread.start();
    }

    private static HashedWheelBucket[] createWheel(int ticksPerWheel) {
        ticksPerWheel = HashedWheelTimer.normalizeTicksPerWheel(ticksPerWheel);
        HashedWheelBucket[] wheel = new HashedWheelBucket[ticksPerWheel];
        for (int i = 0; i < wheel.length; ++i) {
            wheel[i] = new HashedWheelBucket();
        }
        return wheel;
    }

    private static int normalizeTicksPerWheel(int ticksPerWheel) {
        int n = ticksPerWheel - 1;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        return (n |= n >>> 16) < 0 ? 1 : (n >= 0x40000000 ? 0x40000000 : n + 1);
    }

    @Override
    public void shutdown() {
        this.running = false;
    }

    @Override
    public TimerTask scheduleWithFixedDelay(final Runnable runnable, final long delay, final TimeUnit unit) {
        return this.schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    runnable.run();
                }
                finally {
                    HashedWheelTimer.this.schedule(this, delay, unit);
                }
            }
        }, delay, unit);
    }

    @Override
    public TimerTask schedule(Runnable runnable, long delay, TimeUnit unit) {
        long deadline = System.nanoTime() + unit.toNanos(delay) - this.startTime;
        if (deadline <= 0L) {
            throw new IllegalArgumentException();
        }
        this.pendingTimeouts.incrementAndGet();
        HashedWheelTimerTask timeout = new HashedWheelTimerTask(this, runnable, deadline);
        this.newTimeouts.add(timeout);
        return timeout;
    }

    public long pendingTimeouts() {
        return this.pendingTimeouts.get();
    }

    @Override
    public void run() {
        this.startTime = System.nanoTime();
        while (this.running) {
            long deadline = this.waitForNextTick();
            this.processCancelledTasks();
            this.transferTimeoutsToBuckets();
            this.wheel[(int)(this.tick & (long)this.mask)].execute(deadline);
            ++this.tick;
        }
    }

    private void transferTimeoutsToBuckets() {
        HashedWheelTimerTask timeout;
        for (int i = 0; i < 100000 && (timeout = this.newTimeouts.poll()) != null; ++i) {
            if (timeout.state() == 1) continue;
            long calculated = timeout.deadline / this.tickDuration;
            timeout.remainingRounds = (calculated - this.tick) / (long)this.wheel.length;
            long ticks = Math.max(calculated, this.tick);
            int stopIndex = (int)(ticks & (long)this.mask);
            HashedWheelBucket bucket = this.wheel[stopIndex];
            bucket.addTimeout(timeout);
        }
    }

    private void processCancelledTasks() {
        HashedWheelTimerTask timeout;
        while ((timeout = this.cancelledTimeouts.poll()) != null) {
            timeout.remove();
        }
    }

    private long waitForNextTick() {
        long deadline = this.tickDuration * (this.tick + 1L);
        while (true) {
            long currentTime;
            long sleepTimeMs;
            if ((sleepTimeMs = (deadline - (currentTime = System.nanoTime() - this.startTime) + 999999L) / 1000000L) <= 0L) {
                if (currentTime <= 0L) {
                    System.out.println("System.nanoTime() is overflow");
                    return this.waitForNextTick();
                }
                return currentTime;
            }
            try {
                Thread.sleep(sleepTimeMs);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static final class HashedWheelBucket {
        private HashedWheelTimerTask head;
        private HashedWheelTimerTask tail;

        private HashedWheelBucket() {
        }

        public void addTimeout(HashedWheelTimerTask timeout) {
            assert (timeout.bucket == null);
            timeout.bucket = this;
            if (this.head == null) {
                this.head = this.tail = timeout;
            } else {
                this.tail.next = timeout;
                timeout.prev = this.tail;
                this.tail = timeout;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void execute(long deadline) {
            HashedWheelTimerTask timeout = this.head;
            while (timeout != null) {
                HashedWheelTimerTask next = timeout.next;
                if (timeout.remainingRounds <= 0L) {
                    next = this.remove(timeout);
                    if (timeout.deadline > deadline) throw new IllegalStateException();
                    timeout.execute();
                } else if (timeout.isCancelled()) {
                    next = this.remove(timeout);
                } else {
                    --timeout.remainingRounds;
                }
                timeout = next;
            }
        }

        public HashedWheelTimerTask remove(HashedWheelTimerTask timeout) {
            HashedWheelTimerTask next = timeout.next;
            if (timeout.prev != null) {
                timeout.prev.next = next;
            }
            if (timeout.next != null) {
                timeout.next.prev = timeout.prev;
            }
            if (timeout == this.head) {
                if (timeout == this.tail) {
                    this.tail = null;
                    this.head = null;
                } else {
                    this.head = next;
                }
            } else if (timeout == this.tail) {
                this.tail = timeout.prev;
            }
            timeout.prev = null;
            timeout.next = null;
            timeout.bucket = null;
            timeout.timer.pendingTimeouts.decrementAndGet();
            return next;
        }
    }

    private static final class HashedWheelTimerTask
    implements TimerTask {
        private static final int ST_INIT = 0;
        private static final int ST_CANCELLED = 1;
        private static final int ST_EXPIRED = 2;
        private static final AtomicIntegerFieldUpdater<HashedWheelTimerTask> STATE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(HashedWheelTimerTask.class, "state");
        private final HashedWheelTimer timer;
        private final Runnable runnable;
        private final long deadline;
        private volatile int state = 0;
        long remainingRounds;
        HashedWheelTimerTask next;
        HashedWheelTimerTask prev;
        HashedWheelBucket bucket;

        HashedWheelTimerTask(HashedWheelTimer timer, Runnable runnable, long deadline) {
            this.timer = timer;
            this.runnable = runnable;
            this.deadline = deadline;
        }

        @Override
        public boolean cancel() {
            if (!this.compareAndSetState(0, 1)) {
                return false;
            }
            this.timer.cancelledTimeouts.add(this);
            return true;
        }

        void remove() {
            HashedWheelBucket bucket = this.bucket;
            if (bucket != null) {
                bucket.remove(this);
            } else {
                this.timer.pendingTimeouts.decrementAndGet();
            }
        }

        public boolean compareAndSetState(int expected, int state) {
            return STATE_UPDATER.compareAndSet(this, expected, state);
        }

        public int state() {
            return this.state;
        }

        @Override
        public boolean isCancelled() {
            return this.state() == 1;
        }

        @Override
        public boolean isDone() {
            return this.state() == 2;
        }

        public void execute() {
            if (!this.compareAndSetState(0, 2)) {
                return;
            }
            try {
                this.runnable.run();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }

        public String toString() {
            long currentTime = System.nanoTime();
            long remaining = this.deadline - currentTime + this.timer.startTime;
            StringBuilder buf = new StringBuilder(192).append(this.getClass().getSimpleName()).append('(').append("deadline: ");
            if (remaining > 0L) {
                buf.append(remaining).append(" ns later");
            } else if (remaining < 0L) {
                buf.append(-remaining).append(" ns ago");
            } else {
                buf.append("now");
            }
            if (this.isCancelled()) {
                buf.append(", cancelled");
            }
            return buf.append(", task: ").append(this.runnable).append(')').toString();
        }
    }
}

