/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.socket.extension.ssl;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartboot.socket.buffer.BufferPage;
import org.smartboot.socket.extension.ssl.ClientAuth;
import org.smartboot.socket.extension.ssl.HandshakeModel;

public final class SslService {
    private static final Logger logger = LoggerFactory.getLogger(SslService.class);
    private SSLContext sslContext;
    private boolean isClient;
    private ClientAuth clientAuth;
    private CompletionHandler<Integer, HandshakeModel> handshakeCompletionHandler = new CompletionHandler<Integer, HandshakeModel>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void completed(Integer result, HandshakeModel attachment) {
            if (result == -1) {
                attachment.setEof(true);
            }
            HandshakeModel handshakeModel = attachment;
            synchronized (handshakeModel) {
                SslService.this.doHandshake(attachment);
            }
        }

        @Override
        public void failed(Throwable exc, HandshakeModel attachment) {
            attachment.setEof(true);
            attachment.getHandshakeCallback().callback();
        }
    };

    public SslService(boolean isClient, ClientAuth clientAuth) {
        this.isClient = isClient;
        this.clientAuth = clientAuth;
    }

    public void initKeyStore(InputStream keyStoreInputStream, String keyStorePassword, String keyPassword) {
        try {
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(keyStoreInputStream, keyStorePassword.toCharArray());
            kmf.init(ks, keyPassword.toCharArray());
            KeyManager[] keyManagers = kmf.getKeyManagers();
            this.sslContext = SSLContext.getInstance("TLS");
            this.sslContext.init(keyManagers, null, new SecureRandom());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initTrust(InputStream trustInputStream, String trustPassword) {
        try {
            TrustManager[] trustManagers;
            if (trustInputStream != null) {
                KeyStore ts = KeyStore.getInstance("JKS");
                ts.load(trustInputStream, trustPassword.toCharArray());
                TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
                tmf.init(ts);
                trustManagers = tmf.getTrustManagers();
            } else {
                trustManagers = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return new X509Certificate[0];
                    }
                }};
            }
            this.sslContext = SSLContext.getInstance("TLS");
            this.sslContext.init(null, trustManagers, new SecureRandom());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    HandshakeModel createSSLEngine(AsynchronousSocketChannel socketChannel, BufferPage bufferPage) {
        try {
            HandshakeModel handshakeModel = new HandshakeModel();
            SSLEngine sslEngine = this.sslContext.createSSLEngine();
            SSLSession session = sslEngine.getSession();
            sslEngine.setUseClientMode(this.isClient);
            if (this.clientAuth != null) {
                switch (this.clientAuth) {
                    case OPTIONAL: {
                        sslEngine.setWantClientAuth(true);
                        break;
                    }
                    case REQUIRE: {
                        sslEngine.setNeedClientAuth(true);
                        break;
                    }
                    case NONE: {
                        break;
                    }
                    default: {
                        throw new Error("Unknown auth " + (Object)((Object)this.clientAuth));
                    }
                }
            }
            handshakeModel.setSslEngine(sslEngine);
            handshakeModel.setAppWriteBuffer(bufferPage.allocate(session.getApplicationBufferSize()));
            handshakeModel.setNetWriteBuffer(bufferPage.allocate(session.getPacketBufferSize()));
            handshakeModel.getNetWriteBuffer().buffer().flip();
            handshakeModel.setAppReadBuffer(bufferPage.allocate(session.getApplicationBufferSize()));
            handshakeModel.setNetReadBuffer(bufferPage.allocate(session.getPacketBufferSize()));
            sslEngine.beginHandshake();
            handshakeModel.setSocketChannel(socketChannel);
            return handshakeModel;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void doHandshake(HandshakeModel handshakeModel) {
        SSLEngineResult result = null;
        try {
            SSLEngineResult.HandshakeStatus handshakeStatus = null;
            ByteBuffer netReadBuffer = handshakeModel.getNetReadBuffer().buffer();
            ByteBuffer appReadBuffer = handshakeModel.getAppReadBuffer().buffer();
            ByteBuffer netWriteBuffer = handshakeModel.getNetWriteBuffer().buffer();
            ByteBuffer appWriteBuffer = handshakeModel.getAppWriteBuffer().buffer();
            SSLEngine engine = handshakeModel.getSslEngine();
            if (handshakeModel.isEof()) {
                logger.info("the ssl handshake is terminated");
                handshakeModel.getHandshakeCallback().callback();
                return;
            }
            block22: while (!handshakeModel.isFinished()) {
                handshakeStatus = engine.getHandshakeStatus();
                if (logger.isDebugEnabled()) {
                    logger.info("\u63e1\u624b\u72b6\u6001:" + (Object)((Object)handshakeStatus));
                }
                switch (handshakeStatus) {
                    case NEED_UNWRAP: {
                        netReadBuffer.flip();
                        if (!netReadBuffer.hasRemaining()) {
                            netReadBuffer.clear();
                            handshakeModel.getSocketChannel().read(netReadBuffer, handshakeModel, this.handshakeCompletionHandler);
                            return;
                        }
                        result = engine.unwrap(netReadBuffer, appReadBuffer);
                        netReadBuffer.compact();
                        if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
                            handshakeModel.setFinished(true);
                            netReadBuffer.clear();
                        }
                        switch (result.getStatus()) {
                            case OK: {
                                continue block22;
                            }
                            case BUFFER_OVERFLOW: {
                                logger.warn("doHandshake BUFFER_OVERFLOW");
                                continue block22;
                            }
                            case BUFFER_UNDERFLOW: {
                                logger.warn("doHandshake BUFFER_UNDERFLOW");
                                return;
                            }
                        }
                        throw new IllegalStateException("Invalid SSL status: " + (Object)((Object)result.getStatus()));
                    }
                    case NEED_WRAP: {
                        if (netWriteBuffer.hasRemaining()) {
                            logger.info("\u6570\u636e\u672a\u8f93\u51fa\u5b8c\u6bd5...");
                            handshakeModel.getSocketChannel().write(netWriteBuffer, handshakeModel, this.handshakeCompletionHandler);
                            return;
                        }
                        netWriteBuffer.clear();
                        result = engine.wrap(appWriteBuffer, netWriteBuffer);
                        switch (result.getStatus()) {
                            case OK: {
                                appWriteBuffer.clear();
                                netWriteBuffer.flip();
                                if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
                                    handshakeModel.setFinished(true);
                                }
                                handshakeModel.getSocketChannel().write(netWriteBuffer, handshakeModel, this.handshakeCompletionHandler);
                                return;
                            }
                            case BUFFER_OVERFLOW: {
                                logger.warn("NEED_WRAP BUFFER_OVERFLOW");
                                continue block22;
                            }
                            case BUFFER_UNDERFLOW: {
                                throw new SSLException("Buffer underflow occured after a wrap. I don't think we should ever get here.");
                            }
                            case CLOSED: {
                                logger.warn("closed");
                                try {
                                    netWriteBuffer.flip();
                                    netReadBuffer.clear();
                                }
                                catch (Exception e) {
                                    logger.warn("Failed to send server's CLOSE message due to socket channel's failure.");
                                }
                                continue block22;
                            }
                        }
                        throw new IllegalStateException("Invalid SSL status: " + (Object)((Object)result.getStatus()));
                    }
                    case NEED_TASK: {
                        Runnable task;
                        while ((task = engine.getDelegatedTask()) != null) {
                            task.run();
                        }
                        continue block22;
                    }
                    case FINISHED: {
                        logger.info("HandshakeFinished");
                        continue block22;
                    }
                    case NOT_HANDSHAKING: {
                        logger.error("NOT_HANDSHAKING");
                        continue block22;
                    }
                }
                throw new IllegalStateException("Invalid SSL status: " + (Object)((Object)handshakeStatus));
            }
            if (logger.isDebugEnabled()) {
                logger.debug("\u63e1\u624b\u5b8c\u6bd5");
            }
            handshakeModel.getHandshakeCallback().callback();
        }
        catch (Exception e) {
            logger.warn("ignore doHandshake exception: {}", (Object)e.getMessage());
            handshakeModel.setEof(true);
            handshakeModel.getHandshakeCallback().callback();
        }
    }
}

