/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.socket.extension.ssl;

import java.io.IOException;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartboot.socket.buffer.BufferPage;
import org.smartboot.socket.buffer.VirtualBuffer;
import org.smartboot.socket.extension.ssl.HandshakeCallback;
import org.smartboot.socket.extension.ssl.HandshakeModel;
import org.smartboot.socket.extension.ssl.SslService;

public class SslAsynchronousSocketChannel
extends AsynchronousSocketChannel {
    private static final Logger logger = LoggerFactory.getLogger(SslAsynchronousSocketChannel.class);
    private final VirtualBuffer netWriteBuffer;
    private final VirtualBuffer netReadBuffer;
    private final VirtualBuffer appReadBuffer;
    private final AsynchronousSocketChannel asynchronousSocketChannel;
    private SSLEngine sslEngine = null;
    private HandshakeModel handshakeModel;
    private SslService sslService;
    private boolean handshake = true;
    private int adaptiveWriteSize = -1;

    public SslAsynchronousSocketChannel(AsynchronousSocketChannel asynchronousSocketChannel, SslService sslService, BufferPage bufferPage) {
        super(null);
        this.handshakeModel = sslService.createSSLEngine(asynchronousSocketChannel, bufferPage);
        this.sslService = sslService;
        this.asynchronousSocketChannel = asynchronousSocketChannel;
        this.sslEngine = this.handshakeModel.getSslEngine();
        this.netWriteBuffer = this.handshakeModel.getNetWriteBuffer();
        this.netReadBuffer = this.handshakeModel.getNetReadBuffer();
        this.appReadBuffer = this.handshakeModel.getAppReadBuffer();
    }

    @Override
    public AsynchronousSocketChannel bind(SocketAddress local) throws IOException {
        return this.asynchronousSocketChannel.bind(local);
    }

    @Override
    public <T> AsynchronousSocketChannel setOption(SocketOption<T> name, T value) throws IOException {
        return this.asynchronousSocketChannel.setOption((SocketOption)name, (Object)value);
    }

    @Override
    public <T> T getOption(SocketOption<T> name) throws IOException {
        return this.asynchronousSocketChannel.getOption(name);
    }

    @Override
    public Set<SocketOption<?>> supportedOptions() {
        return this.asynchronousSocketChannel.supportedOptions();
    }

    @Override
    public AsynchronousSocketChannel shutdownInput() throws IOException {
        return this.asynchronousSocketChannel.shutdownInput();
    }

    @Override
    public AsynchronousSocketChannel shutdownOutput() throws IOException {
        return this.asynchronousSocketChannel.shutdownOutput();
    }

    @Override
    public SocketAddress getRemoteAddress() throws IOException {
        return this.asynchronousSocketChannel.getRemoteAddress();
    }

    @Override
    public <A> void connect(SocketAddress remote, A attachment, CompletionHandler<Void, ? super A> handler) {
        this.asynchronousSocketChannel.connect(remote, attachment, handler);
    }

    @Override
    public Future<Void> connect(SocketAddress remote) {
        return this.asynchronousSocketChannel.connect(remote);
    }

    @Override
    public <A> void read(final ByteBuffer dst, final long timeout, final TimeUnit unit, final A attachment, final CompletionHandler<Integer, ? super A> handler) {
        if (this.handshake) {
            this.handshakeModel.setHandshakeCallback(new HandshakeCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void callback() {
                    SslAsynchronousSocketChannel.this.handshake = false;
                    SslAsynchronousSocketChannel sslAsynchronousSocketChannel = SslAsynchronousSocketChannel.this;
                    synchronized (sslAsynchronousSocketChannel) {
                        SslAsynchronousSocketChannel.this.handshakeModel.getAppWriteBuffer().clean();
                        SslAsynchronousSocketChannel.this.netReadBuffer.buffer().clear();
                        SslAsynchronousSocketChannel.this.netWriteBuffer.buffer().clear();
                        SslAsynchronousSocketChannel.this.appReadBuffer.buffer().clear().flip();
                        SslAsynchronousSocketChannel.this.notifyAll();
                    }
                    if (SslAsynchronousSocketChannel.this.handshakeModel.isEof()) {
                        handler.completed(-1, attachment);
                    } else {
                        SslAsynchronousSocketChannel.this.read(dst, timeout, unit, attachment, handler);
                    }
                    SslAsynchronousSocketChannel.this.handshakeModel = null;
                }
            });
            this.sslService.doHandshake(this.handshakeModel);
            return;
        }
        ByteBuffer appBuffer = this.appReadBuffer.buffer();
        if (appBuffer.hasRemaining()) {
            int pos = dst.position();
            if (appBuffer.remaining() > dst.remaining()) {
                int limit = appBuffer.limit();
                appBuffer.limit(appBuffer.position() + dst.remaining());
                dst.put(appBuffer);
                appBuffer.limit(limit);
            } else {
                dst.put(appBuffer);
            }
            handler.completed(dst.position() - pos, attachment);
            return;
        }
        this.asynchronousSocketChannel.read(this.netReadBuffer.buffer(), timeout, unit, attachment, new CompletionHandler<Integer, A>(){

            @Override
            public void completed(Integer result, A attachment) {
                int pos = dst.position();
                ByteBuffer appBuffer = SslAsynchronousSocketChannel.this.appReadBuffer.buffer();
                appBuffer.clear();
                SslAsynchronousSocketChannel.this.doUnWrap();
                appBuffer.flip();
                if (appBuffer.remaining() > dst.remaining()) {
                    int limit = appBuffer.limit();
                    appBuffer.limit(appBuffer.position() + dst.remaining());
                    dst.put(appBuffer);
                    appBuffer.limit(limit);
                } else if (appBuffer.hasRemaining()) {
                    dst.put(appBuffer);
                } else if (result > 0) {
                    appBuffer.compact();
                    SslAsynchronousSocketChannel.this.asynchronousSocketChannel.read(SslAsynchronousSocketChannel.this.netReadBuffer.buffer(), timeout, unit, attachment, this);
                    return;
                }
                handler.completed(result != -1 ? dst.position() - pos : result, attachment);
            }

            @Override
            public void failed(Throwable exc, A attachment) {
                handler.failed(exc, attachment);
            }
        });
    }

    private void doUnWrap() {
        try {
            ByteBuffer netBuffer = this.netReadBuffer.buffer();
            ByteBuffer appBuffer = this.appReadBuffer.buffer();
            netBuffer.flip();
            SSLEngineResult result = this.sslEngine.unwrap(netBuffer, appBuffer);
            boolean closed = false;
            while (!closed && result.getStatus() != SSLEngineResult.Status.OK) {
                switch (result.getStatus()) {
                    case BUFFER_OVERFLOW: {
                        logger.warn("BUFFER_OVERFLOW error");
                        break;
                    }
                    case BUFFER_UNDERFLOW: {
                        if (netBuffer.limit() == netBuffer.capacity()) {
                            logger.warn("BUFFER_UNDERFLOW error");
                        } else {
                            if (logger.isDebugEnabled()) {
                                logger.debug("BUFFER_UNDERFLOW,continue read:" + netBuffer);
                            }
                            if (netBuffer.position() > 0) {
                                netBuffer.compact();
                            } else {
                                netBuffer.position(netBuffer.limit());
                                netBuffer.limit(netBuffer.capacity());
                            }
                        }
                        return;
                    }
                    case CLOSED: {
                        logger.warn("doUnWrap Result:" + (Object)((Object)result.getStatus()));
                        closed = true;
                        break;
                    }
                    default: {
                        logger.warn("doUnWrap Result:" + (Object)((Object)result.getStatus()));
                    }
                }
                result = this.sslEngine.unwrap(netBuffer, appBuffer);
            }
            netBuffer.compact();
        }
        catch (SSLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Future<Integer> read(ByteBuffer dst) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <A> void read(ByteBuffer[] dsts, int offset, int length, long timeout, TimeUnit unit, A attachment, CompletionHandler<Long, ? super A> handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <A> void write(final ByteBuffer src, final long timeout, final TimeUnit unit, A attachment, final CompletionHandler<Integer, ? super A> handler) {
        if (this.handshake) {
            this.checkInitialized();
        }
        final int pos = src.position();
        this.doWrap(src);
        this.asynchronousSocketChannel.write(this.netWriteBuffer.buffer(), timeout, unit, attachment, new CompletionHandler<Integer, A>(){

            @Override
            public void completed(Integer result, A attachment) {
                if (result == -1) {
                    System.err.println("aaaaaaaaaaa");
                }
                if (SslAsynchronousSocketChannel.this.netWriteBuffer.buffer().hasRemaining()) {
                    SslAsynchronousSocketChannel.this.asynchronousSocketChannel.write(SslAsynchronousSocketChannel.this.netWriteBuffer.buffer(), timeout, unit, attachment, this);
                } else {
                    handler.completed(src.position() - pos, attachment);
                }
            }

            @Override
            public void failed(Throwable exc, A attachment) {
                handler.failed(exc, attachment);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkInitialized() {
        if (!this.handshake) {
            return;
        }
        SslAsynchronousSocketChannel sslAsynchronousSocketChannel = this;
        synchronized (sslAsynchronousSocketChannel) {
            if (!this.handshake) {
                return;
            }
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void doWrap(ByteBuffer writeBuffer) {
        try {
            ByteBuffer netBuffer = this.netWriteBuffer.buffer();
            netBuffer.compact();
            int limit = writeBuffer.limit();
            if (this.adaptiveWriteSize > 0 && writeBuffer.remaining() > this.adaptiveWriteSize) {
                writeBuffer.limit(writeBuffer.position() + this.adaptiveWriteSize);
            }
            SSLEngineResult result = this.sslEngine.wrap(writeBuffer, netBuffer);
            while (result.getStatus() != SSLEngineResult.Status.OK) {
                switch (result.getStatus()) {
                    case BUFFER_OVERFLOW: {
                        netBuffer.clear();
                        writeBuffer.limit(writeBuffer.position() + (writeBuffer.limit() - writeBuffer.position() >> 1));
                        this.adaptiveWriteSize = writeBuffer.remaining();
                        break;
                    }
                    case BUFFER_UNDERFLOW: {
                        logger.info("doWrap BUFFER_UNDERFLOW");
                        break;
                    }
                    default: {
                        logger.warn("doWrap Result:" + (Object)((Object)result.getStatus()));
                    }
                }
                result = this.sslEngine.wrap(writeBuffer, netBuffer);
            }
            writeBuffer.limit(limit);
            netBuffer.flip();
        }
        catch (SSLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Future<Integer> write(ByteBuffer src) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <A> void write(ByteBuffer[] srcs, int offset, int length, long timeout, TimeUnit unit, A attachment, CompletionHandler<Long, ? super A> handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SocketAddress getLocalAddress() throws IOException {
        return this.asynchronousSocketChannel.getLocalAddress();
    }

    @Override
    public boolean isOpen() {
        return this.asynchronousSocketChannel.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.netWriteBuffer.clean();
        this.netReadBuffer.clean();
        this.appReadBuffer.clean();
        try {
            this.sslEngine.closeInbound();
        }
        catch (SSLException e) {
            logger.warn("ignore closeInbound exception: {}", (Object)e.getMessage());
        }
        this.sslEngine.closeOutbound();
        this.asynchronousSocketChannel.close();
    }
}

