/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.socket.extension.plugins;

import java.io.InputStream;
import java.nio.channels.AsynchronousSocketChannel;
import org.smartboot.socket.buffer.BufferFactory;
import org.smartboot.socket.buffer.BufferPagePool;
import org.smartboot.socket.extension.plugins.AbstractPlugin;
import org.smartboot.socket.extension.ssl.ClientAuth;
import org.smartboot.socket.extension.ssl.SslAsynchronousSocketChannel;
import org.smartboot.socket.extension.ssl.SslService;

public final class SslPlugin<T>
extends AbstractPlugin<T> {
    private SslService sslService;
    private BufferPagePool bufferPagePool;
    private boolean init = false;

    public SslPlugin() {
        this.bufferPagePool = BufferFactory.DISABLED_BUFFER_FACTORY.create();
    }

    public SslPlugin(BufferPagePool bufferPagePool) {
        this.bufferPagePool = bufferPagePool;
    }

    public void initForServer(InputStream keyStoreInputStream, String keyStorePassword, String keyPassword, ClientAuth clientAuth) {
        this.initCheck();
        this.sslService = new SslService(false, clientAuth);
        this.sslService.initKeyStore(keyStoreInputStream, keyStorePassword, keyPassword);
    }

    public void initForClient() {
        this.initForClient(null, null);
    }

    public void initForClient(InputStream trustInputStream, String trustPassword) {
        this.initCheck();
        this.sslService = new SslService(true, null);
        this.sslService.initTrust(trustInputStream, trustPassword);
    }

    private void initCheck() {
        if (this.init) {
            throw new RuntimeException("plugin is already init");
        }
        this.init = true;
    }

    @Override
    public final AsynchronousSocketChannel shouldAccept(AsynchronousSocketChannel channel) {
        return new SslAsynchronousSocketChannel(channel, this.sslService, this.bufferPagePool.allocateBufferPage());
    }
}

