/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.analysis;

import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.PriorityQueue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.AccessFlags;
import org.jf.dexlib2.analysis.AnalyzedMethodUtil;
import org.jf.dexlib2.analysis.ClassPath;
import org.jf.dexlib2.analysis.TypeProto;
import org.jf.dexlib2.analysis.UnresolvedClassException;
import org.jf.dexlib2.analysis.util.TypeProtoUtils;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.Field;
import org.jf.dexlib2.iface.Method;
import org.jf.dexlib2.iface.reference.FieldReference;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.immutable.ImmutableMethod;
import org.jf.dexlib2.util.MethodUtil;
import org.jf.util.AlignmentUtils;
import org.jf.util.ExceptionWithContext;
import org.jf.util.SparseArray;

public class ClassProto
implements TypeProto {
    private static final byte REFERENCE = 0;
    private static final byte WIDE = 1;
    private static final byte OTHER = 2;
    @Nonnull
    protected final ClassPath classPath;
    @Nonnull
    protected final String type;
    protected boolean vtableFullyResolved = true;
    protected boolean interfacesFullyResolved = true;
    @Nonnull
    private final Supplier<ClassDef> classDefSupplier = Suppliers.memoize((Supplier)new Supplier<ClassDef>(){

        public ClassDef get() {
            return ClassProto.this.classPath.getClassDef(ClassProto.this.type);
        }
    });
    @Nonnull
    private final Supplier<LinkedHashMap<String, ClassDef>> interfacesSupplier = Suppliers.memoize((Supplier)new Supplier<LinkedHashMap<String, ClassDef>>(){

        public LinkedHashMap<String, ClassDef> get() {
            LinkedHashMap interfaces = Maps.newLinkedHashMap();
            try {
                for (String interfaceType : ClassProto.this.getClassDef().getInterfaces()) {
                    if (interfaces.containsKey(interfaceType)) continue;
                    try {
                        ClassDef interfaceDef = ClassProto.this.classPath.getClassDef(interfaceType);
                        interfaces.put(interfaceType, interfaceDef);
                    }
                    catch (UnresolvedClassException ex) {
                        interfaces.put(interfaceType, null);
                        ClassProto.this.interfacesFullyResolved = false;
                    }
                    ClassProto interfaceProto = (ClassProto)ClassProto.this.classPath.getClass(interfaceType);
                    for (String superInterface : interfaceProto.getInterfaces().keySet()) {
                        if (interfaces.containsKey(superInterface)) continue;
                        interfaces.put(superInterface, interfaceProto.getInterfaces().get(superInterface));
                    }
                    if (interfaceProto.interfacesFullyResolved) continue;
                    ClassProto.this.interfacesFullyResolved = false;
                }
            }
            catch (UnresolvedClassException ex) {
                ClassProto.this.interfacesFullyResolved = false;
            }
            if (ClassProto.this.isInterface() && !interfaces.containsKey(ClassProto.this.getType())) {
                interfaces.put(ClassProto.this.getType(), null);
            }
            try {
                String superclass = ClassProto.this.getSuperclass();
                if (superclass != null) {
                    ClassProto superclassProto = (ClassProto)ClassProto.this.classPath.getClass(superclass);
                    for (String superclassInterface : superclassProto.getInterfaces().keySet()) {
                        if (interfaces.containsKey(superclassInterface)) continue;
                        interfaces.put(superclassInterface, null);
                    }
                    if (!superclassProto.interfacesFullyResolved) {
                        ClassProto.this.interfacesFullyResolved = false;
                    }
                }
            }
            catch (UnresolvedClassException ex) {
                ClassProto.this.interfacesFullyResolved = false;
            }
            return interfaces;
        }
    });
    @Nonnull
    private final Supplier<SparseArray<FieldReference>> dalvikInstanceFieldsSupplier = Suppliers.memoize((Supplier)new Supplier<SparseArray<FieldReference>>(){

        public SparseArray<FieldReference> get() {
            int fieldOffset;
            int front;
            ArrayList<Field> fields = this.getSortedInstanceFields(ClassProto.this.getClassDef());
            int fieldCount = fields.size();
            byte[] fieldTypes = new byte[fields.size()];
            for (int i = 0; i < fieldCount; ++i) {
                fieldTypes[i] = ClassProto.getFieldType(fields.get(i));
            }
            int back = fields.size() - 1;
            for (front = 0; front < fieldCount; ++front) {
                if (fieldTypes[front] != 0) {
                    while (back > front) {
                        if (fieldTypes[back] == 0) {
                            this.swap(fieldTypes, fields, front, back--);
                            break;
                        }
                        --back;
                    }
                }
                if (fieldTypes[front] != 0) break;
            }
            int startFieldOffset = 8;
            String superclassType = ClassProto.this.getSuperclass();
            ClassProto superclass = null;
            if (superclassType != null && (superclass = (ClassProto)ClassProto.this.classPath.getClass(superclassType)) != null) {
                startFieldOffset = superclass.getNextFieldOffset();
            }
            int fieldIndexMod = startFieldOffset % 8 == 0 ? 0 : 1;
            if (front < fieldCount && front % 2 != fieldIndexMod) {
                if (fieldTypes[front] == 1) {
                    for (back = fieldCount - 1; back > front; --back) {
                        if (fieldTypes[back] != 2) continue;
                        this.swap(fieldTypes, fields, front++, back);
                        break;
                    }
                } else {
                    ++front;
                }
            }
            back = fieldCount - 1;
            while (front < fieldCount) {
                if (fieldTypes[front] != 1) {
                    while (back > front) {
                        if (fieldTypes[back] == 1) {
                            this.swap(fieldTypes, fields, front, back--);
                            break;
                        }
                        --back;
                    }
                }
                if (fieldTypes[front] != 1) break;
                ++front;
            }
            SparseArray superFields = superclass != null ? superclass.getInstanceFields() : new SparseArray();
            int superFieldCount = superFields.size();
            int totalFieldCount = superFieldCount + fieldCount;
            SparseArray instanceFields = new SparseArray(totalFieldCount);
            if (superclass != null && superFieldCount > 0) {
                for (int i = 0; i < superFieldCount; ++i) {
                    instanceFields.append(superFields.keyAt(i), superFields.valueAt(i));
                }
                fieldOffset = instanceFields.keyAt(superFieldCount - 1);
                FieldReference lastSuperField = (FieldReference)superFields.valueAt(superFieldCount - 1);
                char fieldType = lastSuperField.getType().charAt(0);
                fieldOffset = fieldType == 'J' || fieldType == 'D' ? (fieldOffset += 8) : (fieldOffset += 4);
            } else {
                fieldOffset = 8;
            }
            boolean gotDouble = false;
            for (int i = 0; i < fieldCount; ++i) {
                FieldReference field = fields.get(i);
                if (fieldTypes[i] == 1 && !gotDouble && !gotDouble) {
                    if (fieldOffset % 8 != 0) {
                        assert (fieldOffset % 8 == 4);
                        fieldOffset += 4;
                    }
                    gotDouble = true;
                }
                instanceFields.append(fieldOffset, (Object)field);
                if (fieldTypes[i] == 1) {
                    fieldOffset += 8;
                    continue;
                }
                fieldOffset += 4;
            }
            return instanceFields;
        }

        @Nonnull
        private ArrayList<Field> getSortedInstanceFields(@Nonnull ClassDef classDef) {
            ArrayList fields = Lists.newArrayList(classDef.getInstanceFields());
            Collections.sort(fields);
            return fields;
        }

        private void swap(byte[] fieldTypes, List<Field> fields, int position1, int position2) {
            byte tempType = fieldTypes[position1];
            fieldTypes[position1] = fieldTypes[position2];
            fieldTypes[position2] = tempType;
            Field tempField = fields.set(position1, fields.get(position2));
            fields.set(position2, tempField);
        }
    });
    @Nonnull
    private final Supplier<SparseArray<FieldReference>> artInstanceFieldsSupplier = Suppliers.memoize((Supplier)new Supplier<SparseArray<FieldReference>>(){

        public SparseArray<FieldReference> get() {
            PriorityQueue<FieldGap> gaps = new PriorityQueue<FieldGap>();
            SparseArray linkedFields = new SparseArray();
            ArrayList<Field> fields = this.getSortedInstanceFields(ClassProto.this.getClassDef());
            int fieldOffset = 0;
            String superclassType = ClassProto.this.getSuperclass();
            if (superclassType != null) {
                ClassProto superclass = (ClassProto)ClassProto.this.classPath.getClass(superclassType);
                SparseArray<FieldReference> superFields = superclass.getInstanceFields();
                FieldReference field = null;
                int lastOffset = 0;
                for (int i = 0; i < superFields.size(); ++i) {
                    int offset = superFields.keyAt(i);
                    field = (FieldReference)superFields.valueAt(i);
                    linkedFields.put(offset, (Object)field);
                    lastOffset = offset;
                }
                if (field != null) {
                    fieldOffset = lastOffset + this.getFieldSize(field);
                }
            }
            for (Field field : fields) {
                FieldGap gap;
                int fieldSize = this.getFieldSize(field);
                if (!AlignmentUtils.isAligned((int)fieldOffset, (int)fieldSize)) {
                    int oldOffset = fieldOffset;
                    fieldOffset = AlignmentUtils.alignOffset((int)fieldOffset, (int)fieldSize);
                    this.addFieldGap(oldOffset, fieldOffset, gaps);
                }
                if ((gap = (FieldGap)gaps.peek()) != null && gap.size >= fieldSize) {
                    gaps.poll();
                    linkedFields.put(gap.offset, (Object)field);
                    if (gap.size <= fieldSize) continue;
                    this.addFieldGap(gap.offset + fieldSize, gap.offset + gap.size, gaps);
                    continue;
                }
                linkedFields.append(fieldOffset, (Object)field);
                fieldOffset += fieldSize;
            }
            return linkedFields;
        }

        private void addFieldGap(int gapStart, int gapEnd, @Nonnull PriorityQueue<FieldGap> gaps) {
            int offset = gapStart;
            while (offset < gapEnd) {
                int remaining = gapEnd - offset;
                if (remaining >= 4 && offset % 4 == 0) {
                    gaps.add(FieldGap.newFieldGap(offset, 4, ClassProto.this.classPath.oatVersion));
                    offset += 4;
                    continue;
                }
                if (remaining >= 2 && offset % 2 == 0) {
                    gaps.add(FieldGap.newFieldGap(offset, 2, ClassProto.this.classPath.oatVersion));
                    offset += 2;
                    continue;
                }
                gaps.add(FieldGap.newFieldGap(offset, 1, ClassProto.this.classPath.oatVersion));
                ++offset;
            }
        }

        @Nonnull
        private ArrayList<Field> getSortedInstanceFields(@Nonnull ClassDef classDef) {
            ArrayList fields = Lists.newArrayList(classDef.getInstanceFields());
            Collections.sort(fields, new Comparator<Field>(){

                @Override
                public int compare(Field field1, Field field2) {
                    int result = Ints.compare((int)this.getFieldSortOrder(field1), (int)this.getFieldSortOrder(field2));
                    if (result != 0) {
                        return result;
                    }
                    result = field1.getName().compareTo(field2.getName());
                    if (result != 0) {
                        return result;
                    }
                    return field1.getType().compareTo(field2.getType());
                }
            });
            return fields;
        }

        private int getFieldSortOrder(@Nonnull FieldReference field) {
            switch (field.getType().charAt(0)) {
                case 'L': 
                case '[': {
                    return 0;
                }
                case 'J': {
                    return 1;
                }
                case 'D': {
                    return 2;
                }
                case 'I': {
                    return 3;
                }
                case 'F': {
                    return 4;
                }
                case 'C': {
                    return 5;
                }
                case 'S': {
                    return 6;
                }
                case 'Z': {
                    return 7;
                }
                case 'B': {
                    return 8;
                }
            }
            throw new ExceptionWithContext("Invalid field type: %s", new Object[]{field.getType()});
        }

        private int getFieldSize(@Nonnull FieldReference field) {
            return ClassProto.getTypeSize(field.getType().charAt(0));
        }
    });
    @Nonnull
    private final Supplier<List<Method>> vtableSupplier = Suppliers.memoize((Supplier)new Supplier<List<Method>>(){

        public List<Method> get() {
            String superclassType;
            ArrayList vtable = Lists.newArrayList();
            try {
                superclassType = ClassProto.this.getSuperclass();
            }
            catch (UnresolvedClassException ex) {
                vtable.addAll(((ClassProto)ClassProto.this.classPath.getClass("Ljava/lang/Object;")).getVtable());
                ClassProto.this.vtableFullyResolved = false;
                return vtable;
            }
            if (superclassType != null) {
                ClassProto superclass = (ClassProto)ClassProto.this.classPath.getClass(superclassType);
                vtable.addAll(superclass.getVtable());
                if (!superclass.vtableFullyResolved) {
                    ClassProto.this.vtableFullyResolved = false;
                    return vtable;
                }
            }
            if (!ClassProto.this.isInterface()) {
                this.addToVtable(ClassProto.this.getClassDef().getVirtualMethods(), vtable, true);
                for (ClassDef interfaceDef : ClassProto.this.getDirectInterfaces()) {
                    ArrayList interfaceMethods = Lists.newArrayList();
                    for (Method method : interfaceDef.getVirtualMethods()) {
                        ImmutableMethod method2 = new ImmutableMethod(ClassProto.this.type, method.getName(), method.getParameters(), method.getReturnType(), method.getAccessFlags(), method.getAnnotations(), method.getImplementation());
                        interfaceMethods.add(method2);
                    }
                    this.addToVtable(interfaceMethods, vtable, false);
                }
            }
            return vtable;
        }

        private void addToVtable(@Nonnull Iterable<? extends Method> localMethods, @Nonnull List<Method> vtable, boolean replaceExisting) {
            ArrayList methods = Lists.newArrayList(localMethods);
            Collections.sort(methods);
            block0: for (Method virtualMethod : methods) {
                for (int i = 0; i < vtable.size(); ++i) {
                    Method superMethod = vtable.get(i);
                    if (!MethodUtil.methodSignaturesMatch(superMethod, virtualMethod) || ClassProto.this.classPath.shouldCheckPackagePrivateAccess() && !AnalyzedMethodUtil.canAccess(ClassProto.this, superMethod, true, false, false)) continue;
                    if (!replaceExisting) continue block0;
                    vtable.set(i, virtualMethod);
                    continue block0;
                }
                vtable.add(virtualMethod);
            }
        }
    });

    public ClassProto(@Nonnull ClassPath classPath, @Nonnull String type) {
        if (type.charAt(0) != 'L') {
            throw new ExceptionWithContext("Cannot construct ClassProto for non reference type: %s", new Object[]{type});
        }
        this.classPath = classPath;
        this.type = type;
    }

    public String toString() {
        return this.type;
    }

    @Override
    @Nonnull
    public ClassPath getClassPath() {
        return this.classPath;
    }

    @Override
    @Nonnull
    public String getType() {
        return this.type;
    }

    @Nonnull
    public ClassDef getClassDef() {
        return (ClassDef)this.classDefSupplier.get();
    }

    @Override
    public boolean isInterface() {
        ClassDef classDef = this.getClassDef();
        return (classDef.getAccessFlags() & AccessFlags.INTERFACE.getValue()) != 0;
    }

    @Nonnull
    protected LinkedHashMap<String, ClassDef> getInterfaces() {
        return (LinkedHashMap)this.interfacesSupplier.get();
    }

    @Nonnull
    protected Iterable<ClassDef> getDirectInterfaces() {
        FluentIterable directInterfaces = FluentIterable.from(this.getInterfaces().values()).filter(Predicates.notNull());
        if (!this.interfacesFullyResolved) {
            throw new UnresolvedClassException("Interfaces for class %s not fully resolved", this.getType());
        }
        return directInterfaces;
    }

    @Override
    public boolean implementsInterface(@Nonnull String iface) {
        if (this.getInterfaces().containsKey(iface)) {
            return true;
        }
        if (!this.interfacesFullyResolved) {
            throw new UnresolvedClassException("Interfaces for class %s not fully resolved", this.getType());
        }
        return false;
    }

    @Override
    @Nullable
    public String getSuperclass() {
        return this.getClassDef().getSuperclass();
    }

    private boolean checkInterface(@Nonnull ClassProto other) {
        block6: {
            boolean isResolved = true;
            boolean isInterface = true;
            try {
                isInterface = this.isInterface();
            }
            catch (UnresolvedClassException ex) {
                isResolved = false;
            }
            if (isInterface) {
                try {
                    if (other.implementsInterface(this.getType())) {
                        return true;
                    }
                }
                catch (UnresolvedClassException ex) {
                    if (!isResolved) break block6;
                    throw ex;
                }
            }
        }
        return false;
    }

    @Override
    @Nonnull
    public TypeProto getCommonSuperclass(@Nonnull TypeProto other) {
        if (!(other instanceof ClassProto)) {
            return other.getCommonSuperclass(this);
        }
        if (this == other || this.getType().equals(other.getType())) {
            return this;
        }
        if (this.getType().equals("Ljava/lang/Object;")) {
            return this;
        }
        if (other.getType().equals("Ljava/lang/Object;")) {
            return other;
        }
        boolean gotException = false;
        try {
            if (this.checkInterface((ClassProto)other)) {
                return this;
            }
        }
        catch (UnresolvedClassException ex) {
            gotException = true;
        }
        try {
            if (((ClassProto)other).checkInterface(this)) {
                return other;
            }
        }
        catch (UnresolvedClassException ex) {
            gotException = true;
        }
        if (gotException) {
            return this.classPath.getUnknownClass();
        }
        List thisChain = Lists.newArrayList((Object[])new TypeProto[]{this});
        Iterables.addAll((Collection)thisChain, TypeProtoUtils.getSuperclassChain(this));
        List otherChain = Lists.newArrayList((Object[])new TypeProto[]{other});
        Iterables.addAll((Collection)otherChain, TypeProtoUtils.getSuperclassChain(other));
        thisChain = Lists.reverse((List)thisChain);
        otherChain = Lists.reverse((List)otherChain);
        for (int i = Math.min(thisChain.size(), otherChain.size()) - 1; i >= 0; --i) {
            TypeProto typeProto = (TypeProto)thisChain.get(i);
            if (!typeProto.getType().equals(((TypeProto)otherChain.get(i)).getType())) continue;
            return typeProto;
        }
        return this.classPath.getUnknownClass();
    }

    @Override
    @Nullable
    public FieldReference getFieldByOffset(int fieldOffset) {
        if (this.getInstanceFields().size() == 0) {
            return null;
        }
        return (FieldReference)this.getInstanceFields().get(fieldOffset);
    }

    @Override
    @Nullable
    public Method getMethodByVtableIndex(int vtableIndex) {
        List<Method> vtable = this.getVtable();
        if (vtableIndex < 0 || vtableIndex >= vtable.size()) {
            return null;
        }
        return vtable.get(vtableIndex);
    }

    @Override
    public int findMethodIndexInVtable(@Nonnull MethodReference method) {
        List<Method> vtable = this.getVtable();
        for (int i = 0; i < vtable.size(); ++i) {
            Method candidate = vtable.get(i);
            if (!MethodUtil.methodSignaturesMatch(candidate, method) || this.classPath.shouldCheckPackagePrivateAccess() && !AnalyzedMethodUtil.canAccess(this, candidate, true, false, false)) continue;
            return i;
        }
        return -1;
    }

    @Nonnull
    SparseArray<FieldReference> getInstanceFields() {
        if (this.classPath.isArt()) {
            return (SparseArray)this.artInstanceFieldsSupplier.get();
        }
        return (SparseArray)this.dalvikInstanceFieldsSupplier.get();
    }

    private int getNextFieldOffset() {
        SparseArray<FieldReference> instanceFields = this.getInstanceFields();
        if (instanceFields.size() == 0) {
            return this.classPath.isArt() ? 0 : 8;
        }
        int lastItemIndex = instanceFields.size() - 1;
        int fieldOffset = instanceFields.keyAt(lastItemIndex);
        FieldReference lastField = (FieldReference)instanceFields.valueAt(lastItemIndex);
        if (this.classPath.isArt()) {
            return fieldOffset + ClassProto.getTypeSize(lastField.getType().charAt(0));
        }
        switch (lastField.getType().charAt(0)) {
            case 'D': 
            case 'J': {
                return fieldOffset + 8;
            }
        }
        return fieldOffset + 4;
    }

    private static int getTypeSize(char type) {
        switch (type) {
            case 'D': 
            case 'J': {
                return 8;
            }
            case 'F': 
            case 'I': 
            case 'L': 
            case '[': {
                return 4;
            }
            case 'C': 
            case 'S': {
                return 2;
            }
            case 'B': 
            case 'Z': {
                return 1;
            }
        }
        throw new ExceptionWithContext("Invalid type: %s", new Object[]{Character.valueOf(type)});
    }

    @Nonnull
    List<Method> getVtable() {
        return (List)this.vtableSupplier.get();
    }

    private static byte getFieldType(@Nonnull FieldReference field) {
        switch (field.getType().charAt(0)) {
            case 'L': 
            case '[': {
                return 0;
            }
            case 'D': 
            case 'J': {
                return 1;
            }
        }
        return 2;
    }

    private static abstract class FieldGap
    implements Comparable<FieldGap> {
        public final int offset;
        public final int size;

        public static FieldGap newFieldGap(int offset, int size, int oatVersion) {
            if (oatVersion >= 67) {
                return new FieldGap(offset, size){

                    @Override
                    public int compareTo(FieldGap o) {
                        int result = Ints.compare((int)o.size, (int)this.size);
                        if (result != 0) {
                            return result;
                        }
                        return Ints.compare((int)this.offset, (int)o.offset);
                    }
                };
            }
            return new FieldGap(offset, size){

                @Override
                public int compareTo(FieldGap o) {
                    int result = Ints.compare((int)this.size, (int)o.size);
                    if (result != 0) {
                        return result;
                    }
                    return Ints.compare((int)o.offset, (int)this.offset);
                }
            };
        }

        private FieldGap(int offset, int size) {
            this.offset = offset;
            this.size = size;
        }
    }
}

