/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.jsonassert;

public class JSONCompareResult {
    private boolean _success;
    private String _message;
    private String _field;
    private Object _expected;
    private Object _actual;

    public JSONCompareResult() {
        this(true, null);
    }

    private JSONCompareResult(boolean success, String message) {
        this._success = success;
        this._message = message == null ? "" : message;
    }

    public boolean passed() {
        return this._success;
    }

    public boolean failed() {
        return !this._success;
    }

    public String getMessage() {
        return this._message;
    }

    public Object getActual() {
        return this._actual;
    }

    public Object getExpected() {
        return this._expected;
    }

    public boolean isFailureOnField() {
        return this._field != null;
    }

    public String getField() {
        return this._field;
    }

    protected void fail(String message) {
        this._success = false;
        this._message = this._message.length() == 0 ? message : this._message + " ; " + message;
    }

    protected void fail(String field, Object expected, Object actual) {
        this._field = field;
        this._expected = expected;
        this._actual = actual;
        this.fail(this.formatFailureMessage(field, expected, actual));
    }

    private String formatFailureMessage(String field, Object expected, Object actual) {
        StringBuffer message = new StringBuffer();
        message.append(field);
        message.append("\nExpected: ");
        message.append(expected + "");
        message.append("\n     got: ");
        message.append(actual + "");
        message.append("\n");
        return message.toString();
    }
}

