/*
 * Decompiled with CFR 0.152.
 */
package org.skynetsoftware.fontwidgets;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.os.Environment;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.widget.TextView;
import com.pedja1.fontwidget.lib.R;
import java.io.File;
import java.util.HashMap;
import org.skynetsoftware.fontwidgets.Logger;

public class TypefaceHolder {
    public static final String LOG_TAG = "FontWidgets:TfaceHolder";
    private static TypefaceHolder typefaceHolder = null;
    private String defaultFont = null;
    private HashMap<String, Typeface> typefaceStore = new HashMap();

    public static TypefaceHolder getInstance() {
        if (typefaceHolder == null) {
            typefaceHolder = new TypefaceHolder();
        }
        return typefaceHolder;
    }

    private TypefaceHolder() {
    }

    public Typeface getTypeface(Context context, String fontName, Source source) {
        if (TextUtils.isEmpty((CharSequence)fontName)) {
            if (this.defaultFont != null) {
                return this.typefaceStore.get(this.defaultFont);
            }
            Log.w((String)LOG_TAG, (String)"fontName is null, using default typeface");
            return Typeface.DEFAULT;
        }
        if (source == null) {
            source = Source.asset;
            Logger.w(LOG_TAG, "null source passed, assuming 'asset' is the source");
        }
        if (this.typefaceStore.containsKey(fontName)) {
            return this.typefaceStore.get(fontName);
        }
        Typeface tmp = null;
        switch (source) {
            case asset: {
                if (context == null) {
                    throw new IllegalArgumentException("Context is null. You can only pass null context if you use 'internal' or 'absolute' source");
                }
                tmp = Typeface.createFromAsset((AssetManager)context.getApplicationContext().getResources().getAssets(), (String)fontName);
                break;
            }
            case internal: {
                File internalStoragePath = Environment.getDataDirectory();
                tmp = Typeface.createFromFile((File)new File(internalStoragePath, fontName));
                break;
            }
            case absolute: {
                tmp = Typeface.createFromFile((File)new File(fontName));
            }
        }
        if (tmp != null) {
            this.typefaceStore.put(fontName, tmp);
        } else {
            Logger.e(LOG_TAG, "Unable to create typeface");
        }
        return tmp;
    }

    public void setTypeface(TextView textView, AttributeSet attrs) {
        if (textView.isInEditMode()) {
            return;
        }
        TypedArray a = textView.getContext().obtainStyledAttributes(attrs, R.styleable.Typeface);
        String typefaceName = a.getString(R.styleable.Typeface_fw_font);
        int sourceInt = a.getInt(R.styleable.Typeface_fw_source, -1);
        Source source = null;
        switch (sourceInt) {
            case 0: {
                source = Source.asset;
                break;
            }
            case 1: {
                source = Source.internal;
                break;
            }
            case 2: {
                source = Source.absolute;
            }
        }
        int style = a.getInt(R.styleable.Typeface_fw_fontStyle, -1);
        if (source == null) {
            source = Source.asset;
        }
        textView.setTypeface(this.getTypeface(textView.getContext(), typefaceName, source), style);
        a.recycle();
    }

    public HashMap<String, Typeface> getTypefaceStore() {
        return this.typefaceStore;
    }

    public void setDefaultFont(String fontName, Source source, Context context) {
        if (fontName == null) {
            return;
        }
        this.defaultFont = fontName;
        source = source == null ? Source.asset : source;
        this.typefaceStore.put(this.defaultFont, this.getTypeface(context, fontName, source));
    }

    public String getDefaultFont() {
        return this.defaultFont;
    }

    public static enum Source {
        asset,
        internal,
        absolute;

    }
}

