package org.skynetsoftware.fontwidgets.widget.appcompat;

import android.content.Context;
import android.support.v7.widget.AppCompatTextView;
import android.util.AttributeSet;

import org.skynetsoftware.fontwidgets.TypefaceHolder;

/**
 * Created by pedja on 7/15/13 10.17.
 * This class is part of the ${PROJECT_NAME}
 * Copyright © 2014 ${OWNER}
 */
public class FTextView extends AppCompatTextView
{
    public FTextView(Context context, AttributeSet attrs)
    {
        super(context, attrs);
        TypefaceHolder.getInstance().setTypeface(this, attrs);
    }

    public FTextView(Context context, AttributeSet attrs, int defStyle)
    {
        super(context, attrs, defStyle);
        TypefaceHolder.getInstance().setTypeface(this, attrs);
    }

    public FTextView(Context context)
    {
        super(context);
    }

    public void setTypeface(String assetName)
    {
        if(isInEditMode())return;
        setTypeface(TypefaceHolder.getInstance().getTypeface(getContext(), assetName, TypefaceHolder.Source.asset));
    }

    public void setTypeface(String assetName, TypefaceHolder.Source source)
    {
        if(isInEditMode())return;
        setTypeface(TypefaceHolder.getInstance().getTypeface(getContext(), assetName, source));
    }
}
